-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [INSTANCE_VALUE] (
    [ID]                           decimal (38) NOT NULL
    , [VALUE]                        varchar(256)        NULL
    , [OI_ID]                        decimal (38)    NOT NULL
    , [WTP_ID]                       decimal (38)    NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_INSTANCE_VALUE
ON [INSTANCE_VALUE]([ID]);
go
CREATE VIEW SCI_INSTANCE_VALUE AS
SELECT 
    ID 
    , [VALUE]                        AS [VALUE]
    , [OI_ID]                        AS [OI_ID]
    , [WTP_ID]                       AS [WTP_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [INSTANCE_VALUE];
go
