-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [TRIGGER_QUEUE] (
    [ID]                           decimal (38) NOT NULL
    , [SME_ID]                       decimal (38)    NOT NULL
    , [TR_ID]                        decimal (38)    NOT NULL
    , [NEXT_TRIGGER_TIME]            decimal (38)    NOT NULL
    , [TIMES_CHECKED]                integer         NOT NULL
    , [TIMES_TRIGGERED]              integer         NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_TRIGGER_QUEUE
ON [TRIGGER_QUEUE]([ID]);
go
CREATE VIEW SCI_TRIGGER_QUEUE AS
SELECT 
    ID 
    , [SME_ID]                       AS [SME_ID]
    , [TR_ID]                        AS [TR_ID]
    , [NEXT_TRIGGER_TIME]            AS [NEXT_TRIGGER_TIME]
    , [TIMES_CHECKED]                AS [TIMES_CHECKED]
    , [TIMES_TRIGGERED]              AS [TIMES_TRIGGERED]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [TRIGGER_QUEUE];
go
