-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [TRIGGER_STATE] (
    [ID]                           decimal (38) NOT NULL
    , [TRIGGER_ID]                   decimal (38)    NOT NULL
    , [FROM_STATE_ID]                decimal (38)        NULL
    , [TO_STATE_ID]                  decimal (38)        NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
    , [VALID_FROM]                 decimal (38) NOT NULL
    , [VALID_TO]                   decimal (38) NOT NULL
);
go
CREATE INDEX PK_TRIGGER_STATE
ON [TRIGGER_STATE]([ID]);
go
CREATE VIEW SCI_C_TRIGGER_STATE AS
SELECT 
    ID 
    , [TRIGGER_ID]                   AS [TRIGGER_ID]
    , [FROM_STATE_ID]                AS [FROM_STATE_ID]
    , [TO_STATE_ID]                  AS [TO_STATE_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [TRIGGER_STATE]
 WHERE VALID_TO = 9223372036854775807;
go
CREATE VIEW SCI_V_TRIGGER_STATE AS
SELECT 
    ID 
    , [TRIGGER_ID]                   AS [TRIGGER_ID]
    , [FROM_STATE_ID]                AS [FROM_STATE_ID]
    , [TO_STATE_ID]                  AS [TO_STATE_ID]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , VALID_FROM
    , VALID_TO
  FROM [TRIGGER_STATE];
go
