-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE_PROFILE (
    ID                             NUMBER (38) NOT NULL
    , NAME                           VARCHAR2 (64 CHAR)   NOT NULL
    , DEFAULT_ESMP_ID                NUMBER (38)              NULL
    , IS_VALID                       NUMBER (1)           NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
    , VALID_FROM                   NUMBER (38) NOT NULL
    , VALID_TO                     NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_EXIT_STATE_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM EXIT_STATE_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_EXIT_STATE_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_PROFILE;
