-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE GRANTS (
    ID                             NUMBER (38) PRIMARY KEY
    , OBJECT_ID                      NUMBER (38)          NOT NULL
    , G_ID                           NUMBER (38)          NOT NULL
    , OBJECT_TYPE                    NUMBER (38)          NOT NULL
    , PRIVS                          NUMBER (38)          NOT NULL
    , DELETE_VERSION                 NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_GRANTS AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , G_ID                           AS G_ID
    , DECODE (OBJECT_TYPE, 1, 'ENVIRONMENT', 18, 'EVENT', 6, 'FOLDER', 19, 'INTERVAL', 17, 'JOB', 9, 'JOB_DEFINITION', 10, 'NAMED_RESOURCE', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 15, 'SCOPE', 21, 'GROUP', 11, 'RESOURCE', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 7, 'FOOTPRINT', 8, 'USER', 30, 'OBJECT_MONITOR', 0, 'SYSTEM') AS OBJECT_TYPE
    , PRIVS                          AS PRIVS
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM GRANTS;
