-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_QUEUE (
    ID                             NUMBER (38) PRIMARY KEY
    , SME_ID                         NUMBER (38)          NOT NULL
    , TR_ID                          NUMBER (38)          NOT NULL
    , NEXT_TRIGGER_TIME              NUMBER (38)          NOT NULL
    , TIMES_CHECKED                  NUMBER (38)          NOT NULL
    , TIMES_TRIGGERED                NUMBER (38)          NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_TRIGGER_QUEUE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , TR_ID                          AS TR_ID
    , NEXT_TRIGGER_TIME              AS NEXT_TRIGGER_TIME
    , TIMES_CHECKED                  AS TIMES_CHECKED
    , TIMES_TRIGGERED                AS TIMES_TRIGGERED
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM TRIGGER_QUEUE;
