/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.SDMSDesktop;

import de.independit.scheduler.SDMSDesktop.SDMSDesktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class SDMSDesktopWindow
extends JInternalFrame {
    public static final String __version = "@(#) $Id: SDMSDesktopWindow.java,v 2.0.20.1 2013/03/14 10:24:03 ronald Exp $";
    static final Color inactiveColor = Color.LIGHT_GRAY;
    static final Color activeColor = Color.WHITE;
    public boolean doesRefresh = false;
    public boolean doesCreate = false;
    public boolean doesRename = false;
    public boolean doesDrop = false;
    protected JButton toolBarButton;
    protected JCheckBoxMenuItem menuItem;
    protected JToolBar toolBar;
    protected boolean initialized;
    SDMSDesktop desktop;

    public SDMSDesktopWindow(SDMSDesktop sDMSDesktop, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, bl, bl2, bl3, bl4);
        this.desktop = sDMSDesktop;
        this.menuItem = new JCheckBoxMenuItem(this.title);
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SDMSDesktopWindow.this.isVisible()) {
                    SDMSDesktopWindow.this.hideWindow();
                } else {
                    SDMSDesktopWindow.this.showWindow();
                }
            }
        });
        sDMSDesktop.windowsMenu.add(this.menuItem);
        this.toolBarButton = new JButton();
        this.toolBarButton.setToolTipText("Show " + this.title + " Window");
        this.toolBarButton.setFocusable(false);
        this.toolBarButton.setBackground(inactiveColor);
        this.toolBarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SDMSDesktopWindow.this.isVisible()) {
                    SDMSDesktopWindow.this.hideWindow();
                } else {
                    SDMSDesktopWindow.this.showWindow();
                }
            }
        });
        sDMSDesktop.toolBar.add(this.toolBarButton);
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                SDMSDesktopWindow.this.hideWindow();
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                System.out.println("Aha!");
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            }
        });
        this.initialized = false;
        this.toolBar = new JToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
    }

    public void showWindow() {
        this.toolBarButton.setBackground(activeColor);
        this.toolBarButton.setToolTipText("Hide " + this.title + " Window");
        this.menuItem.setSelected(true);
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        Rectangle rectangle = this.desktop.viewport.getViewRect();
        Rectangle rectangle2 = this.getBounds();
        if (rectangle.x > rectangle2.x || rectangle.x + rectangle.width < rectangle2.x + rectangle2.width || rectangle.y > rectangle2.y || rectangle.y + rectangle.height < rectangle2.y + rectangle2.height) {
            Point point = new Point(rectangle2.x, rectangle2.y);
            if (rectangle.width > rectangle2.width) {
                point.x = rectangle2.x + rectangle2.width / 2 - rectangle.width / 2;
                if (point.x < 0) {
                    point.x = 0;
                }
            }
            if (rectangle.height > rectangle2.height) {
                point.y = rectangle2.y + rectangle2.height / 2 - rectangle.height / 2;
                if (point.y < 0) {
                    point.y = 0;
                }
            }
            this.desktop.viewport.setViewPosition(point);
        }
        this.show();
    }

    public void hideWindow() {
        this.toolBarButton.setToolTipText("Show " + this.title + " Window");
        this.toolBarButton.setBackground(inactiveColor);
        this.menuItem.setSelected(false);
        if (this.isIcon()) {
            try {
                this.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.setVisible(false);
    }

    public void initialize() {
        JButton jButton;
        if (this.doesRefresh) {
            jButton = new JButton(new ImageIcon(SDMSDesktop.class.getResource("RefreshIconSmall.gif")));
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SDMSDesktopWindow.this.refresh();
                }
            });
            this.toolBar.add(jButton);
        }
        if (this.doesCreate) {
            jButton = new JButton(new ImageIcon(SDMSDesktop.class.getResource("CreateIconSmall.gif")));
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SDMSDesktopWindow.this.create();
                }
            });
            this.toolBar.add(jButton);
        }
        if (this.doesRename) {
            jButton = new JButton(new ImageIcon(SDMSDesktop.class.getResource("RenameIconSmall.gif")));
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SDMSDesktopWindow.this.rename();
                }
            });
            this.toolBar.add(jButton);
        }
        if (this.doesDrop) {
            jButton = new JButton(new ImageIcon(SDMSDesktop.class.getResource("DropIconSmall.gif")));
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SDMSDesktopWindow.this.drop();
                }
            });
            this.toolBar.add(jButton);
        }
    }

    public void refresh() {
        JOptionPane.showMessageDialog(this, "Refresh not yet implemented", "Info", 1);
    }

    public void drop() {
        JOptionPane.showMessageDialog(this, "Drop not yet implemented", "Info", 1);
    }

    public void create() {
        JOptionPane.showMessageDialog(this, "Create not yet implemented", "Info", 1);
    }

    public void rename() {
        JOptionPane.showMessageDialog(this, "Rename not yet implemented", "Info", 1);
    }
}

