/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.DeadlockException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.RecoverableException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.server.parser.Connect;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSSmeCounterTable;
import de.independit.scheduler.server.repository.SDMSTransaction;
import de.independit.scheduler.server.util.AuditWriter;
import de.independit.scheduler.server.util.SDMSThread;
import de.independit.scheduler.server.util.SyncFifo;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Date;

public class WorkerThread
extends SDMSThread {
    private static String workerLock = "workerLock";
    public static final String __version = "@(#) $Id: WorkerThread.java,v 2.18.2.2 2013/03/15 13:06:48 ronald Exp $";
    private static final String idle = "IDLE";
    private SyncFifo cmdQueue;
    private int nr;
    public SystemEnvironment env;
    private int retryCount;
    private String state;
    private Date state_ts;
    private Node actNode = null;
    private boolean protoCommit = false;
    public boolean commiting;

    public WorkerThread(SystemEnvironment systemEnvironment, ThreadGroup threadGroup, SyncFifo syncFifo, int n) throws SDMSException {
        super(threadGroup, "Worker" + Integer.toString(n));
        if (n < SystemEnvironment.maxWriter) {
            this.protoCommit = true;
        }
        this.cmdQueue = syncFifo;
        this.nr = n;
        try {
            this.env = (SystemEnvironment)systemEnvironment.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181513", "Cannot Clone SystemEnvironment"));
        }
        this.env.dbConnection = Server.connectToDB(this.env);
        this.env.dbConnectionNr = this.nr;
        this.retryCount = SystemEnvironment.txRetryCount;
        this.state = idle;
        this.state_ts = new Date();
    }

    @Override
    public int id() {
        return this.nr;
    }

    public String getWorkerState() {
        if (this.actNode != null) {
            this.state = this.actNode.getName();
        }
        return this.state;
    }

    public String getWorkerStateTS(SystemEnvironment systemEnvironment) {
        return systemEnvironment.systemDateFormat.format(this.state_ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SDMSrun() {
        boolean bl = true;
        this.env.thread = this;
        while (this.run) {
            Node node = (Node)this.cmdQueue.get();
            bl = true;
            if (!this.run) break;
            if (node == null) continue;
            this.actNode = node;
            this.state = null;
            ConnectionEnvironment connectionEnvironment = node.getEnv();
            node.getLock();
            this.exceptionsToTrace = node.exceptionsToTrace;
            this.commiting = false;
            connectionEnvironment.setState(2);
            connectionEnvironment.setLast();
            connectionEnvironment.worker = this;
            this.env.cEnv = connectionEnvironment;
            try {
                int n = 0;
                boolean bl2 = false;
                PrintStream printStream = connectionEnvironment.ostream;
                connectionEnvironment.ostream = System.out;
                SystemEnvironment.incrCntRwTx();
                do {
                    connectionEnvironment.tx = new SDMSTransaction(this.env, node.txMode, node.contextVersion);
                    this.state_ts.setTime(connectionEnvironment.tx.startTime);
                    this.env.tx = connectionEnvironment.tx;
                    try {
                        if (SystemEnvironment.maxWriter > 1 && node.txMode == 2) {
                            if (n == this.retryCount - 1) {
                                WorkerThread.doTrace(connectionEnvironment, "SDMSRun() reached max retryCount, running exclusively now", 2);
                                SystemEnvironment.incrCntWl();
                                LockingSystem.lock(this.env, workerLock, 1);
                            } else {
                                LockingSystem.lock(this.env, workerLock, 0);
                            }
                        }
                        this.env.inExecution = true;
                        this.env.initLockCp();
                        node.go(this.env);
                        if (node.txMode == 2) {
                            SDMSSmeCounterTable.updateCounter(this.env);
                            SDMSResource.writeTrace(this.env);
                        }
                        LockingSystem.release(this.env, workerLock);
                        this.env.inExecution = false;
                        connectionEnvironment.setState(3);
                        this.commiting = true;
                        if (this.protoCommit) {
                            WorkerThread.doTrace(connectionEnvironment, "Server Execution time for " + node.getClass() + " : " + (System.currentTimeMillis() - connectionEnvironment.tx.startTime) + " ms -- Start Committing", 2);
                        }
                        connectionEnvironment.tx.commit(this.env);
                        SystemEnvironment.sched.publishRequestList(this.env);
                        n = this.retryCount;
                        bl2 = true;
                        if (node instanceof Connect) {
                            Node node2 = ((Connect)node).getNode();
                            WorkerThread.doTrace(connectionEnvironment, "Execution time for " + node.getClass() + (node2 == null ? "" : "/" + node2.getClass()) + " : " + (connectionEnvironment.tx.endTime - connectionEnvironment.tx.startTime) + " ms", 2);
                            continue;
                        }
                        WorkerThread.doTrace(connectionEnvironment, "Execution time for " + node.getClass() + " : " + (connectionEnvironment.tx.endTime - connectionEnvironment.tx.startTime) + " ms", 2);
                    }
                    catch (RecoverableException recoverableException) {
                        SystemEnvironment.incrCntDl();
                        String string = recoverableException.toString();
                        WorkerThread.doTrace(connectionEnvironment, "RecoverableException: " + string + " in Try " + (n + 1) + " of " + this.retryCount, 2);
                        if (string.contains("Connection lost")) {
                            this.env.dbConnection = Server.connectToDB(this.env);
                        }
                        if (++n != this.retryCount) continue;
                        node.result.setError(new SDMSOutputError(recoverableException.errNumber(), recoverableException.toString()));
                    }
                    catch (SQLException sQLException) {
                        throw new FatalException(new SDMSMessage(this.env, "03110181514", "Error at Commit: $1", sQLException.toString()));
                    }
                    catch (FatalException fatalException) {
                        throw fatalException;
                    }
                    catch (SDMSException sDMSException) {
                        n = this.retryCount;
                        node.result.setError(new SDMSOutputError(sDMSException.errNumber(), sDMSException.toString()));
                        bl = false;
                    }
                    catch (StackOverflowError stackOverflowError) {
                        n = this.retryCount;
                        WorkerThread.doTrace(null, stackOverflowError.toString(), stackOverflowError.getStackTrace(), -1);
                        node.result.setError(new SDMSOutputError("03805150911", "Stack Overflow ! Contact your System Administrator !"));
                        bl = false;
                    }
                    catch (Exception exception) {
                        if (SystemEnvironment.fatalIsError) {
                            n = this.retryCount;
                            WorkerThread.doTrace(null, exception.toString(), exception.getStackTrace(), -1);
                            node.result.setError(new SDMSOutputError("03909211556", "Internal Error ! Contact your System Administrator !"));
                            bl = false;
                            continue;
                        }
                        throw exception;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw outOfMemoryError;
                    }
                    catch (Error error) {
                        if (SystemEnvironment.fatalIsError) {
                            n = this.retryCount;
                            WorkerThread.doTrace(null, error.toString(), error.getStackTrace(), -1);
                            node.result.setError(new SDMSOutputError("03909211653", "Internal Error ! Contact your System Administrator !"));
                            bl = false;
                            continue;
                        }
                        throw error;
                    }
                    finally {
                        if (!bl2) {
                            try {
                                connectionEnvironment.tx.rollback(this.env);
                                connectionEnvironment.ostream.flush();
                            }
                            catch (DeadlockException deadlockException) {
                                throw new FatalException(new SDMSMessage(this.env, "03110181515", "Deadlock at Rollback"));
                            }
                            catch (SQLException sQLException) {
                                throw new FatalException(new SDMSMessage(this.env, "03110181516", "Rollback failed"));
                            }
                        }
                    }
                } while (n < this.retryCount);
                if (SystemEnvironment.auditFile != null && node.auditFlag && connectionEnvironment.actstmt != null) {
                    AuditWriter.write(this.env, connectionEnvironment, bl);
                }
                connectionEnvironment.emptyGid(this.env);
                connectionEnvironment.ostream = printStream;
                connectionEnvironment.lock().do_notify();
            }
            catch (SDMSException sDMSException) {
                WorkerThread.doTrace(null, sDMSException.toString(), sDMSException.getStackTrace(), -2);
            }
            catch (Exception exception) {
                WorkerThread.doTrace(null, exception.toString(), exception.getStackTrace(), -2);
            }
            catch (Error error) {
                WorkerThread.doTrace(null, error.toString(), error.getStackTrace(), -2);
            }
            finally {
                connectionEnvironment.worker = null;
            }
            node.releaseLock();
            this.actNode = null;
            this.state = idle;
            this.state_ts.setTime(System.currentTimeMillis());
        }
        try {
            this.env.dbConnection.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

