/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpParameters;
import de.independit.scheduler.server.dump.DumpResource;
import de.independit.scheduler.server.dump.DumpScopeGeneric;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeConfig;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMapping;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMappingTable;
import de.independit.scheduler.server.repository.SDMSScopeConfigTable;
import java.util.Collections;
import java.util.Vector;

public class DumpScope
extends DumpScopeGeneric {
    public static final String __version = "@(#) $Id: DumpScope.java,v 2.7.14.1 2013/03/14 10:24:15 ronald Exp $";
    private Integer type;
    private String nodeName;
    private String passWord;
    private Boolean isEnabled;
    private String group;
    private Vector cfgList;
    private Vector parmList;

    public static final DumpScope loadDump(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        DumpScope dumpScope = (DumpScope)DumpScope.getRef(systemEnvironment, 17, sDMSScope);
        if (dumpScope != null) {
            return dumpScope;
        }
        return new DumpScope(systemEnvironment, sDMSScope);
    }

    DumpScope(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        super(systemEnvironment, sDMSScope);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = super.initialize(systemEnvironment);
        Long l = this.s.getParentId(systemEnvironment);
        return l == null ? string : DumpScope.getDumpedName(systemEnvironment, l) + '.' + string;
    }

    private final String quoted(String string) {
        String string2 = string.substring(1);
        return DumpScope.quotedString(string2);
    }

    private final void loadScopeConfig(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSScopeConfigTable.idx_sId.getVector(systemEnvironment, this.sId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSScopeConfig sDMSScopeConfig = (SDMSScopeConfig)vector.get(i);
            String string = DumpScope.quotedString(sDMSScopeConfig.getKey(systemEnvironment));
            String string2 = this.quoted(sDMSScopeConfig.getValue(systemEnvironment));
            this.cfgList.add(string + " = " + string2);
        }
        Collections.sort(this.cfgList, Compare.Lexically);
    }

    private final void loadConfigEnvMappings(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSScopeConfigEnvMappingTable.idx_sId.getVector(systemEnvironment, this.sId);
        int n = vector.size();
        if (n != 0) {
            Vector<String> vector2 = new Vector<String>(n);
            for (int i = 0; i < n; ++i) {
                SDMSScopeConfigEnvMapping sDMSScopeConfigEnvMapping = (SDMSScopeConfigEnvMapping)vector.get(i);
                String string = DumpScope.quotedString(sDMSScopeConfigEnvMapping.getKey(systemEnvironment));
                String string2 = this.quoted(sDMSScopeConfigEnvMapping.getValue(systemEnvironment));
                vector2.add(string + " = " + string2);
            }
            Collections.sort(vector2, Compare.Lexically);
            this.cfgList.add(DumpScope.quotedString("ENV") + " = (\n\t\t\t\t" + DumpScope.join(",\n\t\t\t\t", vector2) + ")");
        }
    }

    private final void loadConfig(SystemEnvironment systemEnvironment) throws SDMSException {
        this.cfgList = new Vector();
        this.loadScopeConfig(systemEnvironment);
        this.loadConfigEnvMappings(systemEnvironment);
    }

    private final void loadResources(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, this.sId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSResource sDMSResource = (SDMSResource)vector.get(i);
            Long l = sDMSResource.getId(systemEnvironment);
            DumpResource.getDumpedName(systemEnvironment, l);
        }
    }

    private final void collectServer(SystemEnvironment systemEnvironment) throws SDMSException {
        this.nodeName = this.s.getNode(systemEnvironment);
        this.passWord = this.s.getPasswd(systemEnvironment);
        this.isEnabled = this.s.getIsEnabled(systemEnvironment);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        String string;
        this.type = this.s.getType(systemEnvironment);
        switch (this.type) {
            case 1: {
                string = "scope";
                break;
            }
            case 2: {
                string = "jobserver";
                this.comments.setObjectType(string);
                this.collectServer(systemEnvironment);
                break;
            }
            default: {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04206061735", "unknown scope type: $1", this.type));
            }
        }
        this.loadConfig(systemEnvironment);
        this.loadResources(systemEnvironment);
        this.parmList = DumpParameters.getList(systemEnvironment, this.sId, this, string);
        Long l = this.s.getOwnerId(systemEnvironment);
        this.group = DumpGroup.getDumpedName(systemEnvironment, l);
        DumpGrant.getDumpedList(systemEnvironment, this.sId);
    }

    private final void alterExisting(String string) {
        Vector<String> vector = new Vector<String>();
        if (!this.cfgList.isEmpty()) {
            vector.add("config = none");
        }
        if (!this.parmList.isEmpty()) {
            vector.add("parameters = none");
        }
        if (!vector.isEmpty()) {
            DumpScope.println("alter existing " + string + " " + this.getName());
            DumpScope.println("\twith");
            DumpScope.println("\t\t" + DumpScope.join(",\n\t\t", vector) + ";");
            DumpScope.println();
        }
    }

    private final void renderScope(String string) {
        DumpScope.println(string + " scope " + this.getName());
        DumpScope.println("\twith");
    }

    private final void renderServer(String string) {
        DumpScope.println(string + " jobserver " + this.getName());
        DumpScope.println("\twith");
        if (this.nodeName != null) {
            DumpScope.println("\t\tnode = " + DumpScope.quotedString(this.nodeName) + ",");
        }
        DumpScope.println("\t\trawpassword = " + DumpScope.quotedString(this.passWord) + ",");
        if (this.isEnabled != null) {
            DumpScope.println("\t\t" + (this.isEnabled != false ? "enable" : "disable") + ",");
        }
    }

    @Override
    final void render(String string) {
        switch (this.type) {
            case 1: {
                this.alterExisting("scope");
                this.renderScope(string);
                break;
            }
            case 2: {
                this.alterExisting("jobserver");
                this.renderServer(string);
            }
        }
        DumpScope.println("\t\tconfig = " + (this.cfgList.isEmpty() ? "none" : DumpScope.renderList(this.cfgList)) + ",");
        if (this.parmList.isEmpty()) {
            DumpScope.print("\t\tparameters = none");
        } else {
            DumpScope.println("\t\tparameters = (");
            DumpScope.print("\t\t\t" + DumpScope.join(",\n\t\t\t", this.parmList) + ")");
        }
        DumpScope.println(",\n\t\tgroup = " + this.group + ';');
    }
}

