/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.output;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import de.independit.scheduler.server.output.SDMSScriptRenderer;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class SDMSJsonRenderer
extends SDMSScriptRenderer {
    public static final String __version = "@(#) $Id: SDMSJsonRenderer.java,v 2.2.18.1 2013/03/14 10:24:18 ronald Exp $";
    public static volatile boolean directIO = true;
    private boolean zeroTerminated = false;

    public SDMSJsonRenderer() {
    }

    public SDMSJsonRenderer(Boolean bl) {
        this.zeroTerminated = bl;
    }

    @Override
    public void render(SystemEnvironment systemEnvironment, SDMSOutput sDMSOutput) throws FatalException {
        if (directIO) {
            this.renderStream(systemEnvironment.cEnv.ostream(), sDMSOutput);
        } else {
            this.render(systemEnvironment.cEnv.ostream(), sDMSOutput);
        }
    }

    @Override
    public void render(PrintStream printStream, SDMSOutput sDMSOutput) throws FatalException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        boolean bl = true;
        if (sDMSOutput.container != null) {
            stringBuffer.append("\"DATA\" : \n");
            this.renderContainer(stringBuffer, sDMSOutput.container);
            bl = false;
        }
        if (sDMSOutput.feedback != null) {
            if (!bl) {
                stringBuffer.append(",");
            }
            bl = false;
            this.renderFeedback(stringBuffer, sDMSOutput.feedback);
        }
        if (sDMSOutput.error != null) {
            if (!bl) {
                stringBuffer.append(",");
            }
            this.renderError(stringBuffer, sDMSOutput.error);
        }
        stringBuffer.append("}\n");
        if (this.zeroTerminated) {
            stringBuffer.append("\u0000");
        }
        printStream.print(stringBuffer);
    }

    public void renderStream(PrintStream printStream, SDMSOutput sDMSOutput) throws FatalException {
        printStream.print("{\n");
        boolean bl = true;
        if (sDMSOutput.container != null) {
            printStream.print("\"DATA\" : \n");
            this.renderContainer(printStream, sDMSOutput.container);
            bl = false;
        }
        if (sDMSOutput.feedback != null) {
            if (!bl) {
                printStream.print(",");
            }
            bl = false;
            this.renderFeedback(printStream, sDMSOutput.feedback);
        }
        if (sDMSOutput.error != null) {
            if (!bl) {
                printStream.print(",");
            }
            this.renderError(printStream, sDMSOutput.error);
        }
        if (this.zeroTerminated) {
            printStream.print("}\n\u0000");
        } else {
            printStream.print("}\n");
        }
    }

    private void renderContainer(StringBuffer stringBuffer, SDMSOutputContainer sDMSOutputContainer) {
        stringBuffer.append("{\n");
        if (sDMSOutputContainer.title != null) {
            stringBuffer.append("\"TITLE\" : \"" + this.maskJsonQuotes(sDMSOutputContainer.title.toString()) + "\",\n");
        }
        stringBuffer.append("\"DESC\" : [\n");
        boolean bl = true;
        Iterator iterator = sDMSOutputContainer.desc.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            SDMSOutputLabel sDMSOutputLabel = (SDMSOutputLabel)iterator.next();
            stringBuffer.append("\"" + this.maskJsonQuotes(sDMSOutputLabel.name) + "\"\n");
        }
        stringBuffer.append("],\n");
        if (sDMSOutputContainer.columns == 0) {
            stringBuffer.append("\"RECORD\" : ");
            this.renderRecord(stringBuffer, sDMSOutputContainer);
        } else {
            stringBuffer.append("\"TABLE\" : ");
            this.renderTable(stringBuffer, sDMSOutputContainer);
        }
        stringBuffer.append("}\n");
    }

    private void renderRecord(StringBuffer stringBuffer, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        boolean bl = true;
        Vector vector = (Vector)sDMSOutputContainer.dataset.elementAt(0);
        stringBuffer.append("{\n");
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name;
            stringBuffer.append("\"" + this.maskJsonQuotes(string) + "\" : ");
            if (vector.elementAt(i) != null) {
                if (!(vector.elementAt(i) instanceof SDMSOutputContainer)) {
                    stringBuffer.append("\"" + this.maskJsonQuotes(vector.elementAt(i).toString()) + "\"");
                    continue;
                }
                stringBuffer.append("\n");
                this.renderContainer(stringBuffer, (SDMSOutputContainer)vector.elementAt(i));
                continue;
            }
            stringBuffer.append("null");
        }
        stringBuffer.append("}\n");
    }

    private void renderTable(StringBuffer stringBuffer, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        boolean bl = true;
        stringBuffer.append("[\n");
        Iterator iterator = sDMSOutputContainer.dataset.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            stringBuffer.append("{\n");
            Vector vector = (Vector)iterator.next();
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                if (!bl2) {
                    stringBuffer.append(",\n");
                }
                bl2 = false;
                String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name;
                stringBuffer.append("\"" + this.maskJsonQuotes(string) + "\" : ");
                if (vector.elementAt(i) == null) {
                    stringBuffer.append("null");
                    continue;
                }
                stringBuffer.append("\"" + this.maskJsonQuotes(vector.elementAt(i).toString()) + "\"");
            }
            stringBuffer.append("}\n");
        }
        stringBuffer.append("]\n");
    }

    private void renderFeedback(StringBuffer stringBuffer, Object object) {
        stringBuffer.append("\"FEEDBACK\" : \"" + this.maskJsonQuotes(object.toString()) + "\"\n");
    }

    private void renderError(StringBuffer stringBuffer, SDMSOutputError sDMSOutputError) {
        stringBuffer.append("\"ERROR\" : {\n");
        stringBuffer.append("\"ERRORCODE\" : \"" + this.maskJsonQuotes(sDMSOutputError.code.toString()) + "\", \n");
        stringBuffer.append("\"ERRORMESSAGE\" : \"" + this.maskJsonQuotes(sDMSOutputError.message.toString()) + "\"\n");
        stringBuffer.append("}\n");
    }

    private void renderPrompt(StringBuffer stringBuffer) {
    }

    private void renderContainer(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        printStream.print("{\n");
        if (sDMSOutputContainer.title != null) {
            printStream.print("\"TITLE\" : \"" + this.maskJsonQuotes(sDMSOutputContainer.title.toString()) + "\",\n");
        }
        printStream.print("\"DESC\" : [\n");
        boolean bl = true;
        Iterator iterator = sDMSOutputContainer.desc.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                printStream.print(",\n");
            }
            bl = false;
            SDMSOutputLabel sDMSOutputLabel = (SDMSOutputLabel)iterator.next();
            printStream.print("\"" + this.maskJsonQuotes(sDMSOutputLabel.name) + "\"\n");
        }
        printStream.print("],\n");
        if (sDMSOutputContainer.columns == 0) {
            printStream.print("\"RECORD\" : ");
            this.renderRecord(printStream, sDMSOutputContainer);
        } else {
            printStream.print("\"TABLE\" : ");
            this.renderTable(printStream, sDMSOutputContainer);
        }
        printStream.print("}\n");
    }

    private void renderRecord(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        boolean bl = true;
        Vector vector = (Vector)sDMSOutputContainer.dataset.elementAt(0);
        printStream.print("{\n");
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                printStream.print(",\n");
            }
            bl = false;
            String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name;
            printStream.print("\"" + this.maskJsonQuotes(string) + "\" : ");
            if (vector.elementAt(i) != null) {
                if (!(vector.elementAt(i) instanceof SDMSOutputContainer)) {
                    printStream.print("\"" + this.maskJsonQuotes(vector.elementAt(i).toString()) + "\"");
                    continue;
                }
                printStream.print("\n");
                this.renderContainer(printStream, (SDMSOutputContainer)vector.elementAt(i));
                continue;
            }
            printStream.print("null");
        }
        printStream.print("}\n");
    }

    private void renderTable(PrintStream printStream, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        boolean bl = true;
        printStream.print("[\n");
        Iterator iterator = sDMSOutputContainer.dataset.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                printStream.print(",\n");
            }
            bl = false;
            printStream.print("{\n");
            Vector vector = (Vector)iterator.next();
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                if (!bl2) {
                    printStream.print(",\n");
                }
                bl2 = false;
                String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name;
                printStream.append("\"" + this.maskJsonQuotes(string) + "\" : ");
                if (vector.elementAt(i) == null) {
                    printStream.print("null");
                    continue;
                }
                printStream.print("\"" + this.maskJsonQuotes(vector.elementAt(i).toString()) + "\"");
            }
            printStream.print("}\n");
        }
        printStream.print("]\n");
    }

    private void renderFeedback(PrintStream printStream, Object object) {
        printStream.print("\"FEEDBACK\" : \"" + this.maskJsonQuotes(object.toString()) + "\"\n");
    }

    private void renderError(PrintStream printStream, SDMSOutputError sDMSOutputError) {
        printStream.print("\"ERROR\" : {\n");
        printStream.print("\"ERRORCODE\" : \"" + this.maskJsonQuotes(sDMSOutputError.code.toString()) + "\", \n");
        printStream.print("\"ERRORMESSAGE\" : \"" + this.maskJsonQuotes(sDMSOutputError.message.toString()) + "\"\n");
        printStream.print("}\n");
    }

    private void renderPrompt(PrintStream printStream) {
    }
}

