/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.output;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import de.independit.scheduler.server.output.occomp;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class SDMSOutputContainer
implements Serializable {
    public static final String __version = "@(#) $Id: SDMSOutputContainer.java,v 2.2.2.1 2013/03/14 10:24:17 ronald Exp $";
    public Object title;
    public Vector desc;
    public Vector dataset;
    public int lines;
    public int columns;
    public int labelwidth;

    public SDMSOutputContainer(SystemEnvironment systemEnvironment, Object object, Vector vector) throws FatalException {
        this.commonInit(systemEnvironment, object, vector);
        this.columns = this.desc.size();
    }

    public SDMSOutputContainer(SystemEnvironment systemEnvironment, Object object, Vector vector, Vector vector2) throws FatalException {
        this.commonInit(systemEnvironment, object, vector);
        this.columns = 0;
        this.addData(systemEnvironment, vector2);
    }

    private void commonInit(SystemEnvironment systemEnvironment, Object object, Vector vector) throws FatalException {
        this.title = object;
        if (vector == null || vector.size() == 0) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181621", "Cannot create SDMSOutputContainer without or empty description"));
        }
        this.desc = new Vector();
        this.labelwidth = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            SDMSOutputLabel sDMSOutputLabel = new SDMSOutputLabel((String)iterator.next());
            this.desc.add(sDMSOutputLabel);
            if (sDMSOutputLabel.length <= this.labelwidth) continue;
            this.labelwidth = sDMSOutputLabel.length;
        }
        this.dataset = new Vector();
        this.lines = 0;
    }

    public void addData(SystemEnvironment systemEnvironment, Vector vector) throws FatalException {
        if (this.columns == 0 && this.lines != 0) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181622", "Cannot add data to record type SDMSOutputContainer"));
        }
        if (this.columns != 0 && vector.size() != this.columns) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181623", "Number of data items does not match description"));
        }
        int n = 0;
        for (Object e : vector) {
            String string;
            int n2;
            if (e == null) {
                if (((SDMSOutputLabel)this.desc.elementAt((int)n)).length < 6) {
                    ((SDMSOutputLabel)this.desc.elementAt((int)n)).length = 6;
                }
            } else if (!(e instanceof SDMSOutputContainer) && ((SDMSOutputLabel)this.desc.elementAt((int)n)).length < (n2 = (string = e.toString()).length())) {
                ((SDMSOutputLabel)this.desc.elementAt((int)n)).length = n2;
            }
            ++n;
        }
        this.dataset.add(vector);
        ++this.lines;
    }

    public void setWidth(SystemEnvironment systemEnvironment, int n, int n2) throws FatalException {
        if (this.columns != 0 && n >= this.columns) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "0312121108", "Columnnumber exceeds the number of defined columns"));
        }
        ((SDMSOutputLabel)this.desc.elementAt((int)n)).length = n2;
    }

    public int indexForName(SystemEnvironment systemEnvironment, String string) {
        Iterator iterator = this.desc.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            SDMSOutputLabel sDMSOutputLabel = (SDMSOutputLabel)iterator.next();
            if (sDMSOutputLabel.name.equals(string)) {
                return n;
            }
            ++n;
        }
        throw new RuntimeException("Name " + string + " not found in decriptor");
    }

    public Comparator getComparator(SystemEnvironment systemEnvironment, int n) throws SDMSException {
        int[] nArray = new int[]{n};
        if (n >= this.desc.size() || -n >= this.desc.size()) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03117121557", "The number of the sortcolumn ($1) exceeds the number of columns ($2)", n, this.desc.size()));
        }
        return new occomp(systemEnvironment, nArray);
    }

    public Comparator getComparator(SystemEnvironment systemEnvironment, int n, int n2) throws SDMSException {
        int[] nArray = new int[2];
        nArray[0] = n;
        if (n >= this.desc.size() || -n >= this.desc.size()) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03201292045", "The number of the sortcolumn ($1) exceeds the number of columns ($2)", n, this.desc.size()));
        }
        nArray[1] = n2;
        if (n2 >= this.desc.size() || -n2 >= this.desc.size()) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03117121559", "The number of the sortcolumn ($1) exceeds the number of columns ($2)", n2, this.desc.size()));
        }
        return new occomp(systemEnvironment, nArray);
    }

    public Comparator getComparator(SystemEnvironment systemEnvironment, int[] nArray) throws SDMSException {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < this.desc.size() && -nArray[i] < this.desc.size()) continue;
            throw new FatalException(new SDMSMessage(systemEnvironment, "03117121601", "The number of the sortcolumn ($1) exceeds the number of columns ($2)", nArray[i], this.desc.size()));
        }
        return new occomp(systemEnvironment, nArray);
    }
}

