/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.output;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.server.output.SDMSOutputLabel;
import de.independit.scheduler.server.output.SDMSScriptRenderer;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class SDMSPerlRenderer
extends SDMSScriptRenderer {
    public static final String __version = "@(#) $Id: SDMSPerlRenderer.java,v 2.1.20.1 2013/03/14 10:24:18 ronald Exp $";
    private boolean zeroTerminated = false;

    public SDMSPerlRenderer() {
    }

    public SDMSPerlRenderer(Boolean bl) {
        this.zeroTerminated = bl;
    }

    @Override
    public void render(SystemEnvironment systemEnvironment, SDMSOutput sDMSOutput) throws FatalException {
        this.render(systemEnvironment.cEnv.ostream(), sDMSOutput);
    }

    @Override
    public void render(PrintStream printStream, SDMSOutput sDMSOutput) throws FatalException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{\n");
        boolean bl = true;
        if (sDMSOutput.container != null) {
            stringBuffer.append("'DATA' => \n");
            this.renderContainer(stringBuffer, sDMSOutput.container);
            bl = false;
        }
        if (sDMSOutput.feedback != null) {
            if (!bl) {
                stringBuffer.append(",");
            }
            bl = false;
            this.renderFeedback(stringBuffer, sDMSOutput.feedback);
        }
        if (sDMSOutput.error != null) {
            if (!bl) {
                stringBuffer.append(",");
            }
            this.renderError(stringBuffer, sDMSOutput.error);
        }
        stringBuffer.append("}\n");
        if (this.zeroTerminated) {
            stringBuffer.append("\u0000");
        }
        printStream.print(stringBuffer);
    }

    private void renderContainer(StringBuffer stringBuffer, SDMSOutputContainer sDMSOutputContainer) {
        stringBuffer.append("{\n");
        if (sDMSOutputContainer.title != null) {
            stringBuffer.append("'TITLE' => '" + this.maskQuotes(sDMSOutputContainer.title.toString()) + "',\n");
        }
        stringBuffer.append("'DESC' => [\n");
        boolean bl = true;
        Iterator iterator = sDMSOutputContainer.desc.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            SDMSOutputLabel sDMSOutputLabel = (SDMSOutputLabel)iterator.next();
            stringBuffer.append("'" + this.maskQuotes(sDMSOutputLabel.name.toUpperCase()) + "'\n");
        }
        stringBuffer.append("],\n");
        if (sDMSOutputContainer.columns == 0) {
            stringBuffer.append("'RECORD' => ");
            this.renderRecord(stringBuffer, sDMSOutputContainer);
        } else {
            stringBuffer.append("'TABLE' => ");
            this.renderTable(stringBuffer, sDMSOutputContainer);
        }
        stringBuffer.append("}\n");
    }

    private void renderRecord(StringBuffer stringBuffer, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        boolean bl = true;
        Vector vector = (Vector)sDMSOutputContainer.dataset.elementAt(0);
        stringBuffer.append("{\n");
        for (int i = 0; i < n; ++i) {
            String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name.toUpperCase();
            if (vector.elementAt(i) == null) continue;
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            stringBuffer.append("'" + this.maskQuotes(string) + "' => ");
            if (!(vector.elementAt(i) instanceof SDMSOutputContainer)) {
                stringBuffer.append("'" + this.maskQuotes(vector.elementAt(i).toString()) + "'");
                continue;
            }
            stringBuffer.append("\n");
            this.renderContainer(stringBuffer, (SDMSOutputContainer)vector.elementAt(i));
        }
        stringBuffer.append("}\n");
    }

    private void renderTable(StringBuffer stringBuffer, SDMSOutputContainer sDMSOutputContainer) {
        int n = sDMSOutputContainer.desc.size();
        boolean bl = true;
        stringBuffer.append("[\n");
        Iterator iterator = sDMSOutputContainer.dataset.iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                stringBuffer.append(",\n");
            }
            bl = false;
            stringBuffer.append("{\n");
            Vector vector = (Vector)iterator.next();
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                if (vector.elementAt(i) == null) continue;
                if (!bl2) {
                    stringBuffer.append(",\n");
                }
                bl2 = false;
                String string = ((SDMSOutputLabel)sDMSOutputContainer.desc.elementAt((int)i)).name.toUpperCase();
                stringBuffer.append("'" + this.maskQuotes(string) + "' => '");
                stringBuffer.append(this.maskQuotes(vector.elementAt(i).toString()));
                stringBuffer.append("'");
            }
            stringBuffer.append("}\n");
        }
        stringBuffer.append("]\n");
    }

    private void renderFeedback(StringBuffer stringBuffer, Object object) {
        stringBuffer.append("'FEEDBACK' => '" + this.maskQuotes(object.toString()) + "'\n");
    }

    private void renderError(StringBuffer stringBuffer, SDMSOutputError sDMSOutputError) {
        stringBuffer.append("'ERROR' => {\n");
        stringBuffer.append("'ERRORCODE' => '" + this.maskQuotes(sDMSOutputError.code.toString()) + "', \n");
        stringBuffer.append("'ERRORMESSAGE' => '");
        stringBuffer.append(this.maskQuotes(sDMSOutputError.message.toString()));
        stringBuffer.append("'\n");
        stringBuffer.append("}\n");
    }

    private void renderPrompt(StringBuffer stringBuffer) {
    }
}

