/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceState;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import java.util.Iterator;
import java.util.Vector;

public class AlterRsp
extends Node {
    public static final String __version = "@(#) $Id: AlterRsp.java,v 2.2.4.1 2013/03/14 10:24:22 ronald Exp $";
    private String name;
    private WithHash with;
    private boolean noerr;

    public AlterRsp(String string, WithHash withHash, Boolean bl) {
        this.name = string;
        this.with = withHash;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        Vector vector;
        SDMSResourceStateProfile sDMSResourceStateProfile;
        try {
            sDMSResourceStateProfile = SDMSResourceStateProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122340", "No Resource State Profile altered"));
                return;
            }
            throw notFoundException;
        }
        Long l2 = sDMSResourceStateProfile.getId(systemEnvironment);
        Long l3 = null;
        Vector vector2 = (Vector)this.with.get("STATUS");
        if (vector2 != null) {
            vector = SDMSResourceStateTable.idx_rspId.getVector(systemEnvironment, l2);
            for (SDMSResourceState sDMSResourceState : vector) {
                sDMSResourceState.delete(systemEnvironment);
            }
            for (Object object : vector2) {
                l = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, object).getId(systemEnvironment);
                try {
                    SDMSResourceStateTable.table.create(systemEnvironment, l, l2);
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03110120920", "State $1 specified more than once", object));
                }
            }
        }
        Iterator iterator = (String)this.with.get("INITIAL_STATUS");
        if (iterator != null) {
            l3 = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, iterator).getId(systemEnvironment);
            sDMSResourceStateProfile.setInitialRsdId(systemEnvironment, l3);
        }
        vector = SDMSNamedResourceTable.idx_rspId.getVector(systemEnvironment, l2);
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            object = ((SDMSNamedResource)vector.get(i)).getId(systemEnvironment);
            Vector vector3 = SDMSResourceTable.idx_nrId.getVector(systemEnvironment, object);
            for (int j = 0; j < vector3.size(); ++j) {
                SDMSResource sDMSResource = (SDMSResource)vector3.get(j);
                l = sDMSResource.getRsdId(systemEnvironment);
                if (l.equals(l3) || SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l, l2))) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03209181659", "Profile does not contain state $1 of resource $2->$3", SDMSResourceStateDefinitionTable.getObject(systemEnvironment, sDMSResource.getRsdId(systemEnvironment)).getName(systemEnvironment), SDMSScopeTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment)), ((SDMSNamedResource)vector.get(i)).pathVector(systemEnvironment)));
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203311351", "Resource State Profile altered"));
    }
}

