/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ManipUser;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprint;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprintTable;
import de.independit.scheduler.server.util.CheckSum;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class Connect
extends Node {
    public static final String __version = "@(#) $Id: Connect.java,v 2.20.2.1 2013/03/14 10:24:24 ronald Exp $";
    public static final String JS_ALREADY_CONNECTED = "Server already connected";
    protected String user;
    private String jsName;
    private String passwd;
    protected String txtPasswd;
    private boolean isJobServer;
    private boolean isJob;
    private boolean isUser;
    private Vector path;
    private Long jobid;
    private WithHash withs;
    private final Vector cmd;
    private Node actual_cmd = null;

    public Connect(String string, String string2, WithHash withHash) {
        this.cmdtype = 7;
        this.user = string;
        this.txtPasswd = string2;
        this.isUser = true;
        this.isJobServer = false;
        this.jsName = null;
        this.isJob = false;
        this.jobid = null;
        this.path = null;
        this.withs = withHash;
        this.cmd = (Vector)this.withs.get("COMMAND");
        if (this.cmd == null && SystemEnvironment.auth == null) {
            this.txMode = 1;
        } else {
            this.txMode = 1;
            if (SystemEnvironment.auth == null) {
                for (int i = 0; i < this.cmd.size(); ++i) {
                    Node node = (Node)this.cmd.get(i);
                    if (node.txMode != 2) continue;
                    this.txMode = 2;
                    this.auditFlag = node.auditFlag;
                    break;
                }
            } else {
                this.txMode = 2;
            }
        }
    }

    protected Connect(WithHash withHash) {
        this.cmdtype = 7;
        this.isUser = true;
        this.isJobServer = false;
        this.jsName = null;
        this.isJob = false;
        this.jobid = null;
        this.path = null;
        this.withs = withHash;
        this.cmd = (Vector)this.withs.get("COMMAND");
        if (this.cmd == null && SystemEnvironment.auth == null) {
            this.txMode = 1;
        } else {
            this.txMode = 1;
            if (SystemEnvironment.auth == null) {
                for (int i = 0; i < this.cmd.size(); ++i) {
                    Node node = (Node)this.cmd.get(i);
                    if (node.txMode != 2) continue;
                    this.txMode = 2;
                    break;
                }
            } else {
                this.txMode = 2;
            }
        }
    }

    public Connect(Vector vector, String string, String string2, WithHash withHash) {
        this.cmdtype = 7;
        this.user = null;
        this.isUser = false;
        this.isJobServer = true;
        this.txtPasswd = string2;
        this.jsName = string;
        this.isJob = false;
        this.jobid = null;
        this.path = vector;
        this.withs = withHash;
        this.cmd = (Vector)this.withs.get("COMMAND");
        if (this.cmd != null) {
            this.auditFlag = ((Node)this.cmd.get((int)0)).auditFlag;
        }
    }

    public Connect(Long l, String string, WithHash withHash) {
        this.cmdtype = 7;
        this.user = null;
        this.passwd = string;
        this.isUser = false;
        this.isJobServer = false;
        this.jsName = null;
        this.isJob = true;
        this.jobid = l;
        this.path = null;
        this.withs = withHash;
        this.cmd = (Vector)this.withs.get("COMMAND");
        this.txMode = 1;
        if (this.cmd != null) {
            this.auditFlag = false;
            for (int i = 0; i < this.cmd.size(); ++i) {
                Node node = (Node)this.cmd.get(i);
                if (node.txMode != 2) continue;
                this.txMode = 2;
                this.auditFlag = node.auditFlag;
                break;
            }
        }
    }

    private void writeCredentials(SystemEnvironment systemEnvironment, SDMSUser sDMSUser) throws SDMSException {
        String string = sDMSUser.getPasswd(systemEnvironment);
        String string2 = sDMSUser.getSalt(systemEnvironment);
        int n = sDMSUser.getMethod(systemEnvironment);
        String string3 = n == 0 ? CheckSum.mkstr(CheckSum.md5((this.txtPasswd + (string2 == null ? "" : string2)).getBytes()), true) : CheckSum.mkstr(CheckSum.sha256((this.txtPasswd + (string2 == null ? "" : string2)).getBytes()), false);
        if (string3.equals(string)) {
            return;
        }
        string2 = ManipUser.generateSalt();
        string3 = CheckSum.mkstr(CheckSum.sha256((this.txtPasswd + string2).getBytes()), false);
        n = 1;
        sDMSUser.setSalt(systemEnvironment, string2);
        sDMSUser.setMethod(systemEnvironment, n);
        sDMSUser.setPasswd(systemEnvironment, string3);
    }

    private void connect_internal_user(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSUser sDMSUser;
        try {
            sDMSUser = SDMSUserTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.user), SDMSConstants.lZERO));
            if (!sDMSUser.getIsEnabled(systemEnvironment).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110192355", "User disabled"));
            }
            if (this.user.toUpperCase().equals("SYSTEM")) {
                if (!this.txtPasswd.equals(SystemEnvironment.sysPasswd)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110192352", "Invalid username or password"));
                }
            } else {
                String string = sDMSUser.getSalt(systemEnvironment);
                int n = sDMSUser.getMethod(systemEnvironment);
                this.passwd = n == 0 ? CheckSum.mkstr(CheckSum.md5((this.txtPasswd + (string == null ? "" : string)).getBytes()), true) : CheckSum.mkstr(CheckSum.sha256((this.txtPasswd + (string == null ? "" : string)).getBytes()), false);
                if (!sDMSUser.getPasswd(systemEnvironment).equals(this.passwd)) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110192353", "Invalid username or password"));
                }
            }
            if (systemEnvironment.getConnectState() != 0 && sDMSUser.getId(systemEnvironment).intValue() != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202081739", "Login restricted"));
            }
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110192350", "Invalid username or password"));
        }
        int n = sDMSUser.getConnectionType(systemEnvironment);
        boolean bl = n > 0 ? (systemEnvironment.cEnv.getIsSSLConnection() ? (n > 1 ? systemEnvironment.cEnv.getIsClientAuthenticated() : true) : false) : true;
        if (!bl) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03707271340", "(Authencicated) SSL Connection required"));
        }
        Long l = sDMSUser.getId(systemEnvironment);
        systemEnvironment.cEnv.setUid(l);
        systemEnvironment.cEnv.setUser();
        systemEnvironment.cEnv.setGid(systemEnvironment, SDMSMemberTable.idx_uId.getVector(systemEnvironment, l));
    }

    protected void initUser(SystemEnvironment systemEnvironment, String[] stringArray, boolean bl, boolean bl2, boolean bl3) throws SDMSException {
        this.initUser(systemEnvironment, stringArray, bl, bl2, bl3, null);
    }

    protected void initUser(SystemEnvironment systemEnvironment, String[] stringArray, boolean bl, boolean bl2, boolean bl3, String string) throws SDMSException {
        Long l;
        SDMSUser sDMSUser;
        Integer n = SDMSConstants.U_SHA256;
        boolean bl4 = false;
        Vector vector = null;
        boolean bl5 = false;
        systemEnvironment.cEnv.setUid(SDMSObject.internalUId);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(SDMSObject.adminGId);
        systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
        bl4 = true;
        try {
            Comparable<Boolean> comparable;
            Object object;
            try {
                sDMSUser = SDMSUserTable.idx_name_getUnique(systemEnvironment, this.user);
                if (sDMSUser.getDeleteVersion(systemEnvironment).intValue() != 0) {
                    if (!bl2) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709251500", "User " + this.user + " does not exist"));
                    }
                    sDMSUser.setDeleteVersion(systemEnvironment, SDMSConstants.lZERO);
                    sDMSUser.setIsEnabled(systemEnvironment, Boolean.TRUE);
                    try {
                        SDMSMemberTable.table.create(systemEnvironment, SDMSObject.publicGId, sDMSUser.getId(systemEnvironment));
                    }
                    catch (DuplicateKeyException duplicateKeyException) {}
                }
            }
            catch (NotFoundException notFoundException) {
                if (bl2) {
                    sDMSUser = null;
                }
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709251459", "User " + this.user + " does not exist"));
            }
            if (sDMSUser == null) {
                object = "Internal Authentication Disabled";
                comparable = Boolean.TRUE;
                sDMSUser = SDMSUserTable.table.create(systemEnvironment, this.user, (String)object, (String)object, n, (Boolean)comparable, SDMSObject.publicGId, SDMSConstants.U_PLAIN, SDMSConstants.lZERO);
                SDMSMemberTable.table.create(systemEnvironment, SDMSObject.publicGId, sDMSUser.getId(systemEnvironment));
                bl5 = true;
            } else if (!sDMSUser.getIsEnabled(systemEnvironment).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709251502", "User " + this.user + " is disabled"));
            }
            l = sDMSUser.getId(systemEnvironment);
            vector = SDMSMemberTable.idx_uId.getVector(systemEnvironment, l);
            if (stringArray != null) {
                SDMSMember sDMSMember;
                Serializable serializable;
                object = new HashSet();
                ((HashSet)object).add(SDMSObject.publicGId);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        serializable = SDMSGroupTable.idx_name.getVector(systemEnvironment, stringArray[i]);
                        comparable = (SDMSGroup)serializable.get(0);
                        if (i == 0 && bl5) {
                            sDMSUser.setDefaultGId(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment));
                        }
                        try {
                            SDMSMemberTable.table.create(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment), l);
                        }
                        catch (DuplicateKeyException duplicateKeyException) {}
                    }
                    catch (NotFoundException notFoundException) {
                        if (!bl3) {
                            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709251501", "Group " + stringArray[i] + " does not exist"));
                        }
                        comparable = SDMSGroupTable.table.create(systemEnvironment, stringArray[i], SDMSConstants.lZERO);
                        sDMSMember = SDMSMemberTable.table.create(systemEnvironment, ((SDMSProxy)comparable).getId(systemEnvironment), l);
                        vector.add(sDMSMember);
                    }
                    ((HashSet)object).add(((SDMSProxy)comparable).getId(systemEnvironment));
                }
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    sDMSMember = (SDMSMember)iterator.next();
                    serializable = sDMSMember.getGId(systemEnvironment);
                    if (((HashSet)object).contains(serializable)) continue;
                    iterator.remove();
                    sDMSMember.delete(systemEnvironment);
                }
            }
            if (string != null) {
                try {
                    object = SDMSGroupTable.idx_name_getUnique(systemEnvironment, string).getId(systemEnvironment);
                    sDMSUser.setDefaultGId(systemEnvironment, (Long)object);
                }
                catch (NotFoundException notFoundException) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02710041057", "Default Group " + string + " does not exist"));
                }
            }
            if (bl && SystemEnvironment.auth.syncCredentials(this.user)) {
                this.writeCredentials(systemEnvironment, sDMSUser);
            }
            systemEnvironment.cEnv.popGid(systemEnvironment);
            bl4 = false;
        }
        catch (Throwable throwable) {
            if (bl4) {
                systemEnvironment.cEnv.popGid(systemEnvironment);
                bl4 = false;
            }
            throw throwable;
        }
        l = sDMSUser.getId(systemEnvironment);
        systemEnvironment.cEnv.setUid(l);
        systemEnvironment.cEnv.setUser();
        systemEnvironment.cEnv.setGid(systemEnvironment, vector);
    }

    private void connect_external_user(SystemEnvironment systemEnvironment) throws SDMSException {
        String[] stringArray = SystemEnvironment.auth.getGroupNames(this.user);
        int n = SystemEnvironment.auth.checkCredentials(this.user, this.txtPasswd);
        if (n == 0) {
            this.initUser(systemEnvironment, stringArray, true, true, true);
        } else if (n == 2 && SystemEnvironment.auth.checkInternally(this.user)) {
            this.connect_internal_user(systemEnvironment);
        } else {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110192356", "Invalid username or password"));
        }
    }

    private void connect_user(SystemEnvironment systemEnvironment) throws SDMSException {
        if (SystemEnvironment.auth == null || this.user.toUpperCase().equals("SYSTEM") || !SystemEnvironment.auth.checkExternally(this.user)) {
            this.connect_internal_user(systemEnvironment);
        } else {
            this.connect_external_user(systemEnvironment);
        }
    }

    private void connect_jobserver(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSScope sDMSScope;
        boolean bl = false;
        try {
            Long l = SDMSScopeTable.pathToId(systemEnvironment, this.path);
            sDMSScope = SDMSScopeTable.idx_parentId_name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)this.jsName)));
            if (sDMSScope.getType(systemEnvironment) != 2) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202041546", "Invalid jobservername or password"));
            }
            if (!sDMSScope.getIsEnabled(systemEnvironment).booleanValue() && !sDMSScope.hasActiveJobs(systemEnvironment)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202041508", "JobServer disabled"));
            }
            String string = sDMSScope.getSalt(systemEnvironment);
            int n = sDMSScope.getMethod(systemEnvironment);
            this.passwd = n == 0 ? CheckSum.mkstr(CheckSum.md5((this.txtPasswd + (string == null ? "" : string)).getBytes()), true) : CheckSum.mkstr(CheckSum.sha256((this.txtPasswd + (string == null ? "" : string)).getBytes()), false);
            if (!sDMSScope.getPasswd(systemEnvironment).equals(this.passwd)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202041511", "Invalid jobservername or password"));
            }
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202041510", "Invalid jobservername or password"));
        }
        SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUniqueForUpdate(systemEnvironment, sDMSScope.getId(systemEnvironment));
        if (sDMSScope.isConnected(systemEnvironment)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03204102020", JS_ALREADY_CONNECTED));
        }
        sDMSnpSrvrSRFootprint.setSessionId(systemEnvironment, this.env.id());
        systemEnvironment.cEnv.setUid(sDMSScope.getId(systemEnvironment));
        systemEnvironment.cEnv.setJobServer();
        try {
            int n = Integer.parseInt(ScopeConfig.getItem(systemEnvironment, sDMSScope, "NOPDELAY"));
            systemEnvironment.cEnv.getMe().setTimeout(n * 3);
        }
        catch (NumberFormatException numberFormatException) {
            systemEnvironment.cEnv.getMe().setTimeout(300);
        }
    }

    public static Long validateJobConnect(SystemEnvironment systemEnvironment, Long l, String string, boolean bl) throws SDMSException {
        int n;
        SDMSSubmittedEntity sDMSSubmittedEntity;
        try {
            Long l2;
            try {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
            }
            catch (NotFoundException notFoundException) {
                SDMSKillJob sDMSKillJob = SDMSKillJobTable.getObject(systemEnvironment, l);
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSKillJob.getSmeId(systemEnvironment));
            }
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206031607", "Invalid username or password"));
            }
            if (!sDMSSubmittedEntity.getAccessKey(systemEnvironment).equals(l2)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110192354", "Invalid username or password"));
            }
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110192351", "Invalid username or password"));
        }
        if (!(bl || (n = sDMSSubmittedEntity.getState(systemEnvironment).intValue()) != 10 && n != 12)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03703141511", "Invalid username or password"));
        }
        return sDMSSubmittedEntity.getId(systemEnvironment);
    }

    private void connect_job(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.cEnv.setUid(Connect.validateJobConnect(systemEnvironment, this.jobid, this.passwd, false));
        systemEnvironment.cEnv.setJob();
        Long l = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.jobid).getOwnerId(systemEnvironment);
        systemEnvironment.cEnv.addGid(l);
        systemEnvironment.cEnv.addGid(SDMSObject.publicGId);
    }

    public Node getNode() {
        return this.actual_cmd;
    }

    @Override
    public String getName() {
        String string = this.getClass().getName();
        if (this.actual_cmd != null) {
            string = this.actual_cmd.getClass().getName();
        }
        return string.substring(string.lastIndexOf(46) + 1);
    }

    protected void evaluateWith(SystemEnvironment systemEnvironment) throws SDMSException {
        WithHash withHash;
        if (this.withs.containsKey("PROTOCOL")) {
            withHash = (WithHash)this.withs.get("PROTOCOL");
            systemEnvironment.cEnv.setRenderer(withHash);
        }
        if (this.withs.containsKey("SESSION")) {
            systemEnvironment.cEnv.setInfo((String)this.withs.get("SESSION"));
        } else {
            systemEnvironment.cEnv.setInfo(null);
        }
        if (this.withs.containsKey("TRACE_LEVEL")) {
            withHash = this.withs.get("TRACE_LEVEL");
            if (withHash instanceof Boolean) {
                boolean bl = (Boolean)((Object)withHash);
                if (bl) {
                    systemEnvironment.cEnv.trace_on();
                } else {
                    systemEnvironment.cEnv.trace_off();
                }
            } else {
                systemEnvironment.cEnv.setTraceLevel((Integer)((Object)withHash));
            }
        }
        if (this.withs.containsKey("TIMEOUT")) {
            systemEnvironment.cEnv.getMe().setTimeout((Integer)this.withs.get("TIMEOUT"));
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        if (this.isUser) {
            this.connect_user(systemEnvironment);
        } else {
            if (systemEnvironment.getConnectState() != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202081740", "Login restricted"));
            }
            if (this.isJobServer) {
                this.connect_jobserver(systemEnvironment);
            } else if (this.isJob) {
                this.connect_job(systemEnvironment);
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03406282207", "Wrong usertype"));
            }
        }
        this.evaluateWith(systemEnvironment);
        if (this.cmd != null) {
            int n = 0;
            systemEnvironment.tx.beginSubTransaction(systemEnvironment);
            try {
                for (int i = 0; i < this.cmd.size(); ++i) {
                    Node node;
                    ++n;
                    this.actual_cmd = node = (Node)this.cmd.get(i);
                    systemEnvironment.tx.beginSubTransaction(systemEnvironment);
                    if (!(this.env.isUser() ? (node.cmdtype & 1) != 0 : (this.env.isJobServer() ? (node.cmdtype & 2) != 0 : (node.cmdtype & 4) != 0))) {
                        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603041709", "Illegal commandtype within connect command"));
                    }
                    if (node.contextVersion != null) {
                        systemEnvironment.tx.setContextVersionId(systemEnvironment, node.contextVersion);
                    }
                    node.env = this.env;
                    node.go(systemEnvironment);
                    systemEnvironment.tx.commitSubTransaction(systemEnvironment);
                    this.actual_cmd = null;
                    this.result = node.result;
                }
            }
            catch (SDMSException sDMSException) {
                systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                throw sDMSException;
            }
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        } else {
            vector.add("CONNECT_TIME");
            vector2.add(systemEnvironment.systemDateFormat.format(new Date(System.currentTimeMillis())));
            sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03205141302", "Connect"), vector, vector2);
            this.result.setOutputContainer(sDMSOutputContainer);
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "02110192358", "Connected"));
        }
    }
}

