/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.InternalSession;
import de.independit.scheduler.server.ListenThread;
import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.UserConnection;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystemSynchronized;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Collections;
import java.util.Vector;

public class ListSession
extends Node {
    public static final String __version = "@(#) $Id: ListSession.java,v 2.12.6.2 2013/06/18 09:49:34 ronald Exp $";
    private boolean fullView;

    public ListSession() {
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector;
        Object object;
        SDMSOutputContainer sDMSOutputContainer = null;
        boolean bl = false;
        if (systemEnvironment.cEnv.gid().contains(SDMSObject.adminGId)) {
            this.fullView = true;
        } else {
            object = systemEnvironment.cEnv.gid().iterator();
            vector = new SDMSPrivilege();
            while (object.hasNext()) {
                Long l = (Long)object.next();
                try {
                    SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(SDMSConstants.lZERO, l));
                    ((SDMSPrivilege)((Object)vector)).addPriv(systemEnvironment, sDMSGrant.getPrivs(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {}
            }
            this.fullView = ((SDMSPrivilege)((Object)vector)).can(0x200000000000L);
        }
        object = new Vector();
        ((Vector)object).add("THIS");
        ((Vector)object).add("SESSIONID");
        ((Vector)object).add("PORT");
        ((Vector)object).add("START");
        ((Vector)object).add("TYPE");
        ((Vector)object).add("USER");
        ((Vector)object).add("UID");
        ((Vector)object).add("IP");
        ((Vector)object).add("TXID");
        ((Vector)object).add("IDLE");
        ((Vector)object).add("STATE");
        ((Vector)object).add("TIMEOUT");
        ((Vector)object).add("INFORMATION");
        ((Vector)object).add("STATEMENT");
        ((Vector)object).add("WAIT");
        ThreadGroup threadGroup = this.env.getMe().getThreadGroup();
        Thread[] threadArray = new SDMSThread[threadGroup.activeCount() + 5];
        int n = threadGroup.enumerate(threadArray);
        threadArray[n] = SystemEnvironment.sched;
        threadArray[++n] = SystemEnvironment.tt;
        threadArray[++n] = SystemEnvironment.pt;
        threadArray[++n] = SystemEnvironment.garb;
        threadArray[++n] = SystemEnvironment.timer;
        ++n;
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Sessions", (Vector)object);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            ConnectionEnvironment connectionEnvironment;
            if (threadArray[i] instanceof ListenThread || !threadArray[i].isAlive()) continue;
            if (threadArray[i] instanceof UserConnection) {
                connectionEnvironment = ((UserConnection)threadArray[i]).getEnv();
                bl2 = false;
            } else {
                vector = (InternalSession)threadArray[i];
                connectionEnvironment = ((InternalSession)((Object)vector)).getEnv();
                bl2 = true;
                bl = ((SDMSThread)((Object)vector)).isSuspended();
            }
            vector = new Vector();
            if (!this.fillVector(systemEnvironment, connectionEnvironment, vector, bl2, bl)) continue;
            sDMSOutputContainer.addData(systemEnvironment, vector);
            ++n2;
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112181812", "$1 Session(s) found", n2));
        this.result.setOutputContainer(sDMSOutputContainer);
    }

    private boolean fillVector(SystemEnvironment systemEnvironment, ConnectionEnvironment connectionEnvironment, Vector vector, boolean bl, boolean bl2) throws SDMSException {
        if (connectionEnvironment.id() == this.env.id()) {
            vector.add(" * ");
        } else {
            vector.add(" ");
        }
        vector.add(connectionEnvironment.id());
        vector.add(connectionEnvironment.port());
        vector.add(connectionEnvironment.dStart());
        try {
            Object object;
            block18: {
                if (connectionEnvironment.isUser()) {
                    try {
                        object = SDMSUserTable.getObject(systemEnvironment, connectionEnvironment.uid()).getName(systemEnvironment);
                        vector.add("USER");
                        if (bl) {
                            String string = connectionEnvironment.getMe().getClass().getCanonicalName();
                            vector.add(string.substring(string.lastIndexOf(46) + 1) + (bl2 ? "[S]" : ""));
                            break block18;
                        }
                        vector.add(object);
                    }
                    catch (NotFoundException notFoundException) {
                        String string = SDMSScopeTable.getObject(systemEnvironment, connectionEnvironment.uid()).pathString(systemEnvironment);
                        vector.add("JOBSERVER");
                        vector.add(string);
                    }
                } else if (connectionEnvironment.isJobServer()) {
                    object = SDMSScopeTable.getObject(systemEnvironment, connectionEnvironment.uid()).pathString(systemEnvironment);
                    vector.add("JOBSERVER");
                    vector.add(object);
                } else {
                    object = SDMSSubmittedEntityTable.getObject(systemEnvironment, connectionEnvironment.uid());
                    long l = ((SDMSSubmittedEntityProxyGeneric)object).getSeVersion(systemEnvironment);
                    String string = SDMSSchedulingEntityTable.getObject(systemEnvironment, ((SDMSSubmittedEntityProxyGeneric)object).getSeId(systemEnvironment), l).getName(systemEnvironment);
                    vector.add("JOB");
                    vector.add(string);
                }
            }
            vector.add(connectionEnvironment.uid());
            vector.add(connectionEnvironment.ip());
            vector.add(connectionEnvironment.txId());
            vector.add(connectionEnvironment.idle());
            object = connectionEnvironment.getState().toString();
            String string = "";
            if (SystemEnvironment.maxWriter > 1 && connectionEnvironment.worker != null && !(string = LockingSystemSynchronized.waitInfo(connectionEnvironment.worker)).equals("")) {
                object = (String)object + "[W]";
            }
            vector.add(object);
            vector.add(connectionEnvironment.getMe().getTimeout());
            vector.add(connectionEnvironment.getInfo());
            try {
                if (this.fullView) {
                    if (connectionEnvironment.firstToken != null) {
                        vector.add(connectionEnvironment.firstToken);
                    } else {
                        vector.add(new String(connectionEnvironment.actstmt == null ? "" : connectionEnvironment.actstmt));
                    }
                } else {
                    vector.add("");
                }
            }
            catch (Exception exception) {
                vector.add("");
            }
            vector.add(string);
            return true;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }
}

