/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.WithItem;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSNiceProfileTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplateTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.repository.SDMSWatchTypeTable;
import de.independit.scheduler.server.util.PathVector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

public class ObjectURL {
    public static final String __version = "@(#) $Id: ObjectURL.java,v 2.15.4.2 2013/03/19 17:16:48 ronald Exp $";
    public Long objId = null;
    public Integer objType = null;
    public Integer parserType = null;
    public String name = null;
    public PathVector path = null;
    public ObjectURL master = null;
    public Long seId;
    public Long sceId;
    public Long evtId;
    public String mappedName = null;
    public WithItem seSpec;
    public boolean wildcard = false;
    public WithItem triggerInverse;
    private static final HashMap typeFromURL = new HashMap();

    public ObjectURL(Integer n) {
        this.objId = null;
        this.objType = (Integer)typeFromURL.get(n);
        this.parserType = n;
    }

    public ObjectURL(Integer n, Long l) {
        this.objId = l;
        this.objType = (Integer)typeFromURL.get(n);
        this.parserType = n;
    }

    public ObjectURL(Integer n, String string) {
        this.name = string;
        this.objType = (Integer)typeFromURL.get(n);
        this.parserType = n;
    }

    public ObjectURL(Integer n, String string, WithItem withItem) throws SDMSException {
        this.name = string;
        this.objType = (Integer)typeFromURL.get(n);
        this.seSpec = withItem;
        this.parserType = n;
    }

    public ObjectURL(Integer n, PathVector pathVector) {
        this.path = pathVector;
        this.objType = (Integer)typeFromURL.get(n);
        if (this.path.get(this.path.size() - 1) == null) {
            this.wildcard = true;
            this.path.remove(this.path.size() - 1);
        }
        this.parserType = n;
    }

    public ObjectURL(Integer n, PathVector pathVector, WithItem withItem) throws SDMSException {
        this.path = pathVector;
        this.objType = (Integer)typeFromURL.get(n);
        this.seSpec = withItem;
        if (this.path.get(this.path.size() - 1) == null) {
            this.wildcard = true;
            this.path.remove(this.path.size() - 1);
        }
        this.parserType = n;
    }

    public ObjectURL(Integer n, PathVector pathVector, ObjectURL objectURL) {
        this.objType = (Integer)typeFromURL.get(n);
        this.master = objectURL;
        this.path = pathVector;
        if (this.path.get(this.path.size() - 1) == null) {
            this.wildcard = true;
            this.path.remove(this.path.size() - 1);
        }
        this.parserType = n;
    }

    public ObjectURL(Integer n, String string, ObjectURL objectURL) {
        this.objType = (Integer)typeFromURL.get(n);
        this.master = objectURL;
        this.name = string;
        this.parserType = n;
    }

    public ObjectURL(Integer n, String string, ObjectURL objectURL, WithItem withItem) {
        this.objType = (Integer)typeFromURL.get(n);
        this.master = objectURL;
        this.name = string;
        this.parserType = n;
        this.triggerInverse = withItem;
    }

    public SDMSProxy resolve(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.objType == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03512131431", "Cannot resolve an Object when the type is unknown"));
        }
        if (this.objId != null && this.name == null && this.path == null) {
            return this.resolveById(systemEnvironment);
        }
        if (this.name != null || this.path != null) {
            return this.resolveByName(systemEnvironment);
        }
        return null;
    }

    private SDMSProxy resolveById(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        switch (this.objType) {
            case 25: {
                sDMSProxy = SDMSPoolDistributionTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 1: {
                sDMSProxy = SDMSNamedEnvironmentTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 18: {
                sDMSProxy = SDMSEventTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 2: {
                sDMSProxy = SDMSExitStateDefinitionTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 3: {
                sDMSProxy = SDMSExitStateProfileTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 4: {
                sDMSProxy = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 5: {
                sDMSProxy = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 6: 
            case 9: {
                try {
                    sDMSProxy = SDMSFolderTable.getObject(systemEnvironment, this.objId);
                    this.objType = SDMSConstants.OC_FOLDER;
                }
                catch (NotFoundException notFoundException) {
                    sDMSProxy = SDMSSchedulingEntityTable.getObject(systemEnvironment, this.objId);
                    this.objType = SDMSConstants.OC_JOB_DEFINITION;
                }
                break;
            }
            case 7: {
                sDMSProxy = SDMSFootprintTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 21: {
                sDMSProxy = SDMSGroupTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 19: {
                sDMSProxy = SDMSIntervalTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 17: {
                sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 10: {
                sDMSProxy = SDMSNamedResourceTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 31: {
                sDMSProxy = SDMSNiceProfileTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 30: {
                sDMSProxy = SDMSObjectMonitorTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 23: {
                sDMSProxy = SDMSParameterDefinitionTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 24: {
                sDMSProxy = SDMSPoolTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 11: {
                try {
                    sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, this.objId);
                }
                catch (NotFoundException notFoundException) {
                    sDMSProxy = SDMSResourceTemplateTable.getObject(systemEnvironment, this.objId);
                }
                break;
            }
            case 13: {
                sDMSProxy = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 14: {
                sDMSProxy = SDMSResourceStateProfileTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 12: {
                sDMSProxy = SDMSResourceStateMappingProfileTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 20: {
                sDMSProxy = SDMSScheduleTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 22: {
                sDMSProxy = SDMSScheduledEventTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 15: {
                sDMSProxy = SDMSScopeTable.getObject(systemEnvironment, this.objId);
                if (((SDMSScope)sDMSProxy).getType(systemEnvironment) != 2) break;
                this.parserType = SDMSConstants.PS_JOB_SERVER;
                break;
            }
            case 16: {
                sDMSProxy = SDMSTriggerTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 8: {
                sDMSProxy = SDMSUserTable.getObject(systemEnvironment, this.objId);
                break;
            }
            case 29: {
                sDMSProxy = SDMSWatchTypeTable.getObject(systemEnvironment, this.objId);
                break;
            }
        }
        return sDMSProxy;
    }

    private SDMSProxy resolveByName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        switch (this.objType) {
            case 25: {
                sDMSProxy = this.getDistribution(systemEnvironment);
                break;
            }
            case 1: {
                sDMSProxy = this.getEnvironment(systemEnvironment);
                break;
            }
            case 18: {
                sDMSProxy = this.getEvent(systemEnvironment);
                break;
            }
            case 2: {
                sDMSProxy = this.getExitStateDefinition(systemEnvironment);
                break;
            }
            case 3: {
                sDMSProxy = this.getExitStateProfile(systemEnvironment);
                break;
            }
            case 4: {
                sDMSProxy = this.getExitStateMapping(systemEnvironment);
                break;
            }
            case 5: {
                sDMSProxy = this.getExitStateTranslation(systemEnvironment);
                break;
            }
            case 6: {
                sDMSProxy = this.getFolder(systemEnvironment);
                break;
            }
            case 7: {
                sDMSProxy = this.getFootprint(systemEnvironment);
                break;
            }
            case 21: {
                sDMSProxy = this.getGroup(systemEnvironment);
                break;
            }
            case 19: {
                sDMSProxy = this.getInterval(systemEnvironment);
                break;
            }
            case 9: {
                sDMSProxy = this.getSchedulingEntity(systemEnvironment);
                break;
            }
            case 10: {
                sDMSProxy = this.getNamedResource(systemEnvironment);
                break;
            }
            case 31: {
                sDMSProxy = this.getNiceProfile(systemEnvironment);
                break;
            }
            case 30: {
                sDMSProxy = this.getObjectMonitor(systemEnvironment);
                break;
            }
            case 23: {
                sDMSProxy = this.getParameterDefinition(systemEnvironment);
                break;
            }
            case 24: {
                sDMSProxy = this.getPool(systemEnvironment);
                break;
            }
            case 11: {
                sDMSProxy = this.getResource(systemEnvironment);
                break;
            }
            case 13: {
                sDMSProxy = this.getResourceStateDefinition(systemEnvironment);
                break;
            }
            case 14: {
                sDMSProxy = this.getResourceStateProfile(systemEnvironment);
                break;
            }
            case 12: {
                sDMSProxy = this.getResourceStateMapping(systemEnvironment);
                break;
            }
            case 20: {
                sDMSProxy = this.getSchedule(systemEnvironment);
                break;
            }
            case 22: {
                sDMSProxy = this.getScheduledEvent(systemEnvironment);
                break;
            }
            case 15: {
                sDMSProxy = this.getScope(systemEnvironment);
                if (((SDMSScope)sDMSProxy).getType(systemEnvironment) != 2) break;
                this.parserType = SDMSConstants.PS_JOB_SERVER;
                break;
            }
            case 16: {
                sDMSProxy = this.getTrigger(systemEnvironment);
                break;
            }
            case 8: {
                sDMSProxy = this.getUser(systemEnvironment);
                break;
            }
            case 29: {
                sDMSProxy = this.getWatchType(systemEnvironment);
                break;
            }
        }
        if (sDMSProxy != null) {
            this.objId = sDMSProxy.getId(systemEnvironment);
        }
        return sDMSProxy;
    }

    private final String getObjectName(SystemEnvironment systemEnvironment, String string, WithItem withItem) throws SDMSException {
        if (withItem == null) {
            return string;
        }
        this.seId = IntervalUtil.getCheckedSeId(systemEnvironment, withItem);
        return IntervalUtil.mapIdName(string, this.seId);
    }

    private SDMSPoolDistribution getDistribution(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSPoolDistribution sDMSPoolDistribution = null;
        SDMSProxy sDMSProxy = this.master.resolve(systemEnvironment);
        sDMSPoolDistribution = SDMSPoolDistributionTable.idx_name_pId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.name), this.master.objId));
        return sDMSPoolDistribution;
    }

    private SDMSNiceProfile getNiceProfile(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNiceProfile sDMSNiceProfile = null;
        sDMSNiceProfile = SDMSNiceProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSNiceProfile;
    }

    private SDMSNamedEnvironment getEnvironment(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedEnvironment sDMSNamedEnvironment = null;
        sDMSNamedEnvironment = SDMSNamedEnvironmentTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSNamedEnvironment;
    }

    private SDMSEvent getEvent(SystemEnvironment systemEnvironment) throws SDMSException {
        this.mappedName = this.getObjectName(systemEnvironment, this.name, this.seSpec);
        SDMSEvent sDMSEvent = null;
        sDMSEvent = SDMSEventTable.idx_name_getUnique(systemEnvironment, this.mappedName);
        return sDMSEvent;
    }

    private SDMSExitStateDefinition getExitStateDefinition(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateDefinition sDMSExitStateDefinition = null;
        sDMSExitStateDefinition = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSExitStateDefinition;
    }

    private SDMSExitStateProfile getExitStateProfile(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateProfile sDMSExitStateProfile = null;
        sDMSExitStateProfile = SDMSExitStateProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSExitStateProfile;
    }

    private SDMSExitStateMappingProfile getExitStateMapping(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateMappingProfile sDMSExitStateMappingProfile = null;
        sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSExitStateMappingProfile;
    }

    private SDMSExitStateTranslationProfile getExitStateTranslation(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile = null;
        sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSExitStateTranslationProfile;
    }

    private SDMSProxy getFolder(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        try {
            sDMSProxy = SDMSFolderTable.getFolder(systemEnvironment, this.path);
        }
        catch (NotFoundException notFoundException) {
            this.objType = SDMSConstants.OC_JOB_DEFINITION;
            sDMSProxy = this.getSchedulingEntity(systemEnvironment);
        }
        return sDMSProxy;
    }

    private SDMSFootprint getFootprint(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFootprint sDMSFootprint = null;
        sDMSFootprint = SDMSFootprintTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSFootprint;
    }

    private SDMSGroup getGroup(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSGroup sDMSGroup = null;
        sDMSGroup = SDMSGroupTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSGroup;
    }

    private SDMSInterval getInterval(SystemEnvironment systemEnvironment) throws SDMSException {
        this.mappedName = this.getObjectName(systemEnvironment, this.name, this.seSpec);
        SDMSInterval sDMSInterval = null;
        sDMSInterval = SDMSIntervalTable.idx_name_objId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.mappedName), null));
        return sDMSInterval;
    }

    private SDMSSchedulingEntity getSchedulingEntity(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSchedulingEntity sDMSSchedulingEntity = null;
        sDMSSchedulingEntity = SDMSSchedulingEntityTable.get(systemEnvironment, this.path, null);
        return sDMSSchedulingEntity;
    }

    private SDMSNamedResource getNamedResource(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = null;
        sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path);
        return sDMSNamedResource;
    }

    private SDMSObjectMonitor getObjectMonitor(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectMonitor sDMSObjectMonitor = null;
        sDMSObjectMonitor = SDMSObjectMonitorTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSObjectMonitor;
    }

    private SDMSParameterDefinition getParameterDefinition(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSParameterDefinition sDMSParameterDefinition = null;
        SDMSProxy sDMSProxy = this.master.resolve(systemEnvironment);
        sDMSParameterDefinition = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(this.master.objId, (Comparable)((Object)this.name)));
        return sDMSParameterDefinition;
    }

    private SDMSPool getPool(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSPool sDMSPool = null;
        SDMSProxy sDMSProxy = this.master.resolve(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path);
        Long l = sDMSNamedResource.getId(systemEnvironment);
        sDMSPool = SDMSPoolTable.idx_nrId_scopeId_getUnique(systemEnvironment, new SDMSKey(l, this.master.objId));
        return sDMSPool;
    }

    private SDMSProxy getResource(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSProxy sDMSProxy = null;
        SDMSProxy sDMSProxy2 = this.master.resolve(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path);
        Long l = sDMSNamedResource.getId(systemEnvironment);
        SDMSKey sDMSKey = new SDMSKey(l, this.master.objId);
        try {
            sDMSProxy = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, sDMSKey);
        }
        catch (NotFoundException notFoundException) {
            this.objType = SDMSConstants.OC_RESOURCE_TEMPLATE;
            sDMSProxy = SDMSResourceTemplateTable.idx_nrId_seId_getUnique(systemEnvironment, sDMSKey);
        }
        return sDMSProxy;
    }

    private SDMSResourceStateDefinition getResourceStateDefinition(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateDefinition sDMSResourceStateDefinition = null;
        sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSResourceStateDefinition;
    }

    private SDMSResourceStateProfile getResourceStateProfile(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateProfile sDMSResourceStateProfile = null;
        sDMSResourceStateProfile = SDMSResourceStateProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSResourceStateProfile;
    }

    private SDMSResourceStateMappingProfile getResourceStateMapping(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateMappingProfile sDMSResourceStateMappingProfile = null;
        sDMSResourceStateMappingProfile = SDMSResourceStateMappingProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSResourceStateMappingProfile;
    }

    private SDMSSchedule getSchedule(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.seSpec != null) {
            PathVector pathVector;
            String string;
            this.seId = IntervalUtil.getCheckedSeId(systemEnvironment, this.seSpec);
            if (this.path.size() > 2) {
                string = (String)this.path.remove(this.path.size() - 1);
                pathVector = (PathVector)IntervalUtil.mapIdPath(this.path, this.seId);
            } else {
                string = IntervalUtil.mapIdPath((String)this.path.remove(this.path.size() - 1), this.seId);
                pathVector = this.path;
            }
            this.path = pathVector;
            this.path.add(string);
        }
        return SDMSScheduleTable.getSchedule(systemEnvironment, this.path);
    }

    private SDMSScheduledEvent getScheduledEvent(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        String string = (String)this.path.remove(this.path.size() - 1);
        if (this.seSpec == null) {
            this.sceId = SDMSScheduleTable.pathToId(systemEnvironment, this.path);
            object = SDMSEventTable.idx_name_getUnique(systemEnvironment, string);
            this.evtId = ((SDMSProxy)object).getId(systemEnvironment);
            this.path.add(string);
        } else {
            object = new ObjectURL(SDMSConstants.PS_EVENT, string, this.seSpec);
            ((ObjectURL)object).resolveByName(systemEnvironment);
            this.evtId = ((ObjectURL)object).objId;
            ObjectURL objectURL = new ObjectURL(SDMSConstants.PS_SCHEDULE, this.path, this.seSpec);
            objectURL.resolveByName(systemEnvironment);
            this.sceId = objectURL.objId;
            this.path = new PathVector((Collection)objectURL.path);
            this.path.add(((ObjectURL)object).name);
        }
        object = new SDMSKey(this.sceId, this.evtId);
        return SDMSScheduledEventTable.idx_sceId_evtId_getUnique(systemEnvironment, object);
    }

    private SDMSScope getScope(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSScope sDMSScope = null;
        sDMSScope = SDMSScopeTable.getScope(systemEnvironment, this.path);
        return sDMSScope;
    }

    private SDMSTrigger getTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSTrigger sDMSTrigger = null;
        SDMSProxy sDMSProxy = this.master.resolve(systemEnvironment);
        Boolean bl = (Boolean)this.triggerInverse.value;
        Vector vector = bl != false ? SDMSTriggerTable.idx_seId_name.getVector(systemEnvironment, new SDMSKey(this.master.objId, (Comparable)((Object)this.name))) : SDMSTriggerTable.idx_fireId_name.getVector(systemEnvironment, new SDMSKey(this.master.objId, (Comparable)((Object)this.name)));
        for (int i = 0; i < vector.size() && !(sDMSTrigger = (SDMSTrigger)vector.get(i)).getIsInverse(systemEnvironment).equals(bl); ++i) {
            sDMSTrigger = null;
        }
        if (sDMSTrigger == null) {
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03309051227", "No trigger with name $1 found", this.name));
        }
        return sDMSTrigger;
    }

    private SDMSUser getUser(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSUser sDMSUser = null;
        sDMSUser = SDMSUserTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSUser;
    }

    private SDMSWatchType getWatchType(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSWatchType sDMSWatchType = null;
        sDMSWatchType = SDMSWatchTypeTable.idx_name_getUnique(systemEnvironment, this.name);
        return sDMSWatchType;
    }

    public String toString() {
        String string = null;
        switch (this.objType) {
            case 25: {
                string = "DISTRIBUTION " + (this.name != null ? this.name + " FOR " + this.master.toString() : this.objId.toString());
                break;
            }
            case 1: {
                string = "ENVIRONMENT " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 18: {
                string = "EVENT " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 2: {
                string = "EXIT STATE DEFINITION " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 3: {
                string = "EXIT STATE PROFILE " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 4: {
                string = "EXIT STATE MAPPING " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 5: {
                string = "EXIT STATE TRANSLATION " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 6: {
                string = "FOLDER " + (this.path != null ? this.path.toString() : this.objId.toString());
                break;
            }
            case 7: {
                string = "FOOTPRINT " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 21: {
                string = "GROUP " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 19: {
                string = "INTERVAL " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 17: {
                string = "JOB " + this.objId.toString();
                break;
            }
            case 9: {
                string = "JOB DEFINITION " + (this.path != null ? this.path.toString() : this.objId.toString());
                break;
            }
            case 10: {
                string = "NAMED RESOURCE " + (this.path != null ? this.path.toString() : this.objId.toString());
                break;
            }
            case 31: {
                string = "NICE PROFILE " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 30: {
                string = "OBJECT MONITOR " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 23: {
                string = "PARAMETER " + (this.name != null ? this.name + " OF " + this.master.toString() : this.objId.toString());
                break;
            }
            case 24: {
                string = "POOL " + (this.path != null ? this.path.toString() + " IN " + this.master.toString() : this.objId.toString());
                break;
            }
            case 11: {
                string = "RESOURCE " + (this.path != null ? this.path.toString() + " IN " + this.master.toString() : this.objId.toString());
                break;
            }
            case 13: {
                string = "RESOURCE STATE DEFINITION " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 14: {
                string = "RESOURCE STATE PROFILE " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 12: {
                string = "RESOURCE STATE MAPPING " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 20: {
                string = "SCHEDULE " + (this.path != null ? this.path.toString() : this.objId.toString());
                break;
            }
            case 22: {
                string = "SCHEDULED EVENT " + (this.path != null ? this.path.toString() : this.objId.toString());
                break;
            }
            case 15: {
                string = "SCOPE " + (this.path != null ? this.path.toString() : this.objId.toString());
                break;
            }
            case 16: {
                string = "TRIGGER " + (this.name != null ? this.name + " ON " + this.master.toString() : this.objId.toString());
                break;
            }
            case 8: {
                string = "USER " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
            case 29: {
                string = "WATCH TYPE " + (this.name != null ? this.name : this.objId.toString());
                break;
            }
        }
        return string;
    }

    static {
        typeFromURL.put(341, 25);
        typeFromURL.put(352, 1);
        typeFromURL.put(357, 18);
        typeFromURL.put(363, 2);
        typeFromURL.put(365, 3);
        typeFromURL.put(364, 4);
        typeFromURL.put(366, 5);
        typeFromURL.put(382, 6);
        typeFromURL.put(383, 7);
        typeFromURL.put(395, 21);
        typeFromURL.put(416, 19);
        typeFromURL.put(422, 9);
        typeFromURL.put(425, 15);
        typeFromURL.put(421, 17);
        typeFromURL.put(478, 10);
        typeFromURL.put(479, 31);
        typeFromURL.put(497, 30);
        typeFromURL.put(508, 23);
        typeFromURL.put(515, 24);
        typeFromURL.put(540, 11);
        typeFromURL.put(543, 13);
        typeFromURL.put(545, 14);
        typeFromURL.put(544, 12);
        typeFromURL.put(541, 28);
        typeFromURL.put(563, 20);
        typeFromURL.put(565, 22);
        typeFromURL.put(566, 15);
        typeFromURL.put(619, 16);
        typeFromURL.put(630, 8);
        typeFromURL.put(636, 29);
        typeFromURL.put(310, 26);
        typeFromURL.put(394, 27);
    }
}

