/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.JobDistribution;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import java.util.Vector;

public class ReassureJob
extends JobDistribution {
    public static final String __version = "@(#) $Id: ReassureJob.java,v 2.2.14.1 2013/03/14 10:24:43 ronald Exp $";
    Long jobId;

    public ReassureJob(Long l) {
        this.jobId = l;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        vector.add("COMMAND");
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        if (sDMSScope.getIsTerminate(systemEnvironment).booleanValue()) {
            vector2.add("SHUTDOWN");
            sDMSScope.setIsTerminate(systemEnvironment, Boolean.FALSE);
        } else {
            this.search_job(systemEnvironment, sDMSScope, vector, vector2);
        }
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Jobserver Command", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
    }

    private void search_job(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, Vector vector, Vector vector2) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity;
        SDMSKillJob sDMSKillJob = null;
        try {
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.jobId);
        }
        catch (NotFoundException notFoundException) {
            try {
                sDMSKillJob = SDMSKillJobTable.getObject(systemEnvironment, this.jobId);
            }
            catch (NotFoundException notFoundException2) {
                vector2.add("DISPOSE");
                return;
            }
            this.process_killjob(systemEnvironment, sDMSScope, sDMSKillJob, vector, vector2);
            return;
        }
        this.process_job(systemEnvironment, sDMSScope, sDMSSubmittedEntity, vector, vector2);
    }

    private void process_job(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, SDMSSubmittedEntity sDMSSubmittedEntity, Vector vector, Vector vector2) throws SDMSException {
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        if (n != 5 && n != 6) {
            vector2.add("DISPOSE");
            return;
        }
        Long l = sDMSSubmittedEntity.getScopeId(systemEnvironment);
        if (l == null || !l.equals(sDMSScope.getId(systemEnvironment))) {
            vector2.add("DISPOSE");
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        if (!this.startJob(systemEnvironment, sDMSSubmittedEntity, sDMSScope, vector, vector2)) {
            // empty if block
        }
    }

    private void process_killjob(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, SDMSKillJob sDMSKillJob, Vector vector, Vector vector2) throws SDMSException {
        int n = sDMSKillJob.getState(systemEnvironment);
        if (n != 5 && n != 6) {
            vector2.add("DISPOSE");
            return;
        }
        Long l = sDMSKillJob.getScopeId(systemEnvironment);
        if (l == null || !l.equals(sDMSScope.getId(systemEnvironment))) {
            vector2.add("DISPOSE");
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        if (!this.startKillJob(systemEnvironment, sDMSKillJob, sDMSScope, vector, vector2)) {
            // empty if block
        }
    }
}

