/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntry;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowNiceProfile
extends ShowCommented {
    private ObjectURL url;

    public ShowNiceProfile(ObjectURL objectURL) {
        this.url = objectURL;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Date date = new Date();
        SDMSNiceProfile sDMSNiceProfile = (SDMSNiceProfile)this.url.resolve(systemEnvironment);
        if (!sDMSNiceProfile.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03408110918", "Insufficient privileges"));
        }
        Long l = sDMSNiceProfile.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("IS_ACTIVE");
        vector.add("ACTIVE_TS");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("ENTRIES");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSNiceProfile.getName(systemEnvironment));
        vector2.add(sDMSNiceProfile.getIsActive(systemEnvironment));
        Long l2 = sDMSNiceProfile.getActiveTs(systemEnvironment);
        if (l2 != null) {
            date.setTime(l2);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSNiceProfile.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSNiceProfile.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSNiceProfile.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSNiceProfile.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSNiceProfile.getPrivileges(systemEnvironment).toString());
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ID");
        vector3.add("PREFERENCE");
        vector3.add("FOLDER_ID");
        vector3.add("FOLDER_NAME");
        vector3.add("FOLDER_TYPE");
        vector3.add("ACTIVE");
        vector3.add("RENICE");
        vector3.add("IS_SUSPENDED");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSNiceProfileEntryTable.idx_npId.getVector(systemEnvironment, l);
        for (SDMSNiceProfileEntry sDMSNiceProfileEntry : vector4) {
            Vector<Object> vector5 = new Vector<Object>();
            vector5.add(sDMSNiceProfileEntry.getId(systemEnvironment));
            vector5.add(sDMSNiceProfileEntry.getPreference(systemEnvironment));
            Long l3 = sDMSNiceProfileEntry.getFolderId(systemEnvironment);
            vector5.add(l3);
            if (l3 != null) {
                try {
                    SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l3);
                    vector5.add(sDMSFolder.pathString(systemEnvironment));
                    vector5.add("FOLDER");
                }
                catch (NotFoundException notFoundException) {
                    SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l3);
                    vector5.add(sDMSSchedulingEntity.pathString(systemEnvironment));
                    vector5.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
                }
            } else {
                vector5.add(null);
                vector5.add(null);
            }
            vector5.add(sDMSNiceProfileEntry.getIsActive(systemEnvironment));
            vector5.add(sDMSNiceProfileEntry.getRenice(systemEnvironment));
            vector5.add(sDMSNiceProfileEntry.getIsSuspendedAsString(systemEnvironment));
            sDMSOutputContainer2.addData(systemEnvironment, vector5);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 1));
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03408141539", "Nice Profile"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03408110922", "Nice Profile shown"));
    }
}

