/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSInstanceValue;
import de.independit.scheduler.server.repository.SDMSInstanceValueTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObjectEvent;
import de.independit.scheduler.server.repository.SDMSObjectEventTable;
import de.independit.scheduler.server.repository.SDMSObjectInstance;
import de.independit.scheduler.server.repository.SDMSObjectInstanceTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameter;
import de.independit.scheduler.server.repository.SDMSObjectMonitorParameterTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSWatchType;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameter;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeTable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class ShowObjectMonitor
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowObjectMonitor.java,v 2.4.4.5 2013/09/13 08:58:44 dieter Exp $";
    ObjectURL url;

    public ShowObjectMonitor(ObjectURL objectURL) {
        this.txMode = 1;
        this.auditFlag = false;
        this.url = objectURL;
        this.cmdtype |= 4;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        systemEnvironment.checkFeatureAvailability("OBJECT_MONITOR");
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSObjectMonitor sDMSObjectMonitor = (SDMSObjectMonitor)this.url.resolve(systemEnvironment);
        if (!sDMSObjectMonitor.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "02108251010", "Insufficient privileges"));
        }
        Long l = sDMSObjectMonitor.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("WATCH_TYPE");
        vector.add("RECREATE");
        vector.add("WATCHER");
        vector.add("DELETE_AMOUNT");
        vector.add("DELETE_BASE");
        vector.add("EVENT_DELETE_AMOUNT");
        vector.add("EVENT_DELETE_BASE");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("PARAMETERS");
        vector.add("INSTANCES");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSObjectMonitor.getName(systemEnvironment));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSObjectMonitor.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        SDMSWatchType sDMSWatchType = SDMSWatchTypeTable.getObject(systemEnvironment, sDMSObjectMonitor.getWtId(systemEnvironment));
        vector2.add(sDMSWatchType.getName(systemEnvironment));
        vector2.add(sDMSObjectMonitor.getRecreateHandlingAsString(systemEnvironment));
        Long l2 = sDMSObjectMonitor.getWatchSeId(systemEnvironment);
        if (l2 != null) {
            comparable = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSObjectMonitor.getWatchSeId(systemEnvironment));
            vector2.add(((SDMSSchedulingEntity)comparable).pathVector(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSObjectMonitor.getDeleteAmount(systemEnvironment));
        vector2.add(sDMSObjectMonitor.getDeleteBaseAsString(systemEnvironment));
        vector2.add(sDMSObjectMonitor.getEventDeleteAmount(systemEnvironment));
        vector2.add(sDMSObjectMonitor.getEventDeleteBaseAsString(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        comparable = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSObjectMonitor.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(sDMSObjectMonitor.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSObjectMonitor.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(sDMSObjectMonitor.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        vector2.add(sDMSObjectMonitor.getPrivileges(systemEnvironment).toString());
        vector2.add(this.getParameters(systemEnvironment, sDMSObjectMonitor));
        vector2.add(this.getInstances(systemEnvironment, sDMSObjectMonitor));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "02108251021", "Object Type"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108251022", "Object Type shown"));
    }

    private SDMSOutputContainer getParameters(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("VALUE");
        vector.add("IS_DEFAULT");
        vector.add("DEFAULT_VALUE");
        vector.add("IS_SUBMIT_PAR");
        vector.add("PRIVS");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSWatchTypeParameterTable.idx_wtId.getVector(systemEnvironment, sDMSObjectMonitor.getWtId(systemEnvironment));
        Long l = sDMSObjectMonitor.getId(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        SDMSScope sDMSScope = null;
        if (systemEnvironment.cEnv.isJob()) {
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.env.uid());
            sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSSubmittedEntity.getScopeId(systemEnvironment));
        }
        for (SDMSWatchTypeParameter sDMSWatchTypeParameter : vector2) {
            String string;
            SDMSObjectMonitorParameter sDMSObjectMonitorParameter;
            if (sDMSWatchTypeParameter.getType(systemEnvironment) != 1) continue;
            Vector<Object> vector3 = new Vector<Object>();
            try {
                sDMSObjectMonitorParameter = SDMSObjectMonitorParameterTable.idx_omId_wtpId_getUnique(systemEnvironment, new SDMSKey(l, sDMSWatchTypeParameter.getId(systemEnvironment)));
            }
            catch (NotFoundException notFoundException) {
                sDMSObjectMonitorParameter = null;
            }
            String string2 = sDMSWatchTypeParameter.getDefaultValue(systemEnvironment);
            if (string2 != null) {
                string2 = string2.substring(1);
            }
            if (sDMSObjectMonitorParameter != null) {
                vector3.add(sDMSObjectMonitorParameter.getId(systemEnvironment));
                vector3.add(sDMSWatchTypeParameter.getName(systemEnvironment));
                string = sDMSObjectMonitorParameter.getValue(systemEnvironment);
                if (string != null) {
                    string = string.substring(1);
                }
                if (sDMSSubmittedEntity != null) {
                    string = sDMSObjectMonitor.getVariableValue(systemEnvironment, sDMSWatchTypeParameter.getName(systemEnvironment), true);
                }
                vector3.add(string);
                vector3.add(Boolean.FALSE);
                string = sDMSWatchTypeParameter.getDefaultValue(systemEnvironment);
                if (string != null) {
                    string = string.substring(1);
                }
                vector3.add(string);
                vector3.add(sDMSWatchTypeParameter.getIsSubmitPar(systemEnvironment));
                vector3.add(sDMSObjectMonitorParameter.getPrivileges(systemEnvironment).toString());
            } else {
                vector3.add(sDMSWatchTypeParameter.getId(systemEnvironment));
                vector3.add(sDMSWatchTypeParameter.getName(systemEnvironment));
                string = sDMSWatchTypeParameter.getDefaultValue(systemEnvironment);
                if (string != null) {
                    string = string.substring(1);
                }
                vector3.add(string);
                vector3.add(Boolean.TRUE);
                vector3.add(string);
                vector3.add(sDMSWatchTypeParameter.getIsSubmitPar(systemEnvironment));
                vector3.add(sDMSWatchTypeParameter.getPrivileges(systemEnvironment).toString());
            }
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer getInstances(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor) throws SDMSException {
        Long l = sDMSObjectMonitor.getId(systemEnvironment);
        Date date = new Date();
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("UNIQUE_NAME");
        vector.add("CREATE_TS");
        vector.add("MODIFY_TS");
        vector.add("REMOVE_TS");
        vector.add("TRIGGERNAME");
        vector.add("EVENTTYPE");
        vector.add("SME_ID");
        vector.add("SUBMIT_TS");
        vector.add("FINAL_TS");
        vector.add("FINAL_EXIT_STATE");
        vector.add("JOBSTATE");
        vector.add("JOB_IS_RESTARTABLE");
        vector.add("JOBNAME");
        vector.add("JOBTYPE");
        vector.add("MAIN_SME_ID");
        vector.add("MAIN_FINAL_TS");
        vector.add("MAIN_FINAL_EXIT_STATE");
        vector.add("MAIN_JOBSTATE");
        vector.add("MAIN_JOB_IS_RESTARTABLE");
        vector.add("MAIN_JOBNAME");
        vector.add("MAIN_JOBTYPE");
        vector.add("MASTER_SME_ID");
        vector.add("CNT_SUBMITTED");
        vector.add("CNT_DEPENDENCY_WAIT");
        vector.add("CNT_SYNCHRONIZE_WAIT");
        vector.add("CNT_RESOURCE_WAIT");
        vector.add("CNT_RUNNABLE");
        vector.add("CNT_STARTING");
        vector.add("CNT_STARTED");
        vector.add("CNT_RUNNING");
        vector.add("CNT_TO_KILL");
        vector.add("CNT_KILLED");
        vector.add("CNT_CANCELLED");
        vector.add("CNT_FINISHED");
        vector.add("CNT_FINAL");
        vector.add("CNT_BROKEN_ACTIVE");
        vector.add("CNT_BROKEN_FINISHED");
        vector.add("CNT_ERROR");
        vector.add("CNT_RESTARTABLE");
        vector.add("CNT_UNREACHABLE");
        vector.add("CNT_WARN");
        vector.add("WARN_COUNT");
        vector.add("MAIN_CNT_SUBMITTED");
        vector.add("MAIN_CNT_DEPENDENCY_WAIT");
        vector.add("MAIN_CNT_SYNCHRONIZE_WAIT");
        vector.add("MAIN_CNT_RESOURCE_WAIT");
        vector.add("MAIN_CNT_RUNNABLE");
        vector.add("MAIN_CNT_STARTING");
        vector.add("MAIN_CNT_STARTED");
        vector.add("MAIN_CNT_RUNNING");
        vector.add("MAIN_CNT_TO_KILL");
        vector.add("MAIN_CNT_KILLED");
        vector.add("MAIN_CNT_CANCELLED");
        vector.add("MAIN_CNT_FINISHED");
        vector.add("MAIN_CNT_FINAL");
        vector.add("MAIN_CNT_BROKEN_ACTIVE");
        vector.add("MAIN_CNT_BROKEN_FINISHED");
        vector.add("MAIN_CNT_ERROR");
        vector.add("MAIN_CNT_RESTARTABLE");
        vector.add("MAIN_CNT_UNREACHABLE");
        vector.add("MAIN_CNT_WARN");
        vector.add("MAIN_WARN_COUNT");
        vector.add("PRIVS");
        Vector vector2 = SDMSWatchTypeParameterTable.idx_wtId.getVector(systemEnvironment, sDMSObjectMonitor.getWtId(systemEnvironment));
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            SDMSWatchTypeParameter sDMSWatchTypeParameter = (SDMSWatchTypeParameter)iterator.next();
            if (sDMSWatchTypeParameter.getType(systemEnvironment) == 1) {
                iterator.remove();
                continue;
            }
            vector.add(sDMSWatchTypeParameter.getName(systemEnvironment));
        }
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector3 = SDMSObjectInstanceTable.idx_omId.getVector(systemEnvironment, l);
        for (SDMSObjectInstance sDMSObjectInstance : vector3) {
            Vector<Object> vector4 = new Vector<Object>();
            Long l2 = sDMSObjectInstance.getId(systemEnvironment);
            vector4.add(sDMSObjectInstance.getId(systemEnvironment));
            vector4.add(sDMSObjectInstance.getUniqueName(systemEnvironment));
            Long l3 = sDMSObjectInstance.getCreateTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector4.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector4.add(null);
            }
            l3 = sDMSObjectInstance.getModifyTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector4.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector4.add(null);
            }
            l3 = sDMSObjectInstance.getRemoveTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector4.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector4.add(null);
            }
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            vector4.add(null);
            this.addCounts(systemEnvironment, null, vector4);
            this.addCounts(systemEnvironment, null, vector4);
            vector4.add(sDMSObjectInstance.getPrivileges(systemEnvironment).toString());
            for (SDMSWatchTypeParameter sDMSWatchTypeParameter : vector2) {
                try {
                    SDMSInstanceValue sDMSInstanceValue = SDMSInstanceValueTable.idx_oiId_wtpId_getUnique(systemEnvironment, new SDMSKey(l2, sDMSWatchTypeParameter.getId(systemEnvironment)));
                    String string = sDMSInstanceValue.getValue(systemEnvironment);
                    if (string != null) {
                        vector4.add(string.substring(1));
                        continue;
                    }
                    vector4.add(null);
                }
                catch (NotFoundException notFoundException) {
                    vector4.add(null);
                }
            }
            sDMSOutputContainer.addData(systemEnvironment, vector4);
            this.addObjectEvents(systemEnvironment, sDMSObjectInstance, vector2, sDMSOutputContainer);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1, -8));
        return sDMSOutputContainer;
    }

    private void addCounts(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Vector vector) throws SDMSException {
        if (sDMSSubmittedEntity == null) {
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            vector.add(null);
            return;
        }
        vector.add(sDMSSubmittedEntity.getCntSubmitted(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntResourceWait(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntRunnable(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntStarting(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntStarted(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntRunning(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntToKill(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntKilled(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntCancelled(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntFinished(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntFinal(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntError(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntRestartable(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntUnreachable(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getCntWarn(systemEnvironment));
        vector.add(sDMSSubmittedEntity.getWarnCount(systemEnvironment));
    }

    private void addObjectEvents(SystemEnvironment systemEnvironment, SDMSObjectInstance sDMSObjectInstance, Vector vector, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        Long l = sDMSObjectInstance.getId(systemEnvironment);
        String string = sDMSObjectInstance.getUniqueName(systemEnvironment);
        Date date = new Date();
        Vector vector2 = SDMSObjectEventTable.idx_oiId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSSchedulingEntity sDMSSchedulingEntity;
            Long l2;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            SDMSTrigger sDMSTrigger;
            Vector<Object> vector3 = new Vector<Object>();
            SDMSObjectEvent sDMSObjectEvent = (SDMSObjectEvent)vector2.get(i);
            vector3.add(sDMSObjectEvent.getId(systemEnvironment));
            vector3.add(string);
            vector3.add(null);
            vector3.add(null);
            vector3.add(null);
            try {
                sDMSTrigger = SDMSTriggerTable.getObject(systemEnvironment, sDMSObjectEvent.getTrId(systemEnvironment), sDMSObjectEvent.getSeVersion(systemEnvironment));
                vector3.add(sDMSTrigger.getName(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                sDMSTrigger = null;
                vector3.add("???");
            }
            vector3.add(sDMSObjectEvent.getEventTypeAsString(systemEnvironment));
            Long l3 = sDMSObjectEvent.getSmeId(systemEnvironment);
            if (SDMSSubmittedEntityTable.table.exists(systemEnvironment, l3)) {
                vector3.add(l3);
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l3);
            } else {
                vector3.add("[" + l3 + "]");
                sDMSSubmittedEntity = null;
            }
            Long l4 = sDMSObjectEvent.getSubmitTs(systemEnvironment);
            date.setTime(l4);
            vector3.add(systemEnvironment.systemDateFormat.format(date));
            Long l5 = sDMSObjectEvent.getFinalTs(systemEnvironment);
            if (l5 == null) {
                vector3.add(null);
                l2 = sDMSSubmittedEntity.getFinalEsdId(systemEnvironment);
            } else {
                date.setTime(l5);
                vector3.add(systemEnvironment.systemDateFormat.format(date));
                l2 = sDMSObjectEvent.getFinalEsdId(systemEnvironment);
            }
            if (l2 != null) {
                try {
                    vector3.add(SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2, sDMSObjectEvent.getSeVersion(systemEnvironment)).getName(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {
                    vector3.add("???");
                }
            } else {
                vector3.add(null);
            }
            if (sDMSSubmittedEntity == null) {
                vector3.add("FINAL");
                vector3.add(Boolean.FALSE);
            } else {
                vector3.add(sDMSSubmittedEntity.getStateAsString(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment));
            }
            try {
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSObjectEvent.getSeId(systemEnvironment), sDMSObjectEvent.getSeVersion(systemEnvironment));
                vector3.add(sDMSSchedulingEntity.pathString(systemEnvironment));
                vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                sDMSSchedulingEntity = null;
                vector3.add("[" + sDMSObjectEvent.getSeId(systemEnvironment) + "]");
                vector3.add("JOB");
            }
            SDMSSubmittedEntity sDMSSubmittedEntity2 = null;
            Long l6 = sDMSObjectEvent.getMainSmeId(systemEnvironment);
            if (l6 == null) {
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
            } else {
                if (SDMSSubmittedEntityTable.table.exists(systemEnvironment, l6)) {
                    vector3.add(l6);
                    sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l6);
                } else {
                    vector3.add("[" + l6 + "]");
                    sDMSSubmittedEntity2 = null;
                }
                l5 = sDMSObjectEvent.getMainFinalTs(systemEnvironment);
                if (l5 == null) {
                    vector3.add(null);
                } else {
                    date.setTime(l5);
                    vector3.add(systemEnvironment.systemDateFormat.format(date));
                }
                l2 = sDMSSubmittedEntity2 == null ? sDMSObjectEvent.getMainFinalEsdId(systemEnvironment) : sDMSSubmittedEntity2.getFinalEsdId(systemEnvironment);
                if (l2 != null) {
                    try {
                        vector3.add(SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2, sDMSObjectEvent.getSeVersion(systemEnvironment)).getName(systemEnvironment));
                    }
                    catch (NotFoundException notFoundException) {
                        vector3.add("???");
                    }
                } else {
                    vector3.add(null);
                }
                if (sDMSSubmittedEntity2 == null) {
                    vector3.add("FINAL");
                    vector3.add(Boolean.FALSE);
                } else {
                    vector3.add(sDMSSubmittedEntity2.getStateAsString(systemEnvironment));
                    vector3.add(sDMSSubmittedEntity2.getJobIsRestartable(systemEnvironment));
                }
                try {
                    sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSObjectEvent.getMainSeId(systemEnvironment), sDMSObjectEvent.getSeVersion(systemEnvironment));
                    vector3.add(sDMSSchedulingEntity.pathString(systemEnvironment));
                    vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {
                    sDMSSchedulingEntity = null;
                    vector3.add("[" + sDMSObjectEvent.getMainSeId(systemEnvironment) + "]");
                    vector3.add("JOB");
                }
            }
            if (sDMSSubmittedEntity == null) {
                vector3.add(null);
            } else {
                vector3.add(sDMSSubmittedEntity.getMasterId(systemEnvironment));
            }
            this.addCounts(systemEnvironment, sDMSSubmittedEntity, vector3);
            this.addCounts(systemEnvironment, sDMSSubmittedEntity2, vector3);
            vector3.add(sDMSObjectEvent.getPrivileges(systemEnvironment).toString());
            for (int j = 0; j < vector.size(); ++j) {
                vector3.add(null);
            }
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
    }
}

