/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.util.DateTime;

public class FutureFilter
extends Filter {
    public static final String __version = "@(#) $Id: FutureFilter.java,v 2.1.6.1 2013/03/14 10:25:14 ronald Exp $";
    long numMillis = 0L;

    public FutureFilter(SystemEnvironment systemEnvironment, WithHash withHash) {
        Integer n = (Integer)withHash.get("MULT");
        Integer n2 = (Integer)withHash.get("INTERVAL");
        if (n == null || n2 == null) {
            this.numMillis = 0L;
            return;
        }
        this.numMillis = System.currentTimeMillis();
        switch (n2) {
            case 0: {
                this.numMillis += n.longValue() * 60L * 1000L;
                break;
            }
            case 1: {
                this.numMillis += n.longValue() * 60L * 60L * 1000L;
                break;
            }
            case 2: {
                this.numMillis += n.longValue() * 24L * 60L * 60L * 1000L;
                break;
            }
            case 3: {
                this.numMillis += n.longValue() * 7L * 24L * 60L * 60L * 1000L;
                break;
            }
            case 4: {
                this.numMillis += n.longValue() * 30L * 24L * 60L * 60L * 1000L;
                break;
            }
            case 5: {
                this.numMillis += n.longValue() * 365L * 24L * 60L * 60L * 1000L;
            }
        }
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            if (sDMSProxy instanceof SDMSSubmittedEntity) {
                return true;
            }
            Long l = null;
            if (sDMSProxy instanceof SDMSCalendar) {
                l = ((SDMSCalendar)sDMSProxy).getStarttime(systemEnvironment);
            } else if (sDMSProxy instanceof SDMSScheduledEvent) {
                if (!((SDMSScheduledEvent)sDMSProxy).getNextActivityIsTrigger(systemEnvironment).booleanValue()) {
                    return false;
                }
                l = ((SDMSScheduledEvent)sDMSProxy).getNextActivityTime(systemEnvironment);
            }
            DateTime dateTime = new DateTime(l);
            l = dateTime.toDate().getTime();
            if (l < this.numMillis) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FutureFilter)) {
            return false;
        }
        FutureFilter futureFilter = (FutureFilter)object;
        return futureFilter.numMillis == this.numMillis;
    }
}

