/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import java.util.HashSet;
import java.util.Vector;

public class MergedExitStateFilter
extends Filter {
    public static final String __version = "@(#) $Id: MergedExitStateFilter.java,v 2.0.20.1 2013/03/14 10:25:15 ronald Exp $";
    Vector exitStates;
    HashSet esdIds = null;

    public MergedExitStateFilter(SystemEnvironment systemEnvironment, Vector vector) {
        this.exitStates = vector;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
            long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
            if (this.esdIds == null) {
                this.esdIds = new HashSet();
                for (int i = 0; i < this.exitStates.size(); ++i) {
                    try {
                        this.esdIds.add(SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, this.exitStates.get(i), l).getId(systemEnvironment));
                        continue;
                    }
                    catch (SerializationException serializationException) {
                        throw serializationException;
                    }
                    catch (SDMSException sDMSException) {
                        // empty catch block
                    }
                }
            }
            if (this.esdIds.contains(sDMSSubmittedEntity.getFinalEsdId(systemEnvironment))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MergedExitStateFilter)) {
            return false;
        }
        MergedExitStateFilter mergedExitStateFilter = (MergedExitStateFilter)object;
        if (this.exitStates.size() != mergedExitStateFilter.exitStates.size()) {
            return false;
        }
        for (int i = 0; i < this.exitStates.size(); ++i) {
            if (mergedExitStateFilter.exitStates.contains(this.exitStates.get(i))) continue;
            return false;
        }
        return true;
    }
}

