/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSProxy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class NrNameFilter
extends Filter {
    String nrName;
    Pattern p;

    public NrNameFilter(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c;
            int n;
            char c2 = stringBuffer.charAt(i);
            if (c2 == '_') {
                stringBuffer2.append('.');
                continue;
            }
            if (c2 == '%') {
                stringBuffer2.append(".*");
                continue;
            }
            if (c2 == '\\' && (n = i + 1) < stringBuffer.length() && ((c = stringBuffer.charAt(n)) == '_' || c == '%')) {
                i = n;
                c2 = c;
            }
            stringBuffer2.append(c2);
        }
        this.nrName = new String(stringBuffer2);
        try {
            this.p = Pattern.compile(this.nrName);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402051228", "Error in regular expression"));
        }
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSNamedResource sDMSNamedResource = (SDMSNamedResource)sDMSProxy;
            Matcher matcher = this.p.matcher(sDMSNamedResource.pathString(systemEnvironment));
            return matcher.matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NrNameFilter)) {
            return false;
        }
        NrNameFilter nrNameFilter = (NrNameFilter)object;
        return this.nrName.equals(nrNameFilter.nrName);
    }
}

