/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SubmitUserFilter
extends Filter {
    Vector names;
    HashSet owners;
    SystemEnvironment env;

    public SubmitUserFilter(SystemEnvironment systemEnvironment, Vector vector) {
        this.names = vector;
        this.env = systemEnvironment;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSScheduledEvent sDMSScheduledEvent;
            SDMSScheduledEvent sDMSScheduledEvent2;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            if (this.owners == null) {
                this.fillOwners(systemEnvironment);
            }
            if (sDMSProxy instanceof SDMSSubmittedEntity ? this.owners.contains((sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy).getOwnerId(systemEnvironment)) : (sDMSProxy instanceof SDMSScheduledEvent ? this.owners.contains((sDMSScheduledEvent2 = (SDMSScheduledEvent)sDMSProxy).getOwnerId(systemEnvironment)) : sDMSProxy instanceof SDMSCalendar && this.owners.contains((sDMSScheduledEvent = SDMSScheduledEventTable.getObject(systemEnvironment, ((SDMSCalendar)sDMSProxy).getScevId(systemEnvironment))).getOwnerId(systemEnvironment)))) {
                return true;
            }
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException();
        }
        catch (SDMSException sDMSException) {
            // empty catch block
        }
        return false;
    }

    private void fillOwners(SystemEnvironment systemEnvironment) {
        if (this.owners == null) {
            this.owners = new HashSet();
            for (int i = 0; i < this.names.size(); ++i) {
                try {
                    Long l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)this.names.get(i))), SDMSConstants.lZERO)).getId(systemEnvironment);
                    this.owners.add(l);
                    continue;
                }
                catch (SerializationException serializationException) {
                    throw new RuntimeException();
                }
                catch (SDMSException sDMSException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SubmitUserFilter)) {
            return false;
        }
        SubmitUserFilter submitUserFilter = (SubmitUserFilter)object;
        if (this.owners == null) {
            this.fillOwners(this.env);
        }
        if (submitUserFilter.owners == null) {
            submitUserFilter.fillOwners(this.env);
        }
        if (this.owners.size() != submitUserFilter.owners.size()) {
            return false;
        }
        Iterator iterator = this.owners.iterator();
        while (iterator.hasNext()) {
            if (submitUserFilter.owners.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

