/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSNamedResourceGeneric
extends SDMSObject
implements Cloneable {
    public static final int STATIC = 1;
    public static final int SYSTEM = 2;
    public static final int POOL = 3;
    public static final int SYNCHRONIZING = 4;
    public static final int CATEGORY = 8;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_ownerId = 3;
    public static final int nr_parentId = 4;
    public static final int nr_usage = 5;
    public static final int nr_rspId = 6;
    public static final int nr_factor = 7;
    public static final int nr_creatorUId = 8;
    public static final int nr_createTs = 9;
    public static final int nr_changerUId = 10;
    public static final int nr_changeTs = 11;
    public static final int nr_inheritPrivs = 12;
    public static String tableName = "NAMED_RESOURCE";
    protected String name;
    protected Long ownerId;
    protected Long parentId;
    protected Integer usage;
    protected Long rspId;
    protected Float factor;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    protected Long inheritPrivs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSNamedResourceGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Long l3, Float f, Long l4, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        super(systemEnvironment, SDMSNamedResourceTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(NamedResource) Length of $1 exceeds maximum length $2", "name", "64"));
        }
        this.name = string;
        this.ownerId = l;
        this.parentId = l2;
        this.usage = n;
        this.rspId = l3;
        this.factor = f;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.inheritPrivs = l8;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
            }
            SDMSNamedResourceGeneric sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(NamedResource) Length of $1 exceeds maximum length $2", "name", "64"));
            }
            sDMSNamedResourceGeneric.name = string;
            sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 17L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
            }
            SDMSNamedResourceGeneric sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
            sDMSNamedResourceGeneric.ownerId = l;
            sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.parentId;
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.parentId)) {
            return;
        }
        if (l == null && this.parentId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
            }
            SDMSNamedResourceGeneric sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
            sDMSNamedResourceGeneric.parentId = l;
            sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 20L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getUsage(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.usage;
    }

    public String getUsageAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getUsage(systemEnvironment);
        switch (n) {
            case 1: {
                return "STATIC";
            }
            case 2: {
                return "SYSTEM";
            }
            case 4: {
                return "SYNCHRONIZING";
            }
            case 8: {
                return "CATEGORY";
            }
            case 3: {
                return "POOL";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown NamedResource.usage: $1", this.getUsage(systemEnvironment)));
    }

    public void setUsage(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.usage.equals(n)) {
            return;
        }
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
        }
        if (sDMSNamedResourceGeneric.versions.o_v == null || sDMSNamedResourceGeneric.versions.o_v.size() == 0 || sDMSNamedResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
        }
        sDMSNamedResourceGeneric.usage = n;
        sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedResourceGeneric != this) {
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 0L);
        }
    }

    public Long getRspId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rspId;
    }

    public void setRspId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.rspId)) {
            return;
        }
        if (l == null && this.rspId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
            }
            SDMSNamedResourceGeneric sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
            sDMSNamedResourceGeneric.rspId = l;
            sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Float getFactor(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.factor;
    }

    public void setFactor(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        if (f != null && f.equals(this.factor)) {
            return;
        }
        if (f == null && this.factor == null) {
            return;
        }
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
        }
        if (sDMSNamedResourceGeneric.versions.o_v == null || sDMSNamedResourceGeneric.versions.o_v.size() == 0 || sDMSNamedResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
        }
        sDMSNamedResourceGeneric.factor = f;
        sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedResourceGeneric != this) {
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
        }
        if (sDMSNamedResourceGeneric.versions.o_v == null || sDMSNamedResourceGeneric.versions.o_v.size() == 0 || sDMSNamedResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
        }
        sDMSNamedResourceGeneric.creatorUId = l;
        sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedResourceGeneric != this) {
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
        }
        if (sDMSNamedResourceGeneric.versions.o_v == null || sDMSNamedResourceGeneric.versions.o_v.size() == 0 || sDMSNamedResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
        }
        sDMSNamedResourceGeneric.createTs = l;
        sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedResourceGeneric != this) {
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = this;
        if (sDMSNamedResourceGeneric.versions.o_v == null || sDMSNamedResourceGeneric.versions.o_v.size() == 0 || sDMSNamedResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
        }
        sDMSNamedResourceGeneric.changerUId = l;
        sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedResourceGeneric != this) {
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = this;
        if (sDMSNamedResourceGeneric.versions.o_v == null || sDMSNamedResourceGeneric.versions.o_v.size() == 0 || sDMSNamedResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
        }
        sDMSNamedResourceGeneric.changeTs = l;
        sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSNamedResourceGeneric != this) {
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 0L);
        }
    }

    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.inheritPrivs;
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.inheritPrivs.equals(l)) {
            return;
        }
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(NamedResource) Change of system object not allowed"));
        }
        if (sDMSNamedResourceGeneric.versions.o_v == null || sDMSNamedResourceGeneric.versions.o_v.size() == 0 || sDMSNamedResourceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
        }
        sDMSNamedResourceGeneric.inheritPrivs = l;
        sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSNamedResourceGeneric != this) {
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric, 0L);
        }
    }

    public SDMSNamedResourceGeneric set_ParentIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSNamedResourceGeneric sDMSNamedResourceGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(NamedResource) Change of system object not allowed"));
            }
            sDMSNamedResourceGeneric = (SDMSNamedResourceGeneric)this.change(systemEnvironment);
            sDMSNamedResourceGeneric.parentId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(NamedResource) Length of $1 exceeds maximum length $2", "inheritPrivs", "64"));
            }
            sDMSNamedResourceGeneric.name = string;
            sDMSNamedResourceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSNamedResourceGeneric.changeTs = systemEnvironment.txTime();
            sDMSNamedResourceGeneric.versions.table.index(systemEnvironment, sDMSNamedResourceGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSNamedResourceGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSNamedResource(this);
    }

    protected SDMSNamedResourceGeneric(Long l, String string, Long l2, Long l3, Integer n, Long l4, Float f, Long l5, Long l6, Long l7, Long l8, Long l9, long l10, long l11) {
        this.id = l;
        this.name = string;
        this.ownerId = l2;
        this.parentId = l3;
        this.usage = n;
        this.rspId = l4;
        this.factor = f;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.inheritPrivs = l9;
        this.validFrom = l10;
        this.validTo = l11;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "NAMED_RESOURCE" + string3 + " (ID, " + string2 + "NAME" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "PARENT_ID" + string3 + ", " + string2 + "USAGE" + string3 + ", " + string2 + "RSP_ID" + string3 + ", " + string2 + "FACTOR" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", " + string2 + "INHERIT_PRIVS" + string3 + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                SDMSNamedResourceGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "NamedResource: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.ownerId);
            if (this.parentId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.parentId);
            }
            preparedStatement.setInt(5, this.usage);
            if (this.rspId == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.rspId);
            }
            if (this.factor == null) {
                preparedStatement.setNull(7, 6);
            } else {
                preparedStatement.setFloat(7, this.factor.floatValue());
            }
            preparedStatement.setLong(8, this.creatorUId);
            preparedStatement.setLong(9, this.createTs);
            preparedStatement.setLong(10, this.changerUId);
            preparedStatement.setLong(11, this.changeTs);
            preparedStatement.setLong(12, this.inheritPrivs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "NamedResource: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "NAMED_RESOURCE" + string3 + " WHERE ID = ?";
                SDMSNamedResourceGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "NamedResource: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "NamedResource: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "NAMED_RESOURCE" + string3 + " SET " + string2 + "NAME" + string3 + " = ? , " + string2 + "OWNER_ID" + string3 + " = ? , " + string2 + "PARENT_ID" + string3 + " = ? , " + string2 + "USAGE" + string3 + " = ? , " + string2 + "RSP_ID" + string3 + " = ? , " + string2 + "FACTOR" + string3 + " = ? , " + string2 + "CREATOR_U_ID" + string3 + " = ? , " + string2 + "CREATE_TS" + string3 + " = ? , " + string2 + "CHANGER_U_ID" + string3 + " = ? , " + string2 + "CHANGE_TS" + string3 + " = ? , " + string2 + "INHERIT_PRIVS" + string3 + " = ? WHERE ID = ?";
                SDMSNamedResourceGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "NamedResource: $1\n$2", string, sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            preparedStatement.setLong(2, this.ownerId);
            if (this.parentId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.parentId);
            }
            preparedStatement.setInt(4, this.usage);
            if (this.rspId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.rspId);
            }
            if (this.factor == null) {
                preparedStatement.setNull(6, 6);
            } else {
                preparedStatement.setFloat(6, this.factor.floatValue());
            }
            preparedStatement.setLong(7, this.creatorUId);
            preparedStatement.setLong(8, this.createTs);
            preparedStatement.setLong(9, this.changerUId);
            preparedStatement.setLong(10, this.changeTs);
            preparedStatement.setLong(11, this.inheritPrivs);
            preparedStatement.setLong(12, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "NamedResource: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
    }

    public static boolean checkUsage(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : NamedResource", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "parentId : " + this.parentId, 2);
        SDMSThread.doTrace(null, "usage : " + this.usage, 2);
        SDMSThread.doTrace(null, "rspId : " + this.rspId, 2);
        SDMSThread.doTrace(null, "factor : " + this.factor, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "inheritPrivs : " + this.inheritPrivs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name         : " + this.name + "\n" + string + "ownerId      : " + this.ownerId + "\n" + string + "parentId     : " + this.parentId + "\n" + string + "usage        : " + this.usage + "\n" + string + "rspId        : " + this.rspId + "\n" + string + "factor       : " + this.factor + "\n" + string + "creatorUId   : " + this.creatorUId + "\n" + string + "createTs     : " + this.createTs + "\n" + string + "changerUId   : " + this.changerUId + "\n" + string + "changeTs     : " + this.changeTs + "\n" + string + "inheritPrivs : " + this.inheritPrivs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

