/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.util.PathVector;
import java.util.HashMap;
import java.util.Vector;

public class SDMSNamedResourceProxyGeneric
extends SDMSProxy {
    public static final int STATIC = 1;
    public static final int SYSTEM = 2;
    public static final int POOL = 3;
    public static final int SYNCHRONIZING = 4;
    public static final int CATEGORY = 8;
    public static final long privilegeMask = 8858370335L;
    public static final int name_size = 64;

    protected SDMSNamedResourceProxyGeneric(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    protected static SDMSNamedResource getProxy(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) {
        int n = SDMSNamedResourceTable.table.tableIndex;
        SDMSProxy sDMSProxy = SDMSRepository.getProxy(n);
        if (sDMSProxy == null) {
            sDMSProxy = new SDMSNamedResource(sDMSObject);
        } else {
            sDMSProxy.initProxy(sDMSObject);
        }
        systemEnvironment.tx.addUsedProxy(n, sDMSProxy);
        return (SDMSNamedResource)sDMSProxy;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getName(systemEnvironment);
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setName(systemEnvironment, string);
    }

    public static int getNameMaxLength() {
        return 64;
    }

    @Override
    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getOwnerId(systemEnvironment);
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setOwnerId(systemEnvironment, l);
    }

    @Override
    public Long getParentId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getParentId(systemEnvironment);
    }

    public void setParentId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setParentId(systemEnvironment, l);
    }

    public Integer getUsage(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getUsage(systemEnvironment);
    }

    public String getUsageAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getUsageAsString(systemEnvironment);
    }

    public void setUsage(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setUsage(systemEnvironment, n);
    }

    public Long getRspId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getRspId(systemEnvironment);
    }

    public void setRspId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setRspId(systemEnvironment, l);
    }

    public Float getFactor(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getFactor(systemEnvironment);
    }

    public void setFactor(SystemEnvironment systemEnvironment, Float f) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setFactor(systemEnvironment, f);
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getCreatorUId(systemEnvironment);
    }

    private void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setCreatorUId(systemEnvironment, l);
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getCreateTs(systemEnvironment);
    }

    private void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setCreateTs(systemEnvironment, l);
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getChangerUId(systemEnvironment);
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setChangerUId(systemEnvironment, l);
    }

    protected SDMSNamedResource setChangerUIdNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSNamedResourceGeneric)this.object).setChangerUId(systemEnvironment, l);
        return (SDMSNamedResource)this;
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getChangeTs(systemEnvironment);
    }

    private void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setChangeTs(systemEnvironment, l);
    }

    protected SDMSNamedResource setChangeTsNoCheck(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        ((SDMSNamedResourceGeneric)this.object).setChangeTs(systemEnvironment, l);
        return (SDMSNamedResource)this;
    }

    @Override
    public Long getInheritPrivs(SystemEnvironment systemEnvironment) throws SDMSException {
        this.checkRead(systemEnvironment);
        return ((SDMSNamedResourceGeneric)this.object).getInheritPrivs(systemEnvironment);
    }

    public void setInheritPrivs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.checkWrite(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 0x200000100L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181241"));
        }
        ((SDMSNamedResourceGeneric)this.object).setInheritPrivs(systemEnvironment, l);
    }

    public SDMSNamedResource set_ParentIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        this.checkRead(systemEnvironment);
        if (!this.checkPrivileges(systemEnvironment, 256L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "01312181242"));
        }
        ((SDMSNamedResourceGeneric)this.object).set_ParentIdName(systemEnvironment, l, string);
        return (SDMSNamedResource)this;
    }

    @Override
    public SDMSKey getSortKey(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSKey sDMSKey = null;
        Long l = this.getId(systemEnvironment);
        if (systemEnvironment.tx.sortKeyMap == null) {
            systemEnvironment.tx.sortKeyMap = new HashMap();
        } else {
            sDMSKey = (SDMSKey)systemEnvironment.tx.sortKeyMap.get(l);
        }
        if (sDMSKey != null) {
            return sDMSKey;
        }
        boolean bl = false;
        sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)this.pathString(systemEnvironment)));
        systemEnvironment.tx.sortKeyMap.put(l, sDMSKey);
        return sDMSKey;
    }

    @Override
    public SDMSProxy getParent(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        if (l == null) {
            return null;
        }
        return SDMSNamedResourceTable.getObject(systemEnvironment, l);
    }

    public String pathString(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathVector(systemEnvironment).toString();
    }

    @Override
    public PathVector pathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        PathVector pathVector = new PathVector();
        pathVector.add(this.getName(systemEnvironment));
        while (l != null) {
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
            pathVector.add(0, sDMSNamedResource.getName(systemEnvironment));
            l = sDMSNamedResource.getParentId(systemEnvironment);
        }
        return pathVector;
    }

    public PathVector idPathVector(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getParentId(systemEnvironment);
        PathVector pathVector = new PathVector();
        pathVector.add(this.getId(systemEnvironment).toString());
        while (l != null) {
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
            pathVector.add(0, sDMSNamedResource.getId(systemEnvironment).toString());
            l = sDMSNamedResource.getParentId(systemEnvironment);
        }
        return pathVector;
    }

    @Override
    public Vector getContent(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = new Vector();
        Long l = this.getId(systemEnvironment);
        Vector vector2 = SDMSNamedResourceTable.idx_parentId.getVector(systemEnvironment, l);
        vector.addAll(vector2);
        return vector;
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSObjectCommentTable.dropComment(systemEnvironment, this.getId(systemEnvironment));
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            sDMSGrant.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    @Override
    public final boolean checkPrivileges(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        return (this.getPrivileges(systemEnvironment, l, true, null) & l) == l;
    }

    @Override
    public long getPrivilegeMask() {
        return 8858370335L;
    }

    @Override
    public final SDMSPrivilege getPrivileges(SystemEnvironment systemEnvironment) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370335L, false, null));
    }

    @Override
    public final SDMSPrivilege getPrivilegesForGroups(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return new SDMSPrivilege(systemEnvironment, this.getPrivileges(systemEnvironment, 8858370335L, false, vector));
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        Vector vector2 = vector == null ? new Vector() : vector;
        long l2 = 0L;
        if (systemEnvironment.cEnv.isUser()) {
            long l3;
            if (vector == null) {
                vector2.addAll(systemEnvironment.cEnv.gid());
            }
            if (vector2.contains(SDMSObject.adminGId)) {
                return l;
            }
            if (vector2.contains(this.getOwnerId(systemEnvironment))) {
                l2 = l & 0xFFFFFFFFFFFFFFFBL;
                if (l2 == l) {
                    return l2;
                }
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    try {
                        SDMSGrant sDMSGrant = SDMSGrantTable.idx_objectId_gId_getUnique(systemEnvironment, new SDMSKey(this.getId(systemEnvironment), (Long)vector2.get(i)));
                        l2 |= sDMSGrant.getPrivs(systemEnvironment).longValue();
                        l2 = this.addImplicitPrivs(l2) & l;
                        if (l2 != l) continue;
                        return l2;
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
            long l4 = this.getInheritPrivs(systemEnvironment);
            l4 = this.addImplicitPrivs(l4);
            if ((l & 4L) != 0L) {
                l4 |= 4L;
            }
            if ((l2 | (l3 = l & (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l4)) != l && bl) {
                return 0L;
            }
            Long l5 = this.getParentId(systemEnvironment);
            if (l5 != null && l3 != 0L) {
                SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l5);
                long l6 = (l3 & 4L) != 0L ? l3 & 0xFFFFFFFFFFFFFFFBL | 2L : l3;
                if (((l6 = sDMSNamedResource.getPrivileges(systemEnvironment, l6, bl, vector)) & 2L) != 0L) {
                    l6 |= 4L;
                }
                l2 |= l6 & l4;
            }
        }
        return l2;
    }

    @Override
    public SDMSMessage accessViolationMessage(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSMessage sDMSMessage = new SDMSMessage(systemEnvironment, string, "Insufficient privileges accessing Named Resource $1", this.pathString(systemEnvironment));
        return sDMSMessage;
    }

    @Override
    protected void touch(SystemEnvironment systemEnvironment) throws SDMSException {
        this.setChangerUIdNoCheck(systemEnvironment, systemEnvironment.cEnv.uid());
        this.setChangeTsNoCheck(systemEnvironment, systemEnvironment.txTime());
    }

    public void print() {
        ((SDMSNamedResourceGeneric)this.object).print();
    }
}

