/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceReqStates;
import de.independit.scheduler.server.repository.SDMSResourceReqStatesTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirementProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMapping;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingTable;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import java.util.Vector;

public class SDMSResourceRequirement
extends SDMSResourceRequirementProxyGeneric {
    public static final String __version = "@(#) $Id: SDMSResourceRequirement.java,v 2.2.14.1 2013/03/14 10:25:23 ronald Exp $";

    protected SDMSResourceRequirement(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceReqStates sDMSResourceReqStates = (SDMSResourceReqStates)vector.get(i);
            sDMSResourceReqStates.delete(systemEnvironment);
        }
        super.delete(systemEnvironment);
    }

    public void check(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getNrId(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
        int n = sDMSNamedResource.getUsage(systemEnvironment);
        int n2 = this.getLockmode(systemEnvironment);
        String string = this.getCondition(systemEnvironment);
        Long l2 = this.getRsmpId(systemEnvironment);
        if (n == 1) {
            if (this.getAmount(systemEnvironment) != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304102050", "Amount option invalid for static Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
            if (this.getKeepMode(systemEnvironment) != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304102045", "Keep option invalid for static Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
        }
        if (n != 1 && string != null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03710301113", "Condition option invalid for non static Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
        }
        if (n != 4) {
            if (n2 != 255) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304101727", "Lockmode invalid for non synchronizing Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
            if (l2 != null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304110943", "Resource Mapping invalid for non synchronizing Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
            if (this.getIsSticky(systemEnvironment).booleanValue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304101735", "Sticky invalid for non synchronizing Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
            if (this.getExpiredAmount(systemEnvironment) != null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304101737", "Expired invalid for non synchronizing Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
            Vector vector = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, this.getId(systemEnvironment));
            if (vector.size() != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304110942", "Requesting States is invalid for non synchronizing Resources ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
            return;
        }
        Long l3 = sDMSNamedResource.getRspId(systemEnvironment);
        Vector vector = SDMSResourceReqStatesTable.idx_rrId.getVector(systemEnvironment, this.getId(systemEnvironment));
        if (l3 == null) {
            if (vector.size() > 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03709071145", "Requesting States is invalid for Resources ($1) without Resource State Profile", sDMSNamedResource.pathString(systemEnvironment)));
            }
        } else {
            Long l4 = SDMSResourceStateProfileTable.getObject(systemEnvironment, l3).getInitialRsdId(systemEnvironment);
            for (int i = 0; i < vector.size(); ++i) {
                Long l5 = ((SDMSResourceReqStates)vector.get(i)).getRsdId(systemEnvironment);
                if (SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l5, l3)) || l5.equals(l4)) continue;
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03709071155", "Requested State $1 not valid for Resource $2", l5, sDMSNamedResource.pathString(systemEnvironment)));
            }
        }
        if (l2 != null) {
            if (n2 != 0) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304101619", "For setting a resource state, an exclusive lock is required ($1)", sDMSNamedResource.pathString(systemEnvironment)));
            }
            if (l3 == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03304110944", "Resource $1 doesn't have a state profile", sDMSNamedResource.pathString(systemEnvironment)));
            }
            this.checkMapping(systemEnvironment, l3, l2, sDMSNamedResource);
        }
    }

    @Override
    public void setRsmpId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null) {
            Long l2 = this.getNrId(systemEnvironment);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2);
            Long l3 = sDMSNamedResource.getRspId(systemEnvironment);
            if (l3 == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03709071205", "It is not allowed to specify a mapping for a resource ($1) without a resource state profile", sDMSNamedResource.pathString(systemEnvironment)));
            }
            this.checkMapping(systemEnvironment, l3, l, sDMSNamedResource);
        }
        super.setRsmpId(systemEnvironment, l);
    }

    private void checkMapping(SystemEnvironment systemEnvironment, Long l, Long l2, SDMSNamedResource sDMSNamedResource) throws SDMSException {
        Long l3 = SDMSResourceRequirement.checkMapping(systemEnvironment, l, l2);
        if (l3 == null) {
            return;
        }
        throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03709071205", "Resource State Profile $1 of $2 doesn't contain State $3", SDMSResourceStateProfileTable.getObject(systemEnvironment, l).getName(systemEnvironment), sDMSNamedResource.pathString(systemEnvironment), SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l3).getName(systemEnvironment)));
    }

    public static Long checkMapping(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        Vector vector = SDMSResourceStateMappingTable.idx_rsmpId.getVector(systemEnvironment, l2);
        Long l3 = SDMSResourceStateProfileTable.getObject(systemEnvironment, l).getInitialRsdId(systemEnvironment);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceStateMapping sDMSResourceStateMapping = (SDMSResourceStateMapping)vector.get(i);
            Long l4 = sDMSResourceStateMapping.getToRsdId(systemEnvironment);
            Long l5 = sDMSResourceStateMapping.getFromRsdId(systemEnvironment);
            if (l5 != null && !SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l5, l)) && !l5.equals(l3)) {
                return l5;
            }
            if (SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l4, l))) continue;
            return l4;
        }
        return null;
    }
}

