/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.repository.SDMSChangeListElement;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSROTxList;
import de.independit.scheduler.server.repository.SDMSRepository;
import de.independit.scheduler.server.repository.SDMSVersions;
import de.independit.scheduler.server.repository.TxCounter;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class SDMSTransaction {
    public static final String __version = "@(#) $Id: SDMSTransaction.java,v 2.12.2.1 2013/03/14 10:25:26 ronald Exp $";
    SDMSThread thread = null;
    public static final int READONLY = 1;
    public static final int READWRITE = 2;
    protected static final int UNDEFINED = -1;
    private static TxCounter nextId = null;
    private static final Object commitLock = new Object();
    public int subTxId = 0;
    Stack subTxCheckPoints;
    public long subTxCheckPoint = 0L;
    public HashMap txData = new HashMap();
    public Integer smeCtr = SDMSConstants.iZERO;
    private Stack ctrStack = new Stack();
    private Stack clStack = new Stack();
    public Stack lockStack = new Stack();
    public HashMap privCache = new HashMap();
    public Vector resourceRequestList = null;
    public HashMap sortKeyMap = null;
    public long txId;
    public int mode;
    public long versionId;
    public final long startTime;
    public long endTime = 0L;
    private HashSet touchList;
    public HashSet subTxLocks;
    public long[] commitingTx;
    public HashMap rscCache = null;
    public HashMap envJSMap = null;
    private SDMSProxy[] usedProxies = null;
    public boolean traceSubTx = false;
    private static int dmpctr = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDMSTransaction(SystemEnvironment systemEnvironment, int n, Long l) throws SDMSException {
        if (nextId == null) {
            Object object = commitLock;
            synchronized (object) {
                if (nextId == null) {
                    nextId = new TxCounter(systemEnvironment);
                }
            }
        }
        this.mode = n;
        this.txId = nextId.next(systemEnvironment, n, false);
        this.touchList = null;
        this.subTxLocks = null;
        if (n == 1) {
            this.versionId = l == null ? this.txId : l;
            systemEnvironment.roTxList.add(systemEnvironment, this.versionId);
            if (SystemEnvironment.maxWriter > 1) {
                this.commitingTx = nextId.getCommitingTx();
            }
        } else {
            this.versionId = -1L;
        }
        this.startTime = System.currentTimeMillis();
        this.subTxCheckPoints = new Stack();
        this.thread = systemEnvironment.thread;
        this.usedProxies = new SDMSProxy[SDMSRepository.getTableCount()];
    }

    public void addUsedProxy(int n, SDMSProxy sDMSProxy) {
        SDMSProxy sDMSProxy2 = this.usedProxies[n];
        this.usedProxies[n] = sDMSProxy;
        sDMSProxy.next = sDMSProxy2;
    }

    public static long drawVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return nextId.next(systemEnvironment, 2, false);
    }

    public static long getRoVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return nextId.next(systemEnvironment, 1, false);
    }

    public long txId() {
        return this.txId;
    }

    public int mode() {
        return this.mode;
    }

    public long versionId(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.versionId == -1L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181540", "VersionId not defined"));
        }
        return this.versionId;
    }

    public void commit(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        if (this.versionId == -1L) {
            this.versionId = nextId.next(systemEnvironment, 2, true);
        }
        try {
            this.commitOrRollback(systemEnvironment, true);
        }
        catch (Throwable throwable) {
            nextId.releaseVersion(systemEnvironment);
            throw throwable;
        }
    }

    public void rollback(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        this.commitOrRollback(systemEnvironment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextVersionId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.versionId == -1L || this.mode == 2) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03212191505", "VersionId cannot be set within a writing transaction"));
        }
        SDMSROTxList sDMSROTxList = systemEnvironment.roTxList;
        synchronized (sDMSROTxList) {
            systemEnvironment.roTxList.add(systemEnvironment, l);
            systemEnvironment.roTxList.remove(systemEnvironment, this.versionId);
            this.versionId = l;
        }
    }

    public void commitOrRollback(SystemEnvironment systemEnvironment, boolean bl) throws SQLException, SDMSException {
        if (this.traceSubTx) {
            SDMSThread.doTrace(null, (bl ? "Commiting" : "Rolling back") + " Transaction [" + this.txId + "/" + this.subTxId + "]", -1);
        }
        if (bl) {
            if (this.subTxId != 0) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "02110301918", "Unclosed subtransaction in transaction commit or rollback"));
            }
            if (systemEnvironment.inExecution) {
                SDMSThread.doTrace(null, "\n*********************************************************************\n*********************************************************************\n***                                                               ***\n*** W A T C H   O U T   ! ! ! ! !                                 ***\n***                                                               ***\n*** We are committing within a go() method !                      ***\n*** This might compromise our database                            ***\n***                                                               ***\n*********************************************************************\n*********************************************************************\n", -1);
            }
        } else {
            while (this.subTxId > 0) {
                this.rollbackSubTransaction(systemEnvironment);
            }
        }
        if (this.mode == 1 || this.touchList == null) {
            if (this.mode != 1) {
                nextId.releaseVersion(systemEnvironment);
            } else {
                systemEnvironment.roTxList.remove(systemEnvironment, this.versionId);
            }
            if (SystemEnvironment.maxWriter > 1 && this.mode == 2) {
                LockingSystem.release(systemEnvironment);
            }
            SDMSRepository.releaseProxies(this.usedProxies);
            this.endTime = System.currentTimeMillis();
            return;
        }
        if (bl && this.smeCtr > 0) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03406061057", "Error in SME Counter, tried to submit $1 unregistered entities", this.smeCtr));
        }
        int n = 0;
        if (bl) {
            boolean bl2 = true;
            while (bl2) {
                bl2 = false;
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, commitLock, n);
                }
                try {
                    for (SDMSChangeListElement sDMSChangeListElement : this.touchList) {
                        sDMSChangeListElement.versions.flush(systemEnvironment, sDMSChangeListElement.isNew);
                    }
                }
                catch (SDMSSQLException sDMSSQLException) {
                    if (n == 1) {
                        throw sDMSSQLException;
                    }
                    bl2 = true;
                    n = 1;
                    systemEnvironment.dbConnection.rollback();
                    if (SystemEnvironment.maxWriter <= 1) continue;
                    LockingSystem.release(systemEnvironment, commitLock);
                    continue;
                }
                SystemEnvironment.ticketThread.renewTicket(systemEnvironment);
                systemEnvironment.dbConnection.commit();
                if (SystemEnvironment.maxWriter <= 1) continue;
                LockingSystem.release(systemEnvironment, commitLock);
            }
        } else {
            systemEnvironment.dbConnection.rollback();
        }
        for (SDMSChangeListElement sDMSChangeListElement : this.touchList) {
            sDMSChangeListElement.versions.commitOrRollback(systemEnvironment, this.versionId, sDMSChangeListElement.isNew, bl);
        }
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.release(systemEnvironment);
        }
        nextId.releaseVersion(systemEnvironment);
        SDMSRepository.releaseProxies(this.usedProxies);
        this.endTime = System.currentTimeMillis();
    }

    public void beginSubTransaction(SystemEnvironment systemEnvironment) {
        ++this.subTxId;
        this.ctrStack.push(this.smeCtr);
        this.clStack.push(this.touchList);
        this.lockStack.push(this.subTxLocks);
        this.subTxLocks = new HashSet();
        this.touchList = new HashSet();
        if (this.traceSubTx) {
            SDMSThread.doTrace(null, "Starting subtransaction", -1);
        }
        this.subTxCheckPoints.push(this.subTxCheckPoint);
        this.subTxCheckPoint = systemEnvironment.newLockCp();
    }

    public void commitSubTransaction(SystemEnvironment systemEnvironment) throws SDMSException {
        this.commitOrRollbackSubTransaction(systemEnvironment, true);
        this.subTxCheckPoint = (Long)this.subTxCheckPoints.pop();
        this.ctrStack.pop();
        HashSet hashSet = this.subTxLocks;
        this.subTxLocks = (HashSet)this.lockStack.pop();
        if (this.subTxLocks != null) {
            this.subTxLocks.addAll(hashSet);
        }
        HashSet hashSet2 = this.touchList;
        this.touchList = (HashSet)this.clStack.pop();
        if (hashSet2 != null) {
            if (this.touchList == null) {
                this.touchList = new HashSet();
            }
            this.touchList.addAll(hashSet2);
        }
    }

    public void rollbackSubTransaction(SystemEnvironment systemEnvironment) throws SDMSException {
        this.commitOrRollbackSubTransaction(systemEnvironment, false);
        this.subTxCheckPoint = (Long)this.subTxCheckPoints.pop();
        this.subTxLocks = (HashSet)this.lockStack.pop();
        this.smeCtr = (Integer)this.ctrStack.pop();
        this.touchList = (HashSet)this.clStack.pop();
    }

    private void commitOrRollbackSubTransaction(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        if (this.traceSubTx) {
            SDMSThread.doTrace(null, "Terminating subtransaction" + (bl ? "(commit)" : "(rollback)"), -1);
        }
        --this.subTxId;
        if (this.subTxId < 0) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "02110261755", "sub transaction underflow"));
        }
        if (this.mode == 1 || this.touchList == null) {
            if (this.mode == 2 && !bl) {
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.releaseSubTxLocks(systemEnvironment, this.subTxCheckPoint);
                }
            }
            return;
        }
        for (SDMSChangeListElement sDMSChangeListElement : this.touchList) {
            int n;
            if (sDMSChangeListElement.versions.o_v == null || (n = sDMSChangeListElement.versions.o_v.size()) == 0) continue;
            SDMSObject sDMSObject = (SDMSObject)sDMSChangeListElement.versions.o_v.getLast();
            if (sDMSObject.subTxId != this.subTxId + 1) continue;
            if (bl) {
                sDMSObject.subTxId = this.subTxId;
                if (n <= 1) continue;
                sDMSObject = (SDMSObject)sDMSChangeListElement.versions.o_v.get(n - 2);
                if (sDMSObject.subTxId != this.subTxId) continue;
                sDMSChangeListElement.versions.o_v.remove(n - 2);
                sDMSObject.versions.table.unIndex(systemEnvironment, sDMSObject);
                continue;
            }
            sDMSObject.versions.table.unIndex(systemEnvironment, sDMSObject);
            sDMSObject.isCurrent = false;
            sDMSChangeListElement.versions.o_v.remove(n - 1);
            if (n > 1) {
                sDMSObject = (SDMSObject)sDMSChangeListElement.versions.o_v.getLast();
                sDMSObject.isCurrent = true;
                continue;
            }
            if (!sDMSChangeListElement.isNew && (sDMSObject = (SDMSObject)sDMSChangeListElement.versions.versions.lastElement()) != null && sDMSObject.validTo == Long.MAX_VALUE) {
                sDMSObject.isCurrent = true;
            }
            sDMSObject.versions.tx = null;
        }
        if (!bl) {
            if (SystemEnvironment.maxWriter > 1) {
                LockingSystem.releaseSubTxLocks(systemEnvironment, this.subTxCheckPoint);
            }
        }
    }

    protected void addToTouchSet(SystemEnvironment systemEnvironment, SDMSVersions sDMSVersions, boolean bl) throws SDMSException {
        SDMSChangeListElement sDMSChangeListElement = new SDMSChangeListElement(systemEnvironment, sDMSVersions, bl);
        if (this.touchList == null) {
            this.touchList = new HashSet();
        }
        this.touchList.add(sDMSChangeListElement);
    }

    public String toString() {
        String string = new String("-- Start Transaction Data --\n  subTxId   : " + this.subTxId + "\n  txId      : " + this.txId + "\n  mode      : " + (this.mode == 1 ? "READONLY" : "READWRITE") + "\n  versionId : " + (this.versionId == -1L ? "UNDEFINED" : "" + this.versionId) + "\n  Changes   : " + (this.touchList == null ? "0" : Integer.valueOf(this.touchList.size())) + "\n  StartTime : " + this.startTime + "\n  EndTime   : " + this.endTime + "\n  Thread    : " + this.thread.getName() + "\n-- End Transaction Data --\n");
        return string;
    }

    public void dumpTouchList(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        ++dmpctr;
        if (this.touchList == null) {
            System.out.println("[" + dmpctr + "] START: " + string);
            System.out.println("[" + dmpctr + "] END: " + string);
            return;
        }
        System.out.println("[" + dmpctr + "] START: " + string);
        System.out.println(this.toString());
        for (SDMSChangeListElement sDMSChangeListElement : this.touchList) {
            System.out.println(sDMSChangeListElement.toString());
        }
        System.out.println("[" + dmpctr + "] END: " + string);
    }
}

