/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameter;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterGeneric;
import de.independit.scheduler.server.repository.SDMSWatchTypeParameterTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSWatchTypeParameterTableGeneric
extends SDMSTable {
    public static final String tableName = "WATCH_TYPE_PARAMETER";
    public static SDMSWatchTypeParameterTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "DEFAULTVALUE", "WT_ID", "IS_SUBMIT_PAR", "TYPE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_wtId;
    public static SDMSIndex idx_wtId_name;

    public SDMSWatchTypeParameterTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "WatchTypeParameter"));
        }
        table = (SDMSWatchTypeParameterTable)this;
        table = (SDMSWatchTypeParameterTable)this;
        this.isVersioned = false;
        idx_wtId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "wtId");
        idx_wtId_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "wtId_name");
    }

    public SDMSWatchTypeParameter create(SystemEnvironment systemEnvironment, String string, String string2, Long l, Boolean bl, Integer n) throws SDMSException {
        SDMSWatchTypeParameter sDMSWatchTypeParameter;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "WatchTypeParameter"));
        }
        this.validate(systemEnvironment, string, string2, l, bl, n, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSWatchTypeParameterGeneric sDMSWatchTypeParameterGeneric = new SDMSWatchTypeParameterGeneric(systemEnvironment, string, string2, l, bl, n, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSWatchTypeParameterGeneric.versions, true);
            table.put(systemEnvironment, sDMSWatchTypeParameterGeneric.id, sDMSWatchTypeParameterGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSWatchTypeParameter = (SDMSWatchTypeParameter)sDMSWatchTypeParameterGeneric.toProxy(systemEnvironment);
            sDMSWatchTypeParameter.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSWatchTypeParameter sDMSWatchTypeParameter2 = (SDMSWatchTypeParameter)sDMSWatchTypeParameterGeneric.toProxy(systemEnvironment);
            sDMSWatchTypeParameter2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSWatchTypeParameter)) {
            throw new AccessViolationException(sDMSWatchTypeParameter.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSWatchTypeParameter.touchMaster(systemEnvironment);
        return sDMSWatchTypeParameter;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSWatchTypeParameter sDMSWatchTypeParameter) throws SDMSException {
        return sDMSWatchTypeParameter.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, String string2, Long l, Boolean bl, Integer n, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
        if (!SDMSWatchTypeParameterGeneric.checkType(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "WatchTypeParameter: $1 $2", "type", n));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Boolean bl;
        Long l7;
        String string;
        String string2;
        Long l8;
        try {
            l8 = resultSet.getLong(1);
            string2 = resultSet.getString(2);
            string = resultSet.getString(3);
            if (resultSet.wasNull()) {
                string = null;
            }
            l7 = resultSet.getLong(4);
            bl = resultSet.getInt(5) != 0;
            n = resultSet.getInt(6);
            l6 = resultSet.getLong(7);
            l5 = resultSet.getLong(8);
            l4 = resultSet.getLong(9);
            l3 = resultSet.getLong(10);
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "WatchTypeParameter: $1 $2", sQLException.getErrorCode(), sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSWatchTypeParameterGeneric(l8, string2, string, l7, bl, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "DEFAULTVALUE" + string2 + ", " + string + "WT_ID" + string2 + ", " + string + "IS_SUBMIT_PAR" + string2 + ", " + string + "TYPE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            try {
                if (this.loadObject(systemEnvironment, resultSet)) {
                    ++n2;
                }
                ++n;
            }
            catch (Exception exception) {
                SDMSThread.doTrace(null, "Exception caught while loading table " + this.tableName() + ", ID = " + Long.valueOf(resultSet.getLong(1)), -1);
                throw exception;
            }
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_wtId.check(((SDMSWatchTypeParameterGeneric)sDMSObject).wtId, sDMSObject);
        string = string + "idx_wtId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSWatchTypeParameterGeneric)sDMSObject).wtId);
        sDMSKey.add((Comparable)((Object)((SDMSWatchTypeParameterGeneric)sDMSObject).name));
        bl = idx_wtId_name.check(sDMSKey, sDMSObject);
        string = string + "idx_wtId_name: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_wtId.put(systemEnvironment, ((SDMSWatchTypeParameterGeneric)sDMSObject).wtId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSWatchTypeParameterGeneric)sDMSObject).wtId);
        sDMSKey.add((Comparable)((Object)((SDMSWatchTypeParameterGeneric)sDMSObject).name));
        idx_wtId_name.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_wtId.remove(systemEnvironment, ((SDMSWatchTypeParameterGeneric)sDMSObject).wtId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSWatchTypeParameterGeneric)sDMSObject).wtId);
        sDMSKey.add((Comparable)((Object)((SDMSWatchTypeParameterGeneric)sDMSObject).name));
        idx_wtId_name.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSWatchTypeParameter getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSWatchTypeParameter)table.get(systemEnvironment, l);
    }

    public static SDMSWatchTypeParameter getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSWatchTypeParameter)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSWatchTypeParameter getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSWatchTypeParameter)table.get(systemEnvironment, l, l2);
    }

    public static SDMSWatchTypeParameter idx_wtId_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSWatchTypeParameter)idx_wtId_name.getUnique(systemEnvironment, object);
    }

    public static SDMSWatchTypeParameter idx_wtId_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSWatchTypeParameter)idx_wtId_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSWatchTypeParameter idx_wtId_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSWatchTypeParameter)idx_wtId_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

