/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.tools;

import de.independit.scheduler.SDMSApp.App;
import de.independit.scheduler.SDMSApp.RetryException;
import de.independit.scheduler.server.output.SDMSOutput;

class rerun
extends App {
    public static final String __version = "@(#) $Id: rerun.java,v 1.5.6.1 2013/03/14 10:25:31 ronald Exp $";
    public static final String JID = "JID";
    public static final String SUSPEND = "SUSPEND";
    public static final String DELAY = "DELAY";
    public static final String UNIT = "UNIT";
    public static final String AT = "AT";

    rerun() {
    }

    @Override
    public void addOptions() {
        this.addOption("j", "jid", null, JID, null, "jobid", true, "Id of job to rerun");
        this.addOption("S", "suspend", null, SUSPEND, null, null, false, "Submit job [not] suspended");
        this.addOption("D", "delay", null, DELAY, null, "delay", false, "Delay after Job will be resumed (only valid with suspend option)");
        this.addOption("U", "unit", null, UNIT, null, "unit", false, "Delay Unit (MINUTE, HOUR or DAY) defaults to MINUTE");
        this.addOption("A", "at", null, AT, null, "at", false, "Timestamp (YYYY-MM-DDTHH:MM) when job should be resumed (only valid with suspend option)");
    }

    @Override
    public String getName() {
        return "rerun";
    }

    @Override
    public boolean userOnly() {
        return true;
    }

    @Override
    public boolean canRetry() {
        return true;
    }

    @Override
    public boolean validateOptions() {
        if (!this.options.isSet(SUSPEND) || !this.options.getOption(SUSPEND).getBValue()) {
            if (this.options.isSet(DELAY)) {
                System.err.println("delay option only valid with suspend option");
                return false;
            }
            if (this.options.isSet(AT)) {
                System.err.println("at option only valid with suspend option");
                return false;
            }
        } else {
            if (this.options.isSet(DELAY) && this.options.isSet(AT)) {
                System.err.println("combination of delay and at option not allowed");
                return false;
            }
            if (this.options.isSet(DELAY) && !this.options.isSet(UNIT)) {
                System.err.println("delay option requires unit option");
                return false;
            }
            if (this.options.isSet(UNIT) && !this.options.getValue(UNIT).equals("MINUTE") && !this.options.getValue(UNIT).equals("HOUR") && !this.options.getValue(UNIT).equals("DAY")) {
                System.err.println("unit must be MINUTE, HOUR or DAY");
                return false;
            }
        }
        if (this.options.isSet(UNIT) && !this.options.isSet(DELAY)) {
            System.err.println("unit option only valid with delay option");
            return false;
        }
        return true;
    }

    @Override
    public int go() throws RetryException {
        String string = "ALTER JOB " + this.options.getValue(JID) + " WITH RERUN";
        if (this.options.isSet(SUSPEND) && this.options.getOption(SUSPEND).getBValue()) {
            string = string + ",\n    SUSPEND";
        }
        if (this.options.isSet(DELAY) || this.options.isSet(AT)) {
            string = string + ",\n    RESUME";
        }
        if (this.options.isSet(DELAY)) {
            string = string + " IN " + this.options.getValue(DELAY) + " " + this.options.getValue(UNIT);
        }
        if (this.options.isSet(AT)) {
            string = string + " AT '" + this.options.getValue(AT) + "'";
        }
        SDMSOutput sDMSOutput = this.execute(string);
        if (sDMSOutput.error != null) {
            if (sDMSOutput.error.code.equals("03205191052") && this.executions > 1) {
                return 0;
            }
            this.printError(sDMSOutput.error);
            return 1;
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        System.exit(new rerun().run(stringArray));
    }
}

