-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE ENTITY_VARIABLE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint          NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , VALUE                          varchar(256)        NULL
    , IS_LOCAL                       integer         NOT NULL
    , EV_LINK                        bigint              NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_ENTITY_VARIABLE
ON ENTITY_VARIABLE(ID);
CREATE VIEW SCI_ENTITY_VARIABLE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM ENTITY_VARIABLE;
CREATE TABLE ARC_ENTITY_VARIABLE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint           NULL
    , NAME                           varchar(64)      NULL
    , VALUE                          varchar(256)     NULL
    , IS_LOCAL                       integer          NULL
    , EV_LINK                        bigint           NULL
    , IS_LONG                        integer          NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
