-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_EQUIV (
    ID                             bigint NOT NULL
    , U_ID                           bigint          NOT NULL
    , ALT_U_TYPE                     integer         NOT NULL
    , ALT_U_ID                       bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_USER_EQUIV
ON USER_EQUIV(ID);
CREATE VIEW SCI_USER_EQUIV AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , DECODE (ALT_U_TYPE, 0, 'USER', 1, 'SERVER') AS ALT_U_TYPE
    , ALT_U_ID                       AS ALT_U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM USER_EQUIV;
