-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE FOLDER (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , ENV_ID                         bigint              NULL
    , PARENT_ID                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_FOLDER
ON FOLDER(ID);
CREATE VIEW SCI_C_FOLDER (ID,NAME,OWNER_ID,ENV_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM FOLDER
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_FOLDER (ID,NAME,OWNER_ID,ENV_ID,PARENT_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , VALID_FROM
    , VALID_TO
  FROM FOLDER;
