-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_EVENT (
    ID                             bigint NOT NULL
    , TR_ID                          bigint              NULL
    , OI_ID                          bigint          NOT NULL
    , EVENT_TYPE                     int8            NOT NULL
    , SME_ID                         bigint          NOT NULL
    , SE_ID                          bigint          NOT NULL
    , SUBMIT_TS                      bigint              NULL
    , FINAL_TS                       bigint              NULL
    , FINAL_ESD_ID                   bigint              NULL
    , MAIN_SME_ID                    bigint              NULL
    , MAIN_SE_ID                     bigint              NULL
    , MAIN_FINAL_TS                  bigint              NULL
    , MAIN_FINAL_ESD_ID              bigint              NULL
    , SE_VERSION                     bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_EVENT
ON OBJECT_EVENT(ID);
CREATE VIEW SCI_OBJECT_EVENT (ID,TR_ID,OI_ID,EVENT_TYPE,SME_ID,SE_ID,SUBMIT_TS,FINAL_TS,FINAL_ESD_ID,MAIN_SME_ID,MAIN_SE_ID,MAIN_FINAL_TS,MAIN_FINAL_ESD_ID,SE_VERSION,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , TR_ID                          AS TR_ID
    , OI_ID                          AS OI_ID
    , DECODE (EVENT_TYPE, 1, 'CREATE', 2, 'CHANGE', 3, 'DELETE') AS EVENT_TYPE
    , SME_ID                         AS SME_ID
    , SE_ID                          AS SE_ID
    , dbinfo ('utc_to_datetime', round(mod(SUBMIT_TS, 1125899906842624)/1000)) AS SUBMIT_TS
    , dbinfo ('utc_to_datetime', round(mod(FINAL_TS, 1125899906842624)/1000)) AS FINAL_TS
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , MAIN_SME_ID                    AS MAIN_SME_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , dbinfo ('utc_to_datetime', round(mod(MAIN_FINAL_TS, 1125899906842624)/1000)) AS MAIN_FINAL_TS
    , MAIN_FINAL_ESD_ID              AS MAIN_FINAL_ESD_ID
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_EVENT;
