-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE PARAMETER_DEFINITION (
    ID                             bigint NOT NULL
    , SE_ID                          bigint          NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , TYPE                           int8            NOT NULL
    , AGG_FUNCTION                   int8            NOT NULL
    , DEFAULTVALUE                   lvarchar(256)       NULL
    , IS_LOCAL                       integer         NOT NULL
    , LINK_PD_ID                     bigint              NULL
    , EXPORT_NAME                    lvarchar(64)        NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_PARAMETER_DEFINITION
ON PARAMETER_DEFINITION(ID);
CREATE VIEW SCI_C_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM PARAMETER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_PARAMETER_DEFINITION (ID,SE_ID,NAME,TYPE,AGG_FUNCTION,DEFAULTVALUE,IS_LOCAL,LINK_PD_ID,EXPORT_NAME,IS_LONG,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , EXPORT_NAME                    AS EXPORT_NAME
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM PARAMETER_DEFINITION;
