-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_ALLOCATION (
    ID                             bigint NOT NULL
    , R_ID                           bigint          NOT NULL
    , SME_ID                         bigint          NOT NULL
    , NR_ID                          bigint          NOT NULL
    , AMOUNT                         int8                NULL
    , ORIG_AMOUNT                    int8                NULL
    , KEEP_MODE                      int8            NOT NULL
    , IS_STICKY                      integer         NOT NULL
    , STICKY_NAME                    lvarchar(64)        NULL
    , STICKY_PARENT                  bigint              NULL
    , ALLOCATION_TYPE                int8            NOT NULL
    , RSMP_ID                        bigint              NULL
    , LOCKMODE                       int8                NULL
    , REFCOUNT                       int8            NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_ALLOCATION
ON RESOURCE_ALLOCATION(ID);
CREATE VIEW SCI_RESOURCE_ALLOCATION (ID,R_ID,SME_ID,NR_ID,AMOUNT,ORIG_AMOUNT,KEEP_MODE,IS_STICKY,STICKY_NAME,STICKY_PARENT,ALLOCATION_TYPE,RSMP_ID,LOCKMODE,REFCOUNT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , R_ID                           AS R_ID
    , SME_ID                         AS SME_ID
    , NR_ID                          AS NR_ID
    , AMOUNT                         AS AMOUNT
    , ORIG_AMOUNT                    AS ORIG_AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , DECODE (ALLOCATION_TYPE, 1, 'REQUEST', 6, 'MASTER_REQUEST', 2, 'RESERVATION', 3, 'MASTER_RESERVATION', 4, 'ALLOCATION', 5, 'IGNORE') AS ALLOCATION_TYPE
    , RSMP_ID                        AS RSMP_ID
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , REFCOUNT                       AS REFCOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM RESOURCE_ALLOCATION;
