-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCOPE_CONFIG (
    ID                             bigint NOT NULL
    , KEY                            lvarchar(64)    NOT NULL
    , VALUE                          lvarchar(256)   NOT NULL
    , S_ID                           bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCOPE_CONFIG
ON SCOPE_CONFIG(ID);
CREATE VIEW SCI_SCOPE_CONFIG (ID,KEY,VALUE,S_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , S_ID                           AS S_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM SCOPE_CONFIG;
