-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE TRIGGER_STATE (
    ID                             bigint NOT NULL
    , TRIGGER_ID                     bigint          NOT NULL
    , FROM_STATE_ID                  bigint              NULL
    , TO_STATE_ID                    bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_TRIGGER_STATE
ON TRIGGER_STATE(ID);
CREATE VIEW SCI_C_TRIGGER_STATE (ID,TRIGGER_ID,FROM_STATE_ID,TO_STATE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM TRIGGER_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_STATE (ID,TRIGGER_ID,FROM_STATE_ID,TO_STATE_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_STATE;
