-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE HIERARCHY_INSTANCE (
    ID                             decimal(20) NOT NULL
    , PARENT_ID                      decimal(20)     NOT NULL
    , CHILD_ID                       decimal(20)     NOT NULL
    , SH_ID                          decimal(20)     NOT NULL
    , NICE                           integer         NOT NULL
    , CHILD_ESD_ID                   decimal(20)     WITH NULL
    , CHILD_ES_PREFERENCE            integer         WITH NULL
    , SE_VERSION                     decimal(20)     NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
);\g
CREATE UNIQUE INDEX PK_HIERARCHY_INSTANCE
ON HIERARCHY_INSTANCE(ID) WITH STRUCTURE = BTREE;\g
CREATE VIEW SCI_HIERARCHY_INSTANCE AS
SELECT 
    ID 
    , PARENT_ID                      AS PARENT_ID
    , CHILD_ID                       AS CHILD_ID
    , SH_ID                          AS SH_ID
    , NICE                           AS NICE
    , CHILD_ESD_ID                   AS CHILD_ESD_ID
    , CHILD_ES_PREFERENCE            AS CHILD_ES_PREFERENCE
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CREATE_TS- decimal(CREATE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CHANGE_TS- decimal(CHANGE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CHANGE_TS
  FROM HIERARCHY_INSTANCE;\g
CREATE TABLE ARC_HIERARCHY_INSTANCE (
    ID                             decimal(20) NOT NULL
    , PARENT_ID                      decimal(20)      NULL
    , CHILD_ID                       decimal(20)      NULL
    , SH_ID                          decimal(20)      NULL
    , NICE                           integer          NULL
    , CHILD_ESD_ID                   decimal(20)      NULL
    , CHILD_ES_PREFERENCE            integer          NULL
    , SE_VERSION                     decimal(20)      NULL
    , CREATOR_U_ID                   decimal(20)      NULL
    , CREATE_TS                      decimal(20)      NULL
    , CHANGER_U_ID                   decimal(20)      NULL
    , CHANGE_TS                      decimal(20)      NULL
);\g
