-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_PARAMETER (
    ID                             decimal(20) NOT NULL
    , U_ID                           decimal(20)     NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , VALUE                          varchar(256)    WITH NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
);\g
CREATE UNIQUE INDEX PK_USER_PARAMETER
ON USER_PARAMETER(ID) WITH STRUCTURE = BTREE;\g
CREATE VIEW SCI_USER_PARAMETER AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , CASE IS_LONG WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CREATE_TS- decimal(CREATE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , '01-JAN-1970 00:00:00 GMT' + date(char(decimal((CHANGE_TS- decimal(CHANGE_TS/1125899906842624, 18, 0)*1125899906842624)/1000, 18, 0)) + ' secs') AS CHANGE_TS
  FROM USER_PARAMETER;\g
