-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [INTERVAL_SELECTION] (
    [ID]                           decimal (38) NOT NULL
    , [INT_ID]                       decimal (38)    NOT NULL
    , [VALUE]                        integer             NULL
    , [PERIOD_FROM]                  decimal (38)        NULL
    , [PERIOD_TO]                    decimal (38)        NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_INTERVAL_SELECTION
ON [INTERVAL_SELECTION]([ID]);
go
CREATE VIEW SCI_INTERVAL_SELECTION AS
SELECT 
    ID 
    , [INT_ID]                       AS [INT_ID]
    , [VALUE]                        AS [VALUE]
    , [PERIOD_FROM]                  AS [PERIOD_FROM]
    , [PERIOD_TO]                    AS [PERIOD_TO]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
  FROM [INTERVAL_SELECTION];
go
