CREATE VIEW SCI_SME_QUARTER (
        JAHR,
        QUARTAL,
        ANZAHL,
        EXPECTED_ANZAHL,
        AVG_ANZAHL_PRO_TAG)
AS
SELECT
	JAHR,
	floor((monat-1)/3)+1,
	SUM(ANZAHL),
	ROUND(CASE date_format(current_date(),'%Y') * 100 + (floor((date_format(current_date(),'%m')-1)/3)+1)
		WHEN JAHR*100+(floor((MONAT-1)/3)+1)
		THEN
			SUM(ANZAHL) * 
			/* anzahl Tage im aktuellen quartal */
			DATEDIFF(
				str_to_date(concat(JAHR,'-',floor((monat-1)/3) * 3 + 1,'-1'),'%Y-%m-%d') + INTERVAL 3 MONTH,
				str_to_date(concat(JAHR,'-',floor((monat-1)/3) * 3 + 1,'-1'),'%Y-%m-%d')
			) /
			/* vergangene Tage im aktuellen quartal */
			DATEDIFF(
				current_date(),
				str_to_date(concat(JAHR,'-',floor((monat-1)/3) * 3 + 1,'-1'),'%Y-%m-%d')
			)
		ELSE
			SUM(ANZAHL)
		END, 2),
	ROUND(CASE date_format(current_date(),'%Y') * 100 + (floor((date_format(current_date(),'%m')-1)/3)+1)
		WHEN JAHR*100+(floor((MONAT-1)/3)+1)
		THEN
			SUM(ANZAHL) /
			/* vergangene Tage im aktuellen quartal */
			DATEDIFF(
				current_date(),
				str_to_date(concat(JAHR,'-',floor((monat-1)/3) * 3 + 1,'-1'),'%Y-%m-%d')
			)
		ELSE
			SUM(ANZAHL) /
			/* anzahl Tage im quartal */
			DATEDIFF(
				str_to_date(concat(JAHR,'-',floor((monat-1)/3) * 3 + 1,'-1'),'%Y-%m-%d') + INTERVAL 3 MONTH,
				str_to_date(concat(JAHR,'-',floor((monat-1)/3) * 3 + 1,'-1'),'%Y-%m-%d')
			)
		END, 2)
FROM SCI_SME_COUNTER
GROUP BY JAHR, floor((monat-1)/3)+1;