-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `TRIGGER_QUEUE` (
    `ID`                           decimal(20) NOT NULL
    , `SME_ID`                       decimal(20)     NOT NULL
    , `TR_ID`                        decimal(20)     NOT NULL
    , `NEXT_TRIGGER_TIME`            decimal(20)     NOT NULL
    , `TIMES_CHECKED`                integer         NOT NULL
    , `TIMES_TRIGGERED`              integer         NOT NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
) ENGINE = INNODB;
CREATE UNIQUE INDEX PK_TRIGGER_QUEUE
ON `TRIGGER_QUEUE`(`ID`);
CREATE VIEW SCI_TRIGGER_QUEUE AS
SELECT 
    ID 
    , `SME_ID`                       AS `SME_ID`
    , `TR_ID`                        AS `TR_ID`
    , `NEXT_TRIGGER_TIME`            AS `NEXT_TRIGGER_TIME`
    , `TIMES_CHECKED`                AS `TIMES_CHECKED`
    , `TIMES_TRIGGERED`              AS `TIMES_TRIGGERED`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `TRIGGER_QUEUE`;
