-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "DEPENDENCY_DEFINITION" (
    "ID"                           NUMBER (38) NOT NULL
    , "SE_DEPENDENT_ID"              NUMBER (38)          NOT NULL
    , "SE_REQUIRED_ID"               NUMBER (38)          NOT NULL
    , "NAME"                         VARCHAR2 (64 CHAR)       NULL
    , "UNRESOLVED_HANDLING"          NUMBER (38)          NOT NULL
    , "DMODE"                        NUMBER (38)          NOT NULL
    , "STATE_SELECTION"              NUMBER (38)          NOT NULL
    , "CONDITION"                    VARCHAR2 (1024 CHAR)     NULL
    , "RESOLVE_MODE"                 NUMBER (38)          NOT NULL
    , "EXPIRED_AMOUNT"               NUMBER (38)              NULL
    , "EXPIRED_BASE"                 NUMBER (38)              NULL
    , "SELECT_CONDITION"             VARCHAR2 (1024 CHAR)     NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , "SE_DEPENDENT_ID"              AS "SE_DEPENDENT_ID"
    , "SE_REQUIRED_ID"               AS "SE_REQUIRED_ID"
    , "NAME"                         AS "NAME"
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS "UNRESOLVED_HANDLING"
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS "DMODE"
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS "STATE_SELECTION"
    , "CONDITION"                    AS "CONDITION"
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS "RESOLVE_MODE"
    , "EXPIRED_AMOUNT"               AS "EXPIRED_AMOUNT"
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS "EXPIRED_BASE"
    , "SELECT_CONDITION"             AS "SELECT_CONDITION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "DEPENDENCY_DEFINITION"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , "SE_DEPENDENT_ID"              AS "SE_DEPENDENT_ID"
    , "SE_REQUIRED_ID"               AS "SE_REQUIRED_ID"
    , "NAME"                         AS "NAME"
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS "UNRESOLVED_HANDLING"
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS "DMODE"
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS "STATE_SELECTION"
    , "CONDITION"                    AS "CONDITION"
    , DECODE (RESOLVE_MODE, 0, 'INTERNAL', 1, 'EXTERNAL', 2, 'BOTH') AS "RESOLVE_MODE"
    , "EXPIRED_AMOUNT"               AS "EXPIRED_AMOUNT"
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS "EXPIRED_BASE"
    , "SELECT_CONDITION"             AS "SELECT_CONDITION"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , VALID_FROM
    , VALID_TO
  FROM "DEPENDENCY_DEFINITION";
