-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "PARAMETER_DEFINITION" (
    "ID"                           NUMBER (38) NOT NULL
    , "SE_ID"                        NUMBER (38)          NOT NULL
    , "NAME"                         VARCHAR2 (64 CHAR)   NOT NULL
    , "TYPE"                         NUMBER (38)          NOT NULL
    , "AGG_FUNCTION"                 NUMBER (38)          NOT NULL
    , "DEFAULTVALUE"                 VARCHAR2 (256 CHAR)      NULL
    , "IS_LOCAL"                     NUMBER (1)           NOT NULL
    , "LINK_PD_ID"                   NUMBER (38)              NULL
    , "EXPORT_NAME"                  VARCHAR2 (64 CHAR)       NULL
    , "IS_LONG"                      NUMBER (1)           NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
    , "VALID_FROM"                 NUMBER (38) NOT NULL
    , "VALID_TO"                   NUMBER (38) NOT NULL
    , PRIMARY KEY (ID, VALID_TO)
);
CREATE OR REPLACE VIEW SCI_C_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , "SE_ID"                        AS "SE_ID"
    , "NAME"                         AS "NAME"
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS "TYPE"
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS "AGG_FUNCTION"
    , "DEFAULTVALUE"                 AS "DEFAULTVALUE"
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS "IS_LOCAL"
    , "LINK_PD_ID"                   AS "LINK_PD_ID"
    , "EXPORT_NAME"                  AS "EXPORT_NAME"
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS "IS_LONG"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "PARAMETER_DEFINITION"
 WHERE VALID_TO = 9223372036854775807;
CREATE OR REPLACE VIEW SCI_V_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , "SE_ID"                        AS "SE_ID"
    , "NAME"                         AS "NAME"
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 71, 'IMPORT_UNRESOLVED', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS "TYPE"
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS "AGG_FUNCTION"
    , "DEFAULTVALUE"                 AS "DEFAULTVALUE"
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS "IS_LOCAL"
    , "LINK_PD_ID"                   AS "LINK_PD_ID"
    , "EXPORT_NAME"                  AS "EXPORT_NAME"
    , DECODE (IS_LONG, 1, 'TRUE', 0, 'FALSE') AS "IS_LONG"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
    , VALID_FROM
    , VALID_TO
  FROM "PARAMETER_DEFINITION";
