-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE "RUNNABLE_QUEUE" (
    "ID"                           NUMBER (38) PRIMARY KEY
    , "SME_ID"                       NUMBER (38)          NOT NULL
    , "SCOPE_ID"                     NUMBER (38)              NULL
    , "STATE"                        NUMBER (38)          NOT NULL
    , "CREATOR_U_ID"                 NUMBER (38)          NOT NULL
    , "CREATE_TS"                    NUMBER (38)          NOT NULL
    , "CHANGER_U_ID"                 NUMBER (38)          NOT NULL
    , "CHANGE_TS"                    NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_RUNNABLE_QUEUE AS
SELECT 
    ID 
    , "SME_ID"                       AS "SME_ID"
    , "SCOPE_ID"                     AS "SCOPE_ID"
    , DECODE (STATE, 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING') AS "STATE"
    , "CREATOR_U_ID"                 AS "CREATOR_U_ID"
    , pkg_time.gmt2local("CREATE_TS") AS "CREATE_TS"
    , "CHANGER_U_ID"                 AS "CHANGER_U_ID"
    , pkg_time.gmt2local("CHANGE_TS") AS "CHANGE_TS"
  FROM "RUNNABLE_QUEUE";
