-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE USER_PARAMETER (
    ID                             decimal(20) NOT NULL
    , U_ID                           decimal(20)     NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , VALUE                          varchar(256)        NULL
    , IS_LONG                        integer         NOT NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
);
CREATE UNIQUE INDEX PK_USER_PARAMETER
ON USER_PARAMETER(ID);
CREATE VIEW SCI_USER_PARAMETER AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , CASE IS_LONG WHEN 1 THEN 'TRUE' WHEN 0 THEN 'FALSE' END AS IS_LONG
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CREATE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CHANGE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CHANGE_TS
  FROM USER_PARAMETER;
