/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.MasterEntry;
import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSExtentsTable;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSROTxList;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStatsTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.repository.SDMSTransaction;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class DBCleanupThread
extends SDMSThread {
    public SystemEnvironment sysEnv = null;
    private static final int NR = 99999999;
    private static final int TX_RETRY_TIME = 10000;
    private static final int IDLE_SLEEP_TIME = 900000;
    private static final int MASTERCHUNK = 10000;
    private static final String KILL_JOB = "KILL_JOB";
    private static final String AUDIT_TRAIL = "AUDIT_TRAIL";
    private static final String ENTITY_VARIABLE = "ENTITY_VARIABLE";
    private static final String EXTENTS = "EXTENTS";
    private static final String DEPENDENCY_INSTANCE = "DEPENDENCY_INSTANCE";
    private static final String HIERARCHY_INSTANCE = "HIERARCHY_INSTANCE";
    private static final String SUBMITTED_ENTITY_STATS = "SUBMITTED_ENTITY_STATS";
    private Vector<MasterEntry> masterList = new Vector();
    private PreparedStatement deleteMaster = null;
    private PreparedStatement deleteKillJob = null;
    private PreparedStatement deleteAuditTrail = null;
    private PreparedStatement deleteEntityVariable = null;
    private PreparedStatement deleteExtents = null;
    private PreparedStatement deleteDependencyInstance = null;
    private PreparedStatement deleteHierarchyInstance = null;
    private PreparedStatement deleteSubmittedEntityStats = null;
    private PreparedStatement archiveMaster = null;
    private PreparedStatement archiveKillJob = null;
    private PreparedStatement archiveAuditTrail = null;
    private PreparedStatement archiveEntityVariable = null;
    private PreparedStatement archiveExtents = null;
    private PreparedStatement archiveDependencyInstance = null;
    private PreparedStatement archiveHierarchyInstance = null;
    private PreparedStatement archiveSubmittedEntityStats = null;
    private PreparedStatement loadSmeForMaster = null;
    private PreparedStatement loadMasters = null;

    public DBCleanupThread(Server server) {
        super("DBCleanupThread");
    }

    @Override
    public int id() {
        return -99999999;
    }

    private Vector checkColumns(SDMSTable sDMSTable, Vector vector) throws SDMSException {
        Vector<String> vector2 = new Vector<String>(Arrays.asList(sDMSTable.columnNames()));
        if (vector.size() == 0) {
            return vector2;
        }
        HashSet hashSet = new HashSet();
        vector.add("ID");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashSet.contains(e)) {
                iterator.remove();
                continue;
            }
            if (!vector2.contains(e)) {
                throw new FatalException(new SDMSMessage(this.sysEnv, "02411181314", "Invalid Archive Column " + e + " for Table " + sDMSTable.tableName()));
            }
            hashSet.add(e);
        }
        return vector;
    }

    private PreparedStatement prepareArchive(SDMSTable sDMSTable, Vector vector, String string) throws SDMSException, SQLException {
        if (vector == null) {
            return null;
        }
        vector = this.checkColumns(sDMSTable, vector);
        String string2 = "";
        String string3 = "";
        String string4 = SystemEnvironment.SQUOTE;
        String string5 = SystemEnvironment.EQUOTE;
        for (int i = 0; i < vector.size(); ++i) {
            string2 = string2 + string3 + string4 + vector.get(i) + string5;
            string3 = ",";
        }
        String string6 = "INSERT INTO ARC_" + sDMSTable.tableName() + " (" + string2 + ") SELECT " + string2 + " FROM " + sDMSTable.tableName() + " WHERE " + string + " = ?";
        return this.sysEnv.dbConnection.prepareStatement(string6);
    }

    private void prepareConnection() throws SDMSException {
        while (true) {
            try {
                this.sysEnv.dbConnection = Server.connectToDB(this.sysEnv);
            }
            catch (SDMSException sDMSException) {
                this.sysEnv = null;
                DBCleanupThread.doTrace(null, "Error: couldn't get database connection", -1);
                throw sDMSException;
            }
            try {
                this.sysEnv.dbConnection.setTransactionIsolation(1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                String string = "SELECT ID, FINAL_TS FROM SUBMITTED_ENTITY WHERE ID = MASTER_ID AND STATE IN (10, 12) AND FINAL_TS  < ? ORDER BY FINAL_TS";
                this.loadMasters = this.sysEnv.dbConnection.prepareStatement(string);
                this.loadSmeForMaster = this.sysEnv.dbConnection.prepareStatement("SELECT ID FROM SUBMITTED_ENTITY WHERE MASTER_ID = ?");
                this.deleteMaster = this.sysEnv.dbConnection.prepareStatement("DELETE FROM SUBMITTED_ENTITY WHERE MASTER_ID = ?");
                this.deleteKillJob = this.sysEnv.dbConnection.prepareStatement("DELETE FROM KILL_JOB WHERE SME_ID = ?");
                this.deleteAuditTrail = this.sysEnv.dbConnection.prepareStatement("DELETE FROM AUDIT_TRAIL WHERE OBJECT_ID = ?");
                this.deleteEntityVariable = this.sysEnv.dbConnection.prepareStatement("DELETE FROM ENTITY_VARIABLE WHERE SME_ID = ?");
                this.deleteExtents = this.sysEnv.dbConnection.prepareStatement("DELETE FROM EXTENTS WHERE SME_ID = ?");
                this.deleteDependencyInstance = this.sysEnv.dbConnection.prepareStatement("DELETE FROM DEPENDENCY_INSTANCE WHERE DEPENDENT_ID = ?");
                this.deleteHierarchyInstance = this.sysEnv.dbConnection.prepareStatement("DELETE FROM HIERARCHY_INSTANCE WHERE CHILD_ID = ?");
                this.deleteSubmittedEntityStats = this.sysEnv.dbConnection.prepareStatement("DELETE FROM SUBMITTED_ENTITY_STATS WHERE SME_ID = ?");
                if (!SystemEnvironment.archive) break;
                this.archiveMaster = this.prepareArchive(SDMSSubmittedEntityTable.table, SystemEnvironment.smeColumns, "MASTER_ID");
                this.archiveKillJob = this.prepareArchive(SDMSKillJobTable.table, SystemEnvironment.kjColumns, "SME_ID");
                this.archiveAuditTrail = this.prepareArchive(SDMSAuditTrailTable.table, SystemEnvironment.atColumns, "OBJECT_ID");
                this.archiveEntityVariable = this.prepareArchive(SDMSEntityVariableTable.table, SystemEnvironment.evColumns, "SME_ID");
                this.archiveExtents = this.prepareArchive(SDMSExtentsTable.table, SystemEnvironment.exColumns, "SME_ID");
                this.archiveDependencyInstance = this.prepareArchive(SDMSDependencyInstanceTable.table, SystemEnvironment.diColumns, "DEPENDENT_ID");
                this.archiveHierarchyInstance = this.prepareArchive(SDMSHierarchyInstanceTable.table, SystemEnvironment.hiColumns, "CHILD_ID");
                this.archiveSubmittedEntityStats = this.prepareArchive(SDMSSubmittedEntityStatsTable.table, SystemEnvironment.smesColumns, "SME_ID");
            }
            catch (SQLRecoverableException sQLRecoverableException) {
                try {
                    DBCleanupThread.doTrace(null, "Recoverable Error Preparing Delete/Archive Statements" + sQLRecoverableException.getMessage(), 1);
                    try {
                        this.sysEnv.dbConnection.close();
                    }
                    catch (SQLException sQLException) {
                        DBCleanupThread.doTrace(null, "Error while closing connection: " + sQLException.getMessage(), -1);
                    }
                    DBCleanupThread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (SQLException sQLException) {
                this.sysEnv = null;
                DBCleanupThread.doTrace(null, "Error Preparing Delete/Archive Statements" + sQLException.getMessage(), -1);
                throw new FatalException(new SDMSMessage(this.sysEnv, "03411171211", "Error Preparing Delete/Archive Statements"));
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDBCleanupThread(SystemEnvironment systemEnvironment) throws SDMSException {
        try {
            this.sysEnv = (SystemEnvironment)systemEnvironment.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FatalException(new SDMSMessage(this.sysEnv, "03411170950", "Cannot Clone SystemEnvironment"));
        }
        this.prepareConnection();
        this.sysEnv.tx = new SDMSTransaction(this.sysEnv, 1, null);
        SDMSROTxList sDMSROTxList = this.sysEnv.roTxList;
        synchronized (sDMSROTxList) {
            this.sysEnv.roTxList.remove(this.sysEnv, this.sysEnv.tx.versionId);
        }
        this.sysEnv.thread = this;
    }

    private void loadMasters() throws SDMSException {
        try {
            if (this.sysEnv.dbConnection.isClosed()) {
                this.prepareConnection();
            }
        }
        catch (SQLException sQLException) {
            try {
                this.sysEnv.dbConnection.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            this.prepareConnection();
        }
        while (true) {
            try {
                this.loadMasters.clearParameters();
                long l = System.currentTimeMillis() - SystemEnvironment.dbPreserveTime + 86400000L;
                this.loadMasters.setLong(1, l);
                this.loadMasters.setMaxRows(10000);
                ResultSet resultSet = this.loadMasters.executeQuery();
                this.masterList.clear();
                while (resultSet.next()) {
                    MasterEntry masterEntry = new MasterEntry();
                    masterEntry.finalTs = resultSet.getLong(2);
                    masterEntry.id = resultSet.getLong(1);
                    this.masterList.add(masterEntry);
                }
                this.sysEnv.dbConnection.commit();
            }
            catch (SQLRecoverableException sQLRecoverableException) {
                DBCleanupThread.doTrace(null, "Recoverable Error Preparing Delete/Archive Statements" + sQLRecoverableException.getMessage(), 1);
                try {
                    this.sysEnv.dbConnection.close();
                    try {
                        DBCleanupThread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (SQLException sQLException) {
                    DBCleanupThread.doTrace(null, "Error while closing connection: " + sQLException.getMessage(), -1);
                }
                this.prepareConnection();
                continue;
            }
            catch (SQLException sQLException) {
                DBCleanupThread.doTrace(null, "Error loading masters:" + sQLException.getMessage(), -1);
                try {
                    this.sysEnv.dbConnection.close();
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
                this.masterList.clear();
            }
            break;
        }
        DBCleanupThread.doTrace(null, "Found " + this.masterList.size() + " masters for archive/cleanup", 2);
    }

    private Vector<Long> loadMaster(long l) throws SDMSException {
        Vector<Long> vector = new Vector<Long>();
        try {
            this.loadSmeForMaster.clearParameters();
            this.loadSmeForMaster.setLong(1, l);
            ResultSet resultSet = this.loadSmeForMaster.executeQuery();
            while (resultSet.next()) {
                vector.add(resultSet.getLong(1));
            }
        }
        catch (SQLException sQLException) {
            try {
                this.sysEnv.dbConnection.rollback();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            DBCleanupThread.doTrace(null, "Error loading master:" + sQLException.getMessage(), -1);
            return null;
        }
        return vector;
    }

    private void deleteForSme(PreparedStatement preparedStatement, long l, String string) throws SDMSException, SQLException {
        preparedStatement.clearParameters();
        preparedStatement.setLong(1, l);
        preparedStatement.executeUpdate();
    }

    private void archiveForSme(PreparedStatement preparedStatement, long l, String string) throws SDMSException, SQLException {
        if (preparedStatement == null) {
            return;
        }
        preparedStatement.clearParameters();
        preparedStatement.setLong(1, l);
        preparedStatement.executeUpdate();
    }

    private void processSme(long l) throws SDMSException, SQLException {
        this.archiveForSme(this.archiveKillJob, l, KILL_JOB);
        this.deleteForSme(this.deleteKillJob, l, KILL_JOB);
        this.archiveForSme(this.archiveAuditTrail, l, AUDIT_TRAIL);
        this.deleteForSme(this.deleteAuditTrail, l, AUDIT_TRAIL);
        this.archiveForSme(this.archiveEntityVariable, l, ENTITY_VARIABLE);
        this.deleteForSme(this.deleteEntityVariable, l, ENTITY_VARIABLE);
        this.archiveForSme(this.archiveExtents, l, EXTENTS);
        this.deleteForSme(this.deleteExtents, l, EXTENTS);
        this.archiveForSme(this.archiveDependencyInstance, l, DEPENDENCY_INSTANCE);
        this.deleteForSme(this.deleteDependencyInstance, l, DEPENDENCY_INSTANCE);
        this.archiveForSme(this.archiveHierarchyInstance, l, HIERARCHY_INSTANCE);
        this.deleteForSme(this.deleteHierarchyInstance, l, HIERARCHY_INSTANCE);
        this.archiveForSme(this.archiveSubmittedEntityStats, l, SUBMITTED_ENTITY_STATS);
        this.deleteForSme(this.deleteSubmittedEntityStats, l, SUBMITTED_ENTITY_STATS);
    }

    private boolean processMaster(long l) throws SDMSException {
        Vector<Long> vector = this.loadMaster(l);
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            try {
                this.processSme(vector.get(i));
                continue;
            }
            catch (SQLException sQLException) {
                DBCleanupThread.doTrace(null, "Error processing Smes for Master" + sQLException.getMessage(), -1);
                try {
                    this.sysEnv.dbConnection.rollback();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                return false;
            }
        }
        try {
            if (this.archiveMaster != null) {
                this.archiveMaster.clearParameters();
                this.archiveMaster.setLong(1, l);
                this.archiveMaster.executeUpdate();
            }
            this.deleteMaster.clearParameters();
            this.deleteMaster.setLong(1, l);
            this.deleteMaster.executeUpdate();
            this.sysEnv.dbConnection.commit();
        }
        catch (SQLException sQLException) {
            DBCleanupThread.doTrace(null, "Error Deleting Children of Master" + l + ": " + sQLException.getMessage(), -1);
            try {
                this.sysEnv.dbConnection.rollback();
            }
            catch (SQLException sQLException3) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private boolean processMasters() throws SDMSException, InterruptedException {
        boolean bl = false;
        int n = 0;
        while (this.masterList.size() > 0 && this.run) {
            MasterEntry masterEntry = this.masterList.get(0);
            DBCleanupThread.doTrace(null, "DBCleanupThread: checking existence of master id " + masterEntry.id, 3);
            if (SDMSSubmittedEntityTable.table.exists(this.sysEnv, masterEntry.id)) {
                DBCleanupThread.doTrace(null, "DBCleanupThread: master id " + masterEntry.id + " still in memory", 3);
                this.masterList.remove(0);
                continue;
            }
            DBCleanupThread.doTrace(null, "DBCleanupThread: master id " + masterEntry.id + " not in memory", 3);
            try {
                if (this.sysEnv.dbConnection.isClosed()) {
                    this.prepareConnection();
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.sysEnv.dbConnection.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                this.prepareConnection();
            }
            long l = System.currentTimeMillis() - SystemEnvironment.dbPreserveTime;
            if (masterEntry.finalTs <= l) {
                if (this.processMaster(masterEntry.id)) {
                    DBCleanupThread.doTrace(null, "removing master " + masterEntry.id, 3);
                    this.masterList.remove(0);
                    bl = true;
                    ++n;
                    continue;
                }
                DBCleanupThread.doTrace(null, "processMasters failed, sleeping TX_RETRY_TIME before retry ...", 2);
                DBCleanupThread.sleep(10000L);
                continue;
            }
            DBCleanupThread.doTrace(null, "First master to young detected, start sleeping for " + (masterEntry.finalTs - l) / 1000L + " seconds", 3);
            DBCleanupThread.sleep(masterEntry.finalTs - l);
        }
        DBCleanupThread.doTrace(null, "Number of masters removed : " + n, 2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void SDMSrun() {
        SDMSROTxList sDMSROTxList;
        if (SystemEnvironment.dbPreserveTime == 0L) {
            return;
        }
        if (this.sysEnv == null) {
            DBCleanupThread.doTrace(null, "Uninitialized Thread. Call to initDBCleanupThread() missing?", -2);
        }
        try {
            DBCleanupThread.sleep(900000L);
            while (this.run) {
                SDMSTransaction cfr_ignored_0 = this.sysEnv.tx;
                this.sysEnv.tx.versionId = SDMSTransaction.getRoVersion(this.sysEnv);
                sDMSROTxList = this.sysEnv.roTxList;
                synchronized (sDMSROTxList) {
                    this.sysEnv.roTxList.add(this.sysEnv, this.sysEnv.tx.versionId);
                }
                this.loadMasters();
                if (this.masterList.size() == 0 || !this.processMasters()) {
                    sDMSROTxList = this.sysEnv.roTxList;
                    synchronized (sDMSROTxList) {
                        this.sysEnv.roTxList.remove(this.sysEnv, this.sysEnv.tx.versionId);
                    }
                    DBCleanupThread.sleep(900000L);
                    continue;
                }
                sDMSROTxList = this.sysEnv.roTxList;
                synchronized (sDMSROTxList) {
                    this.sysEnv.roTxList.remove(this.sysEnv, this.sysEnv.tx.versionId);
                }
            }
        }
        catch (SDMSException sDMSException) {
            DBCleanupThread.doTrace(null, "Error occurred : " + sDMSException.toString(), -2);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            sDMSROTxList = this.sysEnv.roTxList;
            synchronized (sDMSROTxList) {
                this.sysEnv.roTxList.remove(this.sysEnv, this.sysEnv.tx.versionId);
            }
        }
        try {
            this.sysEnv.dbConnection.close();
            return;
        }
        catch (SQLException sQLException) {
            DBCleanupThread.doTrace(null, "Error while closing connection: " + sQLException.getMessage(), -1);
        }
    }
}

