/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.UserConnection;
import de.independit.scheduler.server.parser.Scanner;
import de.independit.scheduler.server.util.SDMSThread;
import de.independit.scheduler.server.util.SyncFifo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class ListenThread
extends SDMSThread {
    public static final String __version = "@(#) $Id: ListenThread.java,v 2.4.6.1 2013/03/14 10:24:09 ronald Exp $";
    public static final int LISTENER = 1;
    public static final int SERVICE = 2;
    private int port;
    private InetAddress iFace;
    private int maxConnections;
    private int svrtype;
    private ThreadGroup uc;
    protected ServerSocket serv;
    private UserConnection[] connects;
    private SyncFifo cmdQueue;
    private SyncFifo roCmdQueue;
    private boolean trace;

    public ListenThread(ThreadGroup threadGroup, int n, InetAddress inetAddress, int n2, SyncFifo syncFifo, SyncFifo syncFifo2, int n3) {
        super(threadGroup, n3 == 1 ? "Listener" : "Service");
        this.svrtype = n3;
        this.port = n;
        this.uc = threadGroup;
        if (this.port <= 0) {
            this.port = 2506;
        }
        this.iFace = inetAddress;
        this.maxConnections = n2;
        if (this.maxConnections <= 0) {
            this.maxConnections = 1000;
        }
        this.run = true;
        this.connects = new UserConnection[this.maxConnections];
        this.cmdQueue = syncFifo;
        this.roCmdQueue = syncFifo2;
        this.trace = false;
        Scanner scanner = new Scanner((Reader)null);
        if (scanner == null) {
            throw new RuntimeException("new on Scanner failed");
        }
    }

    @Override
    public int id() {
        return 0;
    }

    public boolean trace() {
        return this.trace;
    }

    public void trace_on() {
        this.trace = true;
        for (int i = 0; i < this.maxConnections && this.connects[i] != null && this.connects[i].isAlive(); ++i) {
            this.connects[i].getEnv().trace_on();
        }
    }

    public void trace_off() {
        this.trace = false;
        for (int i = 0; i < this.maxConnections && this.connects[i] != null && this.connects[i].isAlive(); ++i) {
            this.connects[i].getEnv().trace_off();
        }
    }

    abstract ServerSocket getServerSocket(int var1, InetAddress var2) throws IOException;

    private void init() {
        try {
            this.serv = this.getServerSocket(this.port, this.iFace);
            this.serv.setSoTimeout(1000);
        }
        catch (IOException iOException) {
            ListenThread.doTrace(null, "Oops: ServerSocket open() problem: " + iOException + "\nPort = " + this.port, -2);
        }
    }

    private void exit() {
        try {
            this.serv.close();
        }
        catch (IOException iOException) {
            ListenThread.doTrace(null, "Oops: ServerSocket close() problem: " + iOException, -2);
        }
    }

    @Override
    public void print(PrintStream printStream) {
        printStream.println(this.getName());
        printStream.println("Port : " + this.port);
        printStream.println("Max Connections : " + this.maxConnections);
        printStream.println("Trace : " + this.trace);
    }

    protected Socket accept() throws InterruptedIOException, IOException {
        Socket socket = this.serv.accept();
        socket.setTcpNoDelay(true);
        return socket;
    }

    @Override
    public void SDMSrun() {
        this.init();
        try {
            block9: while (this.run) {
                int n;
                do {
                    for (n = 0; n < this.maxConnections && this.connects[n] != null && this.connects[n].isAlive(); ++n) {
                    }
                    if (n != this.maxConnections) continue;
                    if (this.svrtype == 1) {
                        ListenThread.doTrace(null, "Out of user connects, waiting 1 second", 1);
                    }
                    try {
                        ListenThread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ListenThread.doTrace(null, "Interrupted " + this.getName(), 1);
                        continue block9;
                    }
                } while (n >= this.maxConnections);
                try {
                    Socket socket = this.accept();
                    socket.setKeepAlive(true);
                    this.connects[n] = new UserConnection(this.trace, this.uc, socket, this.cmdQueue, this.roCmdQueue, this.port);
                    this.connects[n].start();
                    socket = null;
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (IOException iOException) {
                    ListenThread.doTrace(null, "Exception : " + iOException, 1);
                    break;
                }
                for (n = 0; n < this.maxConnections; ++n) {
                    if (this.connects[n] == null || this.connects[n].isAlive()) continue;
                    this.connects[n] = null;
                }
            }
        }
        catch (Error error) {
            ListenThread.doTrace(null, error.toString(), error.getStackTrace(), -2);
        }
        ListenThread.doTrace(null, (this.svrtype == 1 ? "Listener" : "Service") + " waiting for UserConnections to terminate", 0);
        for (int i = 0; i < this.maxConnections; ++i) {
            if (this.connects[i] == null || !this.connects[i].isAlive()) continue;
            try {
                ListenThread.doTrace(null, "Waiting for " + this.connects[i].toString(), 0);
                this.connects[i].do_stop();
                this.connects[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                --i;
            }
        }
        this.exit();
    }
}

