/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.DoSchedule;
import de.independit.scheduler.server.InternalSession;
import de.independit.scheduler.server.Locklist;
import de.independit.scheduler.server.Reservator;
import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSEscape;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.prioComparator;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueProxyGeneric;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSnpJobFootprint;
import de.independit.scheduler.server.repository.SDMSnpJobFootprintTable;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprint;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprintProxyGeneric;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprintTable;
import de.independit.scheduler.server.util.BoolExpr;
import de.independit.scheduler.server.util.Lockmode;
import de.independit.scheduler.server.util.MasterReservationInfo;
import de.independit.scheduler.server.util.SyncFifo;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SchedulingThread
extends InternalSession {
    public static final String name = "SchedulingThread";
    private boolean needSched;
    private boolean needReSched;
    private long priorityDelay;
    private prioComparator pc;
    private long timeoutWakeup;
    private long lastSchedule;
    private Locklist publl = null;
    private Vector<Long> resourceRequestList = null;
    private final Object resourceRequestLock = new Object();
    private final Object lock = new Object();
    private Vector<Long> actualRequestList;
    public static final int CREATE = 1;
    public static final int ALTER = 2;
    public static final int DELETE = 3;
    public static final int REGISTER = 4;
    public static final int DEREGISTER = 5;
    public static final int SUSPEND = 6;
    public static final int RESUME = 7;
    public static final int SHUTDOWN = 8;
    public static final int FINISH = 9;
    public static final int STATECHANGE = 10;
    public static final int COPY = 11;
    public static final int IGNORE_RESOURCE = 12;
    public static final int MOVE = 13;
    public static final int PRIORITY = 14;
    public static final int ALTER_REQAMOUNT = 15;
    public static final int OFFLINE_ONLINE = 16;
    public static final int RERUN = 17;
    public static final int SUBMIT = 18;
    public static final int ENABLE = 19;
    public static final int DISABLE = 20;
    public static final int MAX_PRIORITY = 0;
    public static final int DEFAULT_PRIORITY = 50;
    public static final int MIN_PRIORITY = 100;
    public static final int FP_SCOPE = 0;
    public static final int FP_FOLDER = 1;
    public static final int FP_LOCAL = 2;
    public long envhit = 0L;
    public long envmiss = 0L;
    private long timer = 0L;
    private Date dts = new Date();

    public SchedulingThread(SystemEnvironment systemEnvironment, SyncFifo syncFifo) throws SDMSException {
        super(name);
        this.NR = 1234321;
        this.initThread(systemEnvironment, syncFifo, this.NR, name, SystemEnvironment.scheduleWakeupInterval * 1000);
        this.priorityDelay = SystemEnvironment.priorityDelay;
        this.priorityDelay *= 60000L;
        this.needSched = true;
        this.needReSched = true;
        if (this.pc == null) {
            this.pc = new prioComparator(systemEnvironment, this.priorityDelay);
        }
        this.timeoutWakeup = Long.MAX_VALUE;
        this.lastSchedule = 0L;
    }

    @Override
    protected Node getNode(int n) {
        if (n == 1) {
            return new DoSchedule(1);
        }
        return new DoSchedule();
    }

    public int getDynPriority(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        prioComparator prioComparator2 = new prioComparator(systemEnvironment, this.priorityDelay);
        prioComparator2.setNow();
        return prioComparator2.dynPrio(sDMSSubmittedEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        Reservator reservator;
        Object object = this.lock;
        synchronized (object) {
            if (this.publl == null) {
                return false;
            }
            reservator = this.publl.get(l2, l);
        }
        if (reservator == null) {
            return false;
        }
        return reservator.seq > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRequestList(SystemEnvironment systemEnvironment, Long l) {
        Object object = this.resourceRequestLock;
        synchronized (object) {
            if (systemEnvironment.tx.resourceRequestList == null) {
                systemEnvironment.tx.resourceRequestList = new Vector();
            }
            systemEnvironment.tx.resourceRequestList.add(l);
        }
    }

    public void publishRequestList(SystemEnvironment systemEnvironment) {
        if (systemEnvironment.tx.resourceRequestList == null) {
            return;
        }
        this.addToRequestList(systemEnvironment.tx.resourceRequestList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRequestList(Vector vector) {
        Object object = this.resourceRequestLock;
        synchronized (object) {
            if (this.resourceRequestList == null) {
                this.resourceRequestList = new Vector();
            }
            this.resourceRequestList.addAll(vector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getRequestList() {
        Vector vector;
        Object object = this.resourceRequestLock;
        synchronized (object) {
            vector = this.resourceRequestList;
            this.resourceRequestList = null;
        }
        return vector == null ? new Vector() : vector;
    }

    private void processRequestList(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector;
        this.actualRequestList = vector = this.getRequestList();
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            Integer n2;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            Long l = (Long)vector.get(i);
            try {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, l);
                n2 = sDMSSubmittedEntity.getOldState(systemEnvironment);
                if (n2 == null) continue;
                n = n2;
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            int n3 = sDMSSubmittedEntity.getState(systemEnvironment);
            if (n3 == 1) {
                boolean bl = sDMSSubmittedEntity.getIsDisabled(systemEnvironment);
                this.requestSyncSme(systemEnvironment, sDMSSubmittedEntity, n2);
                if (sDMSSubmittedEntity.getState(systemEnvironment) != 15) {
                    if (n == 0 || n == 1 || n == 15 || n == 16 || bl) {
                        sDMSSubmittedEntity.checkDependencies(systemEnvironment);
                    } else if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 0 && sDMSSubmittedEntity.getParentSuspended(systemEnvironment) == 0 || sDMSSubmittedEntity.getRerunSeq(systemEnvironment) > 0) {
                        sDMSSubmittedEntity.setState(systemEnvironment, 2);
                    }
                }
            } else if (n3 == 2) {
                this.reevaluateJSAssignment(systemEnvironment, sDMSSubmittedEntity);
                this.requestSysSme(systemEnvironment, sDMSSubmittedEntity);
            }
            this.needSched = true;
        }
    }

    protected void scheduleProtected(SystemEnvironment systemEnvironment) throws SDMSException {
        try {
            this.schedule(systemEnvironment);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SerializationException) {
                if (this.actualRequestList != null) {
                    this.addToRequestList(this.actualRequestList);
                }
                throw throwable;
            }
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            SchedulingThread.doTrace(systemEnvironment.cEnv, "Schedule threw an exception; server will abort " + throwable.toString() + ':' + throwable.getMessage() + "\n" + stringWriter.toString(), -2);
            System.exit(1);
        }
        this.actualRequestList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(SystemEnvironment systemEnvironment) throws SDMSException {
        long l;
        this.dts = new Date();
        this.timer = this.dts.getTime();
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        this.processRequestList(systemEnvironment);
        if (this.needReSched) {
            SchedulingThread.doTrace(this.cEnv, "==============> Start Resource Rescheduling <=================\nStartTime = 0", 2);
            SDMSnpJobFootprintTable.table.clearTableUnlocked(systemEnvironment);
            this.reschedule(systemEnvironment);
            SchedulingThread.doTrace(this.cEnv, "==============> End Resource Rescheduling   <=================\nEndTime = " + (this.dts.getTime() - this.timer), 2);
            this.needSched = true;
        }
        if (!this.needSched && (l = this.dts.getTime() - this.timeoutWakeup) < 0L && this.timer < this.lastSchedule + 10000L) {
            return;
        }
        this.lastSchedule = this.timer;
        Locklist locklist = new Locklist();
        SchedulingThread.doTrace(this.cEnv, "---------------> Start Synchronize Resource Scheduling <-------------------\nStartTime = " + (this.dts.getTime() - this.timer), 2);
        this.needSched = false;
        this.syncSchedule(systemEnvironment, locklist);
        SchedulingThread.doTrace(this.cEnv, "---------------> Start System Resource Scheduling <-------------------\nStartTime = " + (this.dts.getTime() - this.timer), 2);
        this.resourceSchedule(systemEnvironment, locklist);
        Object object = this.lock;
        synchronized (object) {
            this.publl = locklist;
        }
        SchedulingThread.doTrace(this.cEnv, "---------------> Start Cleanup LifeTables   <-------------------\nStartTime = " + (this.dts.getTime() - this.timer), 2);
        long l2 = systemEnvironment.roTxList.first(systemEnvironment);
        SchedulingThread.doTrace(this.cEnv, "purgeLow = " + l2, 2);
        SchedulingThread.doTrace(this.cEnv, "purgeSetSize = " + systemEnvironment.nvPurgeSet.size(), 2);
        systemEnvironment.nvPurgeSet.purge(systemEnvironment, l2);
        SchedulingThread.doTrace(this.cEnv, "---------------> End Resource Scheduling   <-------------------\nEndTime = " + (this.dts.getTime() - this.timer), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextJobSchedule(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.needReSched) {
            return false;
        }
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
            if (this.needReSched) {
                return false;
            }
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(SDMSObject.adminGId);
        systemEnvironment.cEnv.pushGid(systemEnvironment, hashSet);
        systemEnvironment.cEnv.setUser();
        Long l = systemEnvironment.cEnv.uid();
        systemEnvironment.cEnv.uid = SDMSObject.internalUId;
        try {
            this.scheduleProtected(systemEnvironment);
        }
        finally {
            systemEnvironment.cEnv.popGid(systemEnvironment);
            systemEnvironment.cEnv.setJobServer();
            systemEnvironment.cEnv.uid = l;
        }
        return true;
    }

    public boolean getPoolSchedule(SystemEnvironment systemEnvironment) throws SDMSException {
        if (this.needReSched) {
            return false;
        }
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
            if (this.needReSched) {
                return false;
            }
        }
        this.scheduleProtected(systemEnvironment);
        return true;
    }

    private void reschedule(SystemEnvironment systemEnvironment) throws SDMSException {
        this.pc.setNow();
        this.needReSched = false;
        Vector vector = SDMSScopeTable.idx_type.getVectorForUpdate(systemEnvironment, SDMSConstants.S_SERVER);
        Vector vector2 = SDMSSubmittedEntityTable.idx_state.getVectorForUpdate(systemEnvironment, SDMSConstants.SME_RUNNABLE, null, Integer.MAX_VALUE);
        SchedulingThread.doTrace(this.cEnv, "Number of Runnable Jobs found: " + vector2.size(), 2);
        SchedulingThread.doTrace(this.cEnv, "==============> Rescheduling Runnables <=================\nStartTime = " + (this.dts.getTime() - this.timer), 2);
        this.rescheduleVector(systemEnvironment, vector2, vector, 4);
        SchedulingThread.doTrace(this.cEnv, "==============> Rescheduling Resource Wait <=================\nStartTime = " + (this.dts.getTime() - this.timer), 2);
        Vector vector3 = SDMSSubmittedEntityTable.idx_state.getVectorForUpdate(systemEnvironment, SDMSConstants.SME_RESOURCE_WAIT, null, Integer.MAX_VALUE);
        SchedulingThread.doTrace(this.cEnv, "Number of Jobs in Resource Wait found: " + vector3.size(), 2);
        this.rescheduleVector(systemEnvironment, vector3, vector, 3);
        SchedulingThread.doTrace(this.cEnv, "==============> Rescheduling Synchronize Wait <=================\nStartTime = " + (this.dts.getTime() - this.timer), 2);
        vector3 = SDMSSubmittedEntityTable.idx_state.getVectorForUpdate(systemEnvironment, SDMSConstants.SME_SYNCHRONIZE_WAIT, null, Integer.MAX_VALUE);
        SchedulingThread.doTrace(this.cEnv, "Number of Jobs in Synchronize Wait found: " + vector3.size(), 2);
        this.rescheduleVector(systemEnvironment, vector3, vector, 2);
        SchedulingThread.doTrace(this.cEnv, "==============> Rescheduling Dependency Wait <=================\nStartTime = " + (this.dts.getTime() - this.timer), 2);
        vector3 = SDMSSubmittedEntityTable.idx_state.getVector(systemEnvironment, (Object)SDMSConstants.SME_DEPENDENCY_WAIT, null, Integer.MAX_VALUE);
        SchedulingThread.doTrace(this.cEnv, "Number of Jobs in Dependency Wait found: " + vector3.size(), 2);
        this.rescheduleVector(systemEnvironment, vector3, vector, 1);
    }

    private void rescheduleVector(SystemEnvironment systemEnvironment, Vector vector, Vector vector2, int n) throws SDMSException {
        Locklist locklist = new Locklist();
        Collections.sort(vector, this.pc);
        for (int i = 0; i < vector.size(); ++i) {
            int n2;
            int n3;
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)vector.get(i);
            long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
            if (sDMSSchedulingEntity.getType(systemEnvironment) != 1) continue;
            Long l2 = sDMSSubmittedEntity.getId(systemEnvironment);
            boolean bl = sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0 || sDMSSubmittedEntity.getParentSuspended(systemEnvironment) > 0;
            Vector vector3 = SDMSRunnableQueueTable.idx_smeId.getVectorForUpdate(systemEnvironment, l2);
            for (n3 = 0; n3 < vector3.size(); ++n3) {
                ((SDMSRunnableQueue)vector3.get(n3)).delete(systemEnvironment);
            }
            vector3 = SDMSResourceAllocationTable.idx_smeId.getVectorForUpdate(systemEnvironment, l2);
            for (n3 = 0; n3 < vector3.size(); ++n3) {
                SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector3.get(n3);
                n2 = sDMSResourceAllocation.getAllocationType(systemEnvironment);
                if (n2 == 4 || n2 == 5 || sDMSResourceAllocation.getIsSticky(systemEnvironment).booleanValue()) continue;
                sDMSResourceAllocation.delete(systemEnvironment, false, true);
            }
            n3 = sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue() ? 1 : 0;
            if (n3 != 0) {
                sDMSSubmittedEntity.checkDependencies(systemEnvironment);
                n2 = sDMSSubmittedEntity.getState(systemEnvironment);
                if (n2 == 11 || n2 == 12) continue;
            }
            this.requestSyncSme(systemEnvironment, sDMSSubmittedEntity, 1);
            if (sDMSSubmittedEntity.getState(systemEnvironment) == 15 || n3 != 0) continue;
            this.reevaluateJSAssignment(systemEnvironment, sDMSSubmittedEntity);
            if (sDMSSubmittedEntity.getState(systemEnvironment) == 15) continue;
            if (n == 4 || n == 3 || n == 2) {
                this.requestSysSme(systemEnvironment, sDMSSubmittedEntity);
            }
            if (n == 4 || n == 3 || n == 2 && !bl) {
                this.syncScheduleSme(systemEnvironment, sDMSSubmittedEntity, locklist);
            }
            if (n != 4 && (sDMSSubmittedEntity.getState(systemEnvironment) != 3 || bl)) continue;
            this.resourceScheduleSme(systemEnvironment, sDMSSubmittedEntity, locklist);
        }
    }

    public void syncSchedule(SystemEnvironment systemEnvironment, Locklist locklist) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        Vector vector = SDMSSubmittedEntityTable.idx_state.getVectorForUpdate(systemEnvironment, SDMSConstants.SME_SYNCHRONIZE_WAIT, null, Integer.MAX_VALUE);
        Vector vector2 = SDMSScopeTable.idx_type.getVector(systemEnvironment, SDMSConstants.S_SERVER);
        SchedulingThread.doTrace(this.cEnv, "Number of Job Server : " + vector2.size(), 3);
        SchedulingThread.doTrace(this.cEnv, "Number of Jobs in SYNCHRONIZE_WAIT : " + vector.size(), 3);
        if (vector2.size() == 0) {
            return;
        }
        this.timeoutWakeup = Long.MAX_VALUE;
        this.pc.setNow();
        Collections.sort(vector, this.pc);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)vector.get(i);
            if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0 || sDMSSubmittedEntity.getParentSuspended(systemEnvironment) > 0 || sDMSSubmittedEntity.getOldState(systemEnvironment) != null) continue;
            if (sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
                sDMSSubmittedEntity.finishDisabledOrBatch(systemEnvironment);
                continue;
            }
            this.syncScheduleSme(systemEnvironment, sDMSSubmittedEntity, locklist);
        }
    }

    public void requestSyncSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, int n) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
        if (sDMSSchedulingEntity.getType(systemEnvironment) != 1) {
            return;
        }
        if (!sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
            Vector vector = this.getServerList(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, l);
            this.requestResourceSme(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, vector, 4, l, n);
        }
        sDMSSubmittedEntity.setOldState(systemEnvironment, null);
    }

    public void requestSysSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        long l = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l);
        if (sDMSSchedulingEntity.getType(systemEnvironment) != 1) {
            return;
        }
        if (!sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
            Vector vector = this.findRelevantJobserver(systemEnvironment, sDMSSubmittedEntity);
            this.requestResourceSme(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, vector, 2, l, 2);
        }
        sDMSSubmittedEntity.setOldState(systemEnvironment, null);
    }

    private Vector getServerList(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity, long l) throws SDMSException {
        Long l2;
        Long l3;
        Object object;
        Long l4;
        HashMap hashMap;
        Vector<Object> vector;
        Vector vector2 = null;
        if (systemEnvironment.tx.envJSMap == null) {
            systemEnvironment.tx.envJSMap = new HashMap();
        }
        if ((vector = (Vector<Object>)(hashMap = systemEnvironment.tx.envJSMap).get(l4 = sDMSSchedulingEntity.getNeId(systemEnvironment))) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (Vector)vector.get(i);
                l3 = (Long)((Vector)object).get(0);
                l2 = (Long)((Vector)object).get(1);
                if (l3 >= l || l2 < l) continue;
                vector2 = (Vector)((Vector)object).get(2);
                ++this.envhit;
                break;
            }
        }
        if (vector == null || vector2 == null) {
            Object object2;
            ++this.envmiss;
            Vector vector3 = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, (Object)l4, l);
            object = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l4, l);
            l3 = ((SDMSProxy)object).getValidFrom(systemEnvironment);
            l2 = ((SDMSProxy)object).getValidTo(systemEnvironment);
            vector2 = SDMSScopeTable.idx_type.getVectorForUpdate(systemEnvironment, SDMSConstants.S_SERVER);
            Iterator iterator = vector2.iterator();
            block1: while (iterator.hasNext()) {
                object2 = (SDMSScope)iterator.next();
                if (!((SDMSScopeProxyGeneric)object2).getIsRegistered(systemEnvironment).booleanValue() || !((SDMSScopeProxyGeneric)object2).getIsEnabled(systemEnvironment).booleanValue()) {
                    iterator.remove();
                    continue;
                }
                Long l5 = ((SDMSProxy)object2).getId(systemEnvironment);
                SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUniqueForUpdate(systemEnvironment, l5);
                HashMap hashMap2 = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
                for (int i = 0; i < vector3.size(); ++i) {
                    SDMSEnvironment sDMSEnvironment = (SDMSEnvironment)vector3.get(i);
                    Long l6 = sDMSEnvironment.getNrId(systemEnvironment);
                    if (!hashMap2.containsKey(l6)) {
                        iterator.remove();
                        continue block1;
                    }
                    SDMSResource sDMSResource = SDMSResourceTable.getObjectForUpdate(systemEnvironment, (Long)hashMap2.get(l6));
                    if (sDMSResource.getIsOnline(systemEnvironment).booleanValue()) continue;
                    iterator.remove();
                    continue block1;
                }
            }
            object2 = new Vector();
            ((Vector)object2).add(l3);
            ((Vector)object2).add(l2);
            ((Vector)object2).add(vector2);
            if (vector == null) {
                vector = new Vector<Object>();
            }
            vector.add(object2);
            hashMap.put(l4, vector);
        }
        return vector2;
    }

    public static void allocateAndReleaseResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSScope sDMSScope) throws SDMSException {
        SDMSnpJobFootprint sDMSnpJobFootprint;
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, SystemEnvironment.sched, 1);
        }
        try {
            sDMSnpJobFootprint = SDMSnpJobFootprintTable.idx_smeId_getUnique(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            SchedulingThread.getJobFootprint(systemEnvironment, sDMSSubmittedEntity);
            sDMSnpJobFootprint = SDMSnpJobFootprintTable.idx_smeId_getUnique(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        }
        HashMap hashMap = sDMSnpJobFootprint.getFpLocal(systemEnvironment);
        HashMap hashMap2 = sDMSnpJobFootprint.getFpFolder(systemEnvironment);
        SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
        HashMap hashMap3 = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
        Vector vector = SDMSResourceAllocationTable.idx_smeId.getVectorForUpdate(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            Long l;
            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector.get(i);
            try {
                l = sDMSResourceAllocation.getRId(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            SDMSResource sDMSResource = SDMSResourceTable.getObjectForUpdate(systemEnvironment, l);
            Long l2 = sDMSResource.getNrId(systemEnvironment);
            if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 2) {
                if (hashMap2.containsKey(l2) || hashMap.containsKey(l2)) {
                    sDMSResourceAllocation.setAllocationType(systemEnvironment, SDMSConstants.RA_ALLOCATION);
                } else {
                    Long l3 = (Long)hashMap3.get(l2);
                    SDMSResource sDMSResource2 = SDMSResourceTable.getObjectForUpdate(systemEnvironment, l3);
                    if (sDMSResource2.getId(systemEnvironment).equals(l)) {
                        sDMSResourceAllocation.setAllocationType(systemEnvironment, SDMSConstants.RA_ALLOCATION);
                    }
                }
                if (sDMSResourceAllocation.getIsSticky(systemEnvironment).booleanValue()) {
                    // empty if block
                }
            }
            if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 4 || sDMSResourceAllocation.getAllocationType(systemEnvironment) == 5) continue;
            sDMSResourceAllocation.delete(systemEnvironment, true, true);
        }
        SystemEnvironment.sched.needSched = true;
    }

    private void requestResourceSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity, Vector vector, int n, long l, int n2) throws SDMSException {
        Cloneable cloneable;
        SDMSScope sDMSScope;
        SDMSProxy sDMSProxy;
        Serializable serializable2;
        HashMap hashMap = new HashMap();
        Long l2 = sDMSSubmittedEntity.getId(systemEnvironment);
        Integer n3 = sDMSSubmittedEntity.getState(systemEnvironment);
        boolean bl = false;
        HashMap hashMap2 = (HashMap)SchedulingThread.getJobFootprint(systemEnvironment, sDMSSubmittedEntity).get(0);
        if (sDMSSubmittedEntity.getState(systemEnvironment) == 15) {
            return;
        }
        Vector vector2 = new Vector();
        vector2 = new Vector();
        Vector vector3 = this.checkKeptResources(systemEnvironment, l2, vector2, vector) ? vector2 : vector;
        if (this.checkStickyResources(systemEnvironment, l2, hashMap2, vector2, vector3)) {
            vector3 = vector2;
        }
        try {
            this.requestLocalResourceSme(systemEnvironment, sDMSSubmittedEntity, n, hashMap, n2);
            this.requestFolderResourceSme(systemEnvironment, sDMSSubmittedEntity, n, hashMap, n2);
        }
        catch (SDMSEscape sDMSEscape) {
            sDMSSubmittedEntity.setToError(systemEnvironment, "Sticky Resource resolution conflict (resource to allocate not visible)");
            serializable2 = sDMSSubmittedEntity.getMasterId(systemEnvironment);
            sDMSProxy = SDMSSubmittedEntityTable.getObject(systemEnvironment, (Long)serializable2);
            ((SDMSSubmittedEntity)sDMSProxy).suspend(systemEnvironment, false, false);
            SDMSAuditTrailTable.table.create(systemEnvironment, this.cEnv.uid(), new Date().getTime(), SDMSConstants.AT_JOB_IN_ERROR, SDMSConstants.AT_JOB, sDMSProxy.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, "Sticky Resource resolution conflict (resource to allocate not visible); Master Suspended");
        }
        for (int i = 0; i < vector3.size(); ++i) {
            block15: {
                sDMSScope = (SDMSScope)vector3.get(i);
                if (!sDMSScope.getIsRegistered(systemEnvironment).booleanValue()) continue;
                serializable2 = sDMSScope.getId(systemEnvironment);
                if (!sDMSScope.canExecute(systemEnvironment, sDMSSubmittedEntity)) continue;
                sDMSProxy = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
                cloneable = ((SDMSnpSrvrSRFootprintProxyGeneric)sDMSProxy).getFp(systemEnvironment);
                systemEnvironment.tx.beginSubTransaction(systemEnvironment);
                try {
                    if (!SchedulingThread.fits(systemEnvironment, (HashMap)cloneable, hashMap2, sDMSSubmittedEntity, false, null)) break block15;
                    this.requestResources(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, l, (HashMap)cloneable, n, hashMap2, hashMap, n2);
                    try {
                        SDMSRunnableQueue sDMSRunnableQueue = SDMSRunnableQueueTable.idx_smeId_scopeId_getUniqueForUpdate(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)serializable2)));
                        sDMSRunnableQueue.setState(systemEnvironment, n3);
                    }
                    catch (NotFoundException notFoundException) {
                        SDMSRunnableQueueTable.table.create(systemEnvironment, l2, (Long)serializable2, n3);
                    }
                    bl = true;
                }
                catch (SDMSEscape sDMSEscape) {
                    systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                    continue;
                }
                catch (Exception exception) {
                    SchedulingThread.doTrace(this.cEnv, ": Job " + l2 + " run into an Exception during Resource Scheduling : " + exception.toString(), 1);
                    systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
                    throw exception;
                }
            }
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        if (n == 4) {
            for (Serializable serializable2 : hashMap.values()) {
                for (int i = 0; i < ((Vector)serializable2).size(); ++i) {
                    cloneable = (Vector)((Vector)serializable2).get(i);
                    if (((Boolean)((Vector)cloneable).get(1)).booleanValue()) continue;
                    ((SDMSResourceAllocation)((Vector)cloneable).get(0)).cleanupStickyGroup(systemEnvironment);
                }
            }
        }
        if (!bl) {
            sDMSSubmittedEntity.setToError(systemEnvironment, "Job cannot run in any scope because of resource shortage");
            for (int i = 0; i < vector3.size(); ++i) {
                sDMSScope = (SDMSScope)vector3.get(i);
                serializable2 = sDMSScope.getId(systemEnvironment);
                if (!sDMSScope.getIsRegistered(systemEnvironment).booleanValue() || !sDMSScope.canExecute(systemEnvironment, sDMSSubmittedEntity)) continue;
                sDMSProxy = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
                cloneable = ((SDMSnpSrvrSRFootprintProxyGeneric)sDMSProxy).getFp(systemEnvironment);
                SchedulingThread.verboseFits(systemEnvironment, (HashMap)cloneable, hashMap2, sDMSSubmittedEntity, false, null);
            }
        }
    }

    public void reevaluateJSAssignment(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSScope sDMSScope;
        Comparable comparable;
        int n;
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        boolean bl = false;
        HashMap hashMap = (HashMap)SchedulingThread.getJobFootprint(systemEnvironment, sDMSSubmittedEntity).get(0);
        SchedulingThread.doTrace(this.cEnv, ": Job " + sDMSSubmittedEntity.getId(systemEnvironment) + " is re-evaluated", 3);
        long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l2);
        if (sDMSSchedulingEntity.getType(systemEnvironment) != 1) {
            return;
        }
        Vector vector = SDMSRunnableQueueTable.idx_smeId.getVectorForUpdate(systemEnvironment, l);
        Vector<SDMSScope> vector2 = new Vector<SDMSScope>();
        for (n = 0; n < vector.size(); ++n) {
            comparable = (SDMSRunnableQueue)vector.get(n);
            try {
                sDMSScope = SDMSScopeTable.getObject(systemEnvironment, comparable.getScopeId(systemEnvironment));
                vector2.add(sDMSScope);
                SchedulingThread.doTrace(this.cEnv, ": added scope id " + sDMSScope.getId(systemEnvironment), 3);
                continue;
            }
            catch (NotFoundException notFoundException) {
                comparable.delete(systemEnvironment);
            }
        }
        SchedulingThread.doTrace(this.cEnv, ": we've found " + vector2.size() + " potential servers", 3);
        for (n = 0; n < vector2.size(); ++n) {
            sDMSScope = (SDMSScope)vector2.get(n);
            comparable = sDMSScope.getId(systemEnvironment);
            SchedulingThread.doTrace(this.cEnv, ": testing server " + comparable, 3);
            SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
            HashMap hashMap2 = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
            if (sDMSScope.getIsRegistered(systemEnvironment).booleanValue() && SchedulingThread.fits(systemEnvironment, hashMap2, hashMap, sDMSSubmittedEntity, true, sDMSScope)) {
                SchedulingThread.doTrace(this.cEnv, ": seems to fit *****************", 3);
                bl = true;
                continue;
            }
            SchedulingThread.doTrace(this.cEnv, ": doesn't seem to fit -+-+-+-+-+-+-+-+-", 3);
            SchedulingThread.doTrace(this.cEnv, ": deleting [" + sDMSScope.getId(systemEnvironment) + ", " + l + "]", 3);
            try {
                SDMSRunnableQueue sDMSRunnableQueue = SDMSRunnableQueueTable.idx_smeId_scopeId_getUnique(systemEnvironment, new SDMSKey(l, comparable));
                sDMSRunnableQueue.delete(systemEnvironment);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            block6: for (Long l3 : hashMap.keySet()) {
                Long l4 = (Long)hashMap2.get(l3);
                if (l4 == null) continue;
                SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l4);
                Long l5 = sDMSResource.getId(systemEnvironment);
                Vector vector3 = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l, sDMSResource.getNrId(systemEnvironment)));
                for (int i = 0; i < vector3.size(); ++i) {
                    SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector3.get(i);
                    if (!sDMSResourceAllocation.getRId(systemEnvironment).equals(l5)) continue;
                    sDMSResourceAllocation.delete(systemEnvironment, true, false);
                    continue block6;
                }
            }
        }
        if (!bl) {
            sDMSSubmittedEntity.setToError(systemEnvironment, "Job cannot run in any scope because of resource shortage");
        }
    }

    private void requestFolderResourceSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, int n, HashMap hashMap, int n2) throws SDMSException {
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        try {
            SDMSnpJobFootprint sDMSnpJobFootprint = SDMSnpJobFootprintTable.idx_smeId_getUnique(systemEnvironment, l);
            HashMap hashMap2 = sDMSnpJobFootprint.getFpFolder(systemEnvironment);
            this.requestLocalFolderResources(systemEnvironment, sDMSSubmittedEntity, l, hashMap2, n, hashMap, n2);
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03501142150", "No footprint found for job $1", l));
        }
    }

    private void requestLocalResourceSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, int n, HashMap hashMap, int n2) throws SDMSException {
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        try {
            SDMSnpJobFootprint sDMSnpJobFootprint = SDMSnpJobFootprintTable.idx_smeId_getUniqueForUpdate(systemEnvironment, l);
            HashMap hashMap2 = sDMSnpJobFootprint.getFpLocal(systemEnvironment);
            this.requestLocalFolderResources(systemEnvironment, sDMSSubmittedEntity, l, hashMap2, n, hashMap, n2);
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03501142151", "No footprint found for job $1", l));
        }
    }

    private void requestLocalFolderResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Long l, HashMap hashMap, int n, HashMap hashMap2, int n2) throws SDMSException {
        for (Vector vector : hashMap.values()) {
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(0);
            SDMSResource sDMSResource = (SDMSResource)vector.get(1);
            Long l2 = sDMSResourceRequirement.getNrId(systemEnvironment);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2);
            if (sDMSNamedResource.getUsage(systemEnvironment) != n || sDMSResourceRequirement.getIsSticky(systemEnvironment).booleanValue() && n2 != 0) continue;
            this.createRequest(systemEnvironment, l, sDMSResourceRequirement, sDMSResource, l2, n, hashMap2);
        }
    }

    private void requestResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity, long l, HashMap hashMap, int n, HashMap hashMap2, HashMap hashMap3, int n2) throws SDMSException {
        Iterator iterator = null;
        iterator = hashMap2.values().iterator();
        Long l2 = sDMSSubmittedEntity.getId(systemEnvironment);
        while (iterator.hasNext()) {
            Long l3;
            SDMSNamedResource sDMSNamedResource;
            SDMSResourceRequirement sDMSResourceRequirement;
            SDMSProxy sDMSProxy = (SDMSProxy)iterator.next();
            if (!(sDMSProxy instanceof SDMSResourceRequirement) || (sDMSResourceRequirement = (SDMSResourceRequirement)sDMSProxy).getIsSticky(systemEnvironment).booleanValue() && n2 != 0 || (sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l3 = sDMSResourceRequirement.getNrId(systemEnvironment))).getUsage(systemEnvironment) != n) continue;
            SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, (Long)hashMap.get(l3));
            this.createRequest(systemEnvironment, l2, sDMSResourceRequirement, sDMSResource, l3, n, hashMap3);
        }
    }

    private boolean isVisible(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Long l) throws SDMSException {
        Long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l2);
        Long l3 = sDMSSchedulingEntity.getFolderId(systemEnvironment);
        while (l3 != null) {
            if (l3.equals(l)) {
                return true;
            }
            SDMSFolder sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l3, l2);
            l3 = sDMSFolder.getParentId(systemEnvironment);
        }
        return false;
    }

    private void createRequest(SystemEnvironment systemEnvironment, Long l, SDMSResourceRequirement sDMSResourceRequirement, SDMSResource sDMSResource, Long l2, int n, HashMap hashMap) throws SDMSException {
        float f = 1.0f;
        Comparable<Long> comparable = null;
        if (sDMSResourceRequirement == null) {
            return;
        }
        Long l3 = sDMSResource.getId(systemEnvironment);
        f = sDMSResource.getFactor(systemEnvironment).floatValue();
        try {
            SDMSResourceAllocation sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUniqueForUpdate(systemEnvironment, new SDMSKey(l, l3, (Comparable)((Object)sDMSResourceRequirement.getStickyName(systemEnvironment))));
            sDMSResourceAllocation.setRefcount(systemEnvironment, sDMSResourceAllocation.getRefcount(systemEnvironment) + 1);
            return;
        }
        catch (NotFoundException notFoundException) {
            Serializable serializable;
            Object object;
            Serializable serializable2;
            Long l4;
            Object object2;
            Number number;
            Long l5;
            Integer n2;
            if (SDMSResourceAllocationTable.idx_smeId_rId_stickyName.containsKey(systemEnvironment, new SDMSKey(l, l2, (Comparable)((Object)sDMSResourceRequirement.getStickyName(systemEnvironment))))) {
                return;
            }
            if (n == 4) {
                n2 = sDMSResourceRequirement.getLockmode(systemEnvironment);
                if (n2 == null) {
                    n2 = SDMSConstants.RR_N;
                }
                l5 = sDMSResourceRequirement.getRsmpId(systemEnvironment);
                number = sDMSResourceRequirement.getStickyParent(systemEnvironment);
                if (sDMSResourceRequirement.getIsSticky(systemEnvironment).booleanValue()) {
                    object2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                    comparable = ((SDMSSubmittedEntityProxyGeneric)object2).getMasterId(systemEnvironment);
                    if (number != null) {
                        l4 = ((SDMSSubmittedEntityProxyGeneric)object2).getParentId(systemEnvironment);
                        while (l4 != null && !((Long)number).equals(((SDMSSubmittedEntityProxyGeneric)object2).getSeId(systemEnvironment))) {
                            object2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l4);
                            l4 = ((SDMSSubmittedEntityProxyGeneric)object2).getParentId(systemEnvironment);
                        }
                        if (l4 != null || ((Long)number).equals(((SDMSSubmittedEntityProxyGeneric)object2).getSeId(systemEnvironment))) {
                            comparable = ((SDMSProxy)object2).getId(systemEnvironment);
                        }
                    } else {
                        l4 = sDMSResource.getScopeId(systemEnvironment);
                        if (!SDMSScopeTable.table.exists(systemEnvironment, l4)) {
                            if (SDMSFolderTable.table.exists(systemEnvironment, l4)) {
                                serializable2 = l;
                                object = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                                serializable = ((SDMSSubmittedEntityProxyGeneric)object).getParentId(systemEnvironment);
                                while (serializable != null) {
                                    object = SDMSSubmittedEntityTable.getObject(systemEnvironment, (Long)serializable);
                                    if (this.isVisible(systemEnvironment, (SDMSSubmittedEntity)object, l4)) {
                                        serializable2 = serializable;
                                    }
                                    serializable = ((SDMSSubmittedEntityProxyGeneric)object).getParentId(systemEnvironment);
                                }
                                comparable = serializable2;
                            } else {
                                comparable = l4;
                            }
                        }
                    }
                }
            } else {
                n2 = SDMSConstants.RR_N;
                l5 = null;
            }
            number = (int)Math.ceil((float)sDMSResourceRequirement.getAmount(systemEnvironment).intValue() * f);
            if (sDMSResourceRequirement.getIsSticky(systemEnvironment).booleanValue()) {
                Object object3;
                Object object4;
                int n3;
                object2 = sDMSResourceRequirement.getStickyName(systemEnvironment);
                l4 = -comparable.longValue();
                serializable2 = new SDMSKey(l4, (Comparable)object2, l2);
                object = (Vector)hashMap.get(serializable2);
                if (object == null) {
                    serializable = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l4, l2));
                    object = new Vector();
                    for (n3 = 0; n3 < ((Vector)serializable).size(); ++n3) {
                        object4 = (SDMSResourceAllocation)((Vector)serializable).get(n3);
                        object3 = ((SDMSResourceAllocationProxyGeneric)object4).getStickyName(systemEnvironment);
                        if ((object3 != null || object2 != null) && (object3 == null || !((String)object3).equals(object2))) continue;
                        Vector<Object> vector = new Vector<Object>();
                        vector.add(object4);
                        vector.add(Boolean.FALSE);
                        ((Vector)object).add(vector);
                    }
                    hashMap.put(serializable2, object);
                }
                if (((Vector)object).size() != 0) {
                    boolean bl = false;
                    for (n3 = 0; n3 < ((Vector)object).size(); ++n3) {
                        object4 = (Vector)((Vector)object).get(n3);
                        object3 = (SDMSResourceAllocation)((Vector)object4).get(0);
                        if (!((SDMSResourceAllocationProxyGeneric)object3).getRId(systemEnvironment).equals(l3)) continue;
                        bl = true;
                        ((Vector)object4).set(1, Boolean.TRUE);
                        int n4 = ((SDMSResourceAllocationProxyGeneric)object3).getOrigAmount(systemEnvironment);
                        int n5 = ((SDMSResourceAllocationProxyGeneric)object3).getLockmode(systemEnvironment);
                        if (n4 < (Integer)number) {
                            if (((SDMSResourceAllocationProxyGeneric)object3).getAllocationType(systemEnvironment) == 3) {
                                SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03405261410", "Invalid amount escalation for already reserved sticky resource $1, job definition $2", l3, sDMSSchedulingEntity.pathString(systemEnvironment)));
                            }
                            ((SDMSResourceAllocationProxyGeneric)object3).setOrigAmount(systemEnvironment, (Integer)number);
                            ((SDMSResourceAllocation)object3).setAmount(systemEnvironment, (Integer)number);
                        }
                        if ((n5 &= n2.intValue()) != ((SDMSResourceAllocationProxyGeneric)object3).getLockmode(systemEnvironment)) {
                            if (((SDMSResourceAllocationProxyGeneric)object3).getAllocationType(systemEnvironment) == 3) {
                                SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03405261415", "Invalid lock escalation for already reserved sticky resource $1, job definition $2", l3, sDMSSchedulingEntity.pathString(systemEnvironment)));
                            }
                            ((SDMSResourceAllocationProxyGeneric)object3).setLockmode(systemEnvironment, n5);
                        }
                        int n6 = ((SDMSResourceAllocationProxyGeneric)object3).getRefcount(systemEnvironment);
                        ((SDMSResourceAllocation)object3).setRefcount(systemEnvironment, n6 + 1);
                        break;
                    }
                    if (!bl) {
                        throw new SDMSEscape();
                    }
                } else {
                    try {
                        SDMSResourceAllocationTable.table.create(systemEnvironment, l3, l4, l2, (Integer)number, (Integer)number, sDMSResourceRequirement.getKeepMode(systemEnvironment), sDMSResourceRequirement.getIsSticky(systemEnvironment), sDMSResourceRequirement.getStickyName(systemEnvironment), (Long)comparable, SDMSConstants.RA_MASTER_REQUEST, null, n2, SDMSConstants.iONE);
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                        // empty catch block
                    }
                }
            }
            SDMSResourceAllocationTable.table.create(systemEnvironment, l3, l, l2, (Integer)number, (Integer)number, sDMSResourceRequirement.getKeepMode(systemEnvironment), sDMSResourceRequirement.getIsSticky(systemEnvironment), sDMSResourceRequirement.getStickyName(systemEnvironment), (Long)comparable, SDMSConstants.RA_REQUEST, l5, n2, SDMSConstants.iONE);
            return;
        }
    }

    private Vector findRelevantJobserver(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Vector<SDMSScope> vector = new Vector<SDMSScope>();
        Vector vector2 = SDMSRunnableQueueTable.idx_smeId.getVectorForUpdate(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSRunnableQueue sDMSRunnableQueue = (SDMSRunnableQueue)vector2.get(i);
            SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSRunnableQueue.getScopeId(systemEnvironment));
            vector.add(sDMSScope);
        }
        return vector;
    }

    private void syncScheduleSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Locklist locklist) throws SDMSException {
        Object object;
        Object object2;
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        boolean bl = false;
        Vector vector = SchedulingThread.getJobFootprint(systemEnvironment, sDMSSubmittedEntity);
        HashMap hashMap = (HashMap)vector.get(0);
        Vector vector2 = new Vector();
        long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l2);
        Vector vector3 = this.findRelevantJobserver(systemEnvironment, sDMSSubmittedEntity);
        HashMap hashMap2 = (HashMap)vector.get(1);
        HashMap hashMap3 = (HashMap)vector.get(2);
        boolean bl2 = bl = this.reserveFp(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, locklist, hashMap2, 4) && this.reserveFp(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, locklist, hashMap3, 4);
        if (!bl) {
            this.checkTimeout(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, l2);
            return;
        }
        bl = false;
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSScope sDMSScope = (SDMSScope)vector3.get(i);
            Long l3 = sDMSScope.getId(systemEnvironment);
            SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, l3);
            object2 = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
            if (!this.checkStaticResources(systemEnvironment, (HashMap)object2, hashMap) || !this.reserveSyncResources(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, l2, (HashMap)object2, locklist, (Iterator)(object = hashMap.values().iterator()))) continue;
            bl = true;
            SDMSRunnableQueue sDMSRunnableQueue = SDMSRunnableQueueTable.idx_smeId_scopeId_getUniqueForUpdate(systemEnvironment, new SDMSKey(l, l3));
            sDMSRunnableQueue.setState(systemEnvironment, SDMSConstants.SME_RESOURCE_WAIT);
        }
        if (bl) {
            int n;
            Vector vector4 = SDMSResourceAllocationTable.idx_smeId.getVectorForUpdate(systemEnvironment, l);
            for (n = 0; n < vector4.size(); ++n) {
                object2 = (SDMSResourceAllocation)vector4.get(n);
                if (((SDMSResourceAllocationProxyGeneric)object2).getAllocationType(systemEnvironment) != 1 || ((SDMSNamedResourceProxyGeneric)(object = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResourceAllocationProxyGeneric)object2).getNrId(systemEnvironment)))).getUsage(systemEnvironment) != 4) continue;
                ((SDMSResourceAllocation)object2).delete(systemEnvironment, true, true);
            }
            Vector vector5 = SDMSRunnableQueueTable.idx_smeId.getVector(systemEnvironment, l);
            for (n = 0; n < vector5.size(); ++n) {
                object2 = (SDMSRunnableQueue)vector5.get(n);
                if (((SDMSRunnableQueueProxyGeneric)object2).getState(systemEnvironment) == 3) continue;
                ((SDMSRunnableQueue)object2).delete(systemEnvironment);
            }
            sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_RESOURCE_WAIT);
        } else {
            this.checkTimeout(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, l2);
        }
    }

    private boolean checkKeptResources(SystemEnvironment systemEnvironment, Long l, Vector vector, Vector vector2) throws SDMSException {
        Vector vector3 = SDMSResourceAllocationTable.idx_smeId.getVectorForUpdate(systemEnvironment, l);
        boolean bl = false;
        for (int i = 0; i < vector3.size(); ++i) {
            HashMap hashMap;
            SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint;
            SDMSScope sDMSScope;
            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector3.get(i);
            int n = sDMSResourceAllocation.getAllocationType(systemEnvironment);
            if (n != 4) continue;
            if (!bl) {
                for (int j = 0; j < vector2.size(); ++j) {
                    sDMSScope = (SDMSScope)vector2.get(j);
                    sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
                    hashMap = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
                    if (!hashMap.containsValue(sDMSResourceAllocation.getRId(systemEnvironment))) continue;
                    vector.addElement(sDMSScope);
                    bl = true;
                }
                continue;
            }
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                sDMSScope = (SDMSScope)iterator.next();
                sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
                hashMap = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
                if (hashMap.containsValue(sDMSResourceAllocation.getRId(systemEnvironment))) continue;
                iterator.remove();
            }
        }
        return bl;
    }

    private boolean checkStickyResources(SystemEnvironment systemEnvironment, Long l, HashMap hashMap, Vector vector, Vector vector2) throws SDMSException {
        Vector vector3 = SDMSResourceAllocationTable.idx_smeId.getVector(systemEnvironment, l);
        Iterator iterator = vector3.iterator();
        while (iterator.hasNext()) {
            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)iterator.next();
            if (!sDMSResourceAllocation.getIsSticky(systemEnvironment).booleanValue()) {
                iterator.remove();
                continue;
            }
            if (hashMap.containsKey(sDMSResourceAllocation.getNrId(systemEnvironment))) continue;
            iterator.remove();
        }
        if (vector3.size() == 0) {
            return false;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSScope sDMSScope = (SDMSScope)vector2.get(i);
            SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
            HashMap hashMap2 = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
            for (SDMSResourceAllocation sDMSResourceAllocation : vector3) {
                if (!hashMap2.containsValue(sDMSResourceAllocation.getRId(systemEnvironment))) continue;
                vector.addElement(sDMSScope);
            }
        }
        return true;
    }

    private void checkTimeout(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity, long l) throws SDMSException {
        Integer n = sDMSSchedulingEntity.getTimeoutBase(systemEnvironment);
        if (n != null) {
            long l2 = sDMSSchedulingEntity.getTimeoutAmount(systemEnvironment).longValue();
            switch (n) {
                case 0: {
                    l2 *= 60000L;
                    break;
                }
                case 1: {
                    l2 *= 3600000L;
                    break;
                }
                case 2: {
                    l2 *= 86400000L;
                    break;
                }
                case 3: {
                    l2 *= 604800000L;
                    break;
                }
                case 4: {
                    l2 *= 2592000000L;
                    break;
                }
                case 5: {
                    l2 *= 31536000000L;
                }
            }
            Date date = new Date();
            long l3 = date.getTime();
            long l4 = sDMSSubmittedEntity.getSyncTs(systemEnvironment) + l2;
            if (l4 < l3) {
                SDMSExitState sDMSExitState;
                SchedulingThread.doTrace(this.cEnv, ": Job " + sDMSSubmittedEntity.getId(systemEnvironment) + " run into timeout", 2);
                Long l5 = sDMSSchedulingEntity.getTimeoutStateId(systemEnvironment);
                Long l6 = sDMSSchedulingEntity.getEspId(systemEnvironment);
                SDMSAuditTrailTable.table.create(systemEnvironment, this.cEnv.uid(), new Date().getTime(), SDMSConstants.AT_TIMEOUT, SDMSConstants.AT_JOB, sDMSSubmittedEntity.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment), Boolean.FALSE, null, "Job run into timeout (waiting for resources)");
                try {
                    sDMSExitState = SDMSExitStateTable.idx_espId_esdId_getUnique(systemEnvironment, new SDMSKey(l6, l5), l);
                }
                catch (NotFoundException notFoundException) {
                    SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l5, l);
                    sDMSSubmittedEntity.setToError(systemEnvironment, "Invalid Timeout State : " + sDMSExitStateDefinition.getName(systemEnvironment));
                    return;
                }
                sDMSSubmittedEntity.changeState(systemEnvironment, l5, sDMSExitState, sDMSSubmittedEntity.getExitCode(systemEnvironment), "Timeout", null);
            } else if (l4 < this.timeoutWakeup) {
                this.timeoutWakeup = l4;
            }
        }
    }

    public void resourceSchedule(SystemEnvironment systemEnvironment, Locklist locklist) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        Vector vector = SDMSSubmittedEntityTable.idx_state.getVectorForUpdate(systemEnvironment, SDMSConstants.SME_RESOURCE_WAIT, null, Integer.MAX_VALUE);
        SchedulingThread.doTrace(this.cEnv, "Number of Jobs in RESOURCE_WAIT : " + vector.size(), 3);
        this.pc.setNow();
        Collections.sort(vector, this.pc);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)vector.get(i);
            if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) != 0 || sDMSSubmittedEntity.getParentSuspended(systemEnvironment) > 0) continue;
            if (sDMSSubmittedEntity.getIsDisabled(systemEnvironment).booleanValue()) {
                sDMSSubmittedEntity.finishDisabledOrBatch(systemEnvironment);
                SchedulingThread.doTrace(this.cEnv, " (DISABLED BUG): Disabled Job " + sDMSSubmittedEntity.getId(systemEnvironment) + " finished in resourceSchedule()", 1);
                continue;
            }
            this.resourceScheduleSme(systemEnvironment, sDMSSubmittedEntity, locklist);
        }
    }

    private void resourceScheduleSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, Locklist locklist) throws SDMSException {
        Object object;
        SDMSRunnableQueue sDMSRunnableQueue;
        boolean bl = false;
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), l2);
        Vector vector = SchedulingThread.getJobFootprint(systemEnvironment, sDMSSubmittedEntity);
        HashMap hashMap = (HashMap)vector.get(0);
        HashMap hashMap2 = (HashMap)vector.get(1);
        HashMap hashMap3 = (HashMap)vector.get(2);
        bl = this.reserveFp(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, locklist, hashMap3, 2);
        if (bl) {
            bl = this.reserveFp(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, locklist, hashMap2, 2);
        }
        if (!bl) {
            this.checkTimeout(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, l2);
            return;
        }
        bl = false;
        Vector vector2 = SDMSRunnableQueueTable.idx_smeId.getVectorForUpdate(systemEnvironment, l);
        if (vector2.size() == 0) {
            SchedulingThread.doTrace(this.cEnv, ": Job " + sDMSSubmittedEntity.getId(systemEnvironment) + " cannot run in any scope", 1);
            return;
        }
        SDMSScope sDMSScope = null;
        for (int i = 0; i < vector2.size(); ++i) {
            sDMSRunnableQueue = (SDMSRunnableQueue)vector2.get(i);
            sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSRunnableQueue.getScopeId(systemEnvironment));
            Iterator iterator = hashMap.values().iterator();
            object = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment)).getFp(systemEnvironment);
            if (!this.reserveSysResources(systemEnvironment, sDMSSubmittedEntity, (HashMap)object, locklist, iterator)) continue;
            bl = true;
            sDMSRunnableQueue.setState(systemEnvironment, SDMSConstants.SME_RUNNABLE);
            SchedulingThread.allocateAndReleaseResources(systemEnvironment, sDMSSubmittedEntity, sDMSScope);
            break;
        }
        if (bl) {
            SchedulingThread.doTrace(this.cEnv, ": Job " + l + " added to Runnable Queue " + sDMSScope.getId(systemEnvironment), 3);
            Vector vector3 = SDMSResourceAllocationTable.idx_smeId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector3.size(); ++i) {
                SDMSNamedResource sDMSNamedResource;
                object = (SDMSResourceAllocation)vector3.get(i);
                if (((SDMSResourceAllocationProxyGeneric)object).getAllocationType(systemEnvironment) != 1 || (sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResourceAllocationProxyGeneric)object).getNrId(systemEnvironment))).getUsage(systemEnvironment) != 2) continue;
                ((SDMSResourceAllocation)object).delete(systemEnvironment, true, true);
            }
            Vector vector4 = SDMSRunnableQueueTable.idx_smeId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector4.size(); ++i) {
                sDMSRunnableQueue = (SDMSRunnableQueue)vector4.get(i);
                if (sDMSRunnableQueue.getState(systemEnvironment) == 4) continue;
                sDMSRunnableQueue.delete(systemEnvironment);
            }
            sDMSSubmittedEntity.setState(systemEnvironment, SDMSConstants.SME_RUNNABLE);
            SystemEnvironment.notifier.addJobServerToNotify(sDMSScope.getId(systemEnvironment));
        } else {
            this.checkTimeout(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, l2);
        }
    }

    public static boolean fits(SystemEnvironment systemEnvironment, HashMap hashMap, HashMap hashMap2, SDMSSubmittedEntity sDMSSubmittedEntity, boolean bl, SDMSScope sDMSScope) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 2) {
            LockingSystem.lock(systemEnvironment, SystemEnvironment.sched, 1);
        }
        for (Long l : hashMap2.keySet()) {
            Object object;
            SDMSEnvironment sDMSEnvironment;
            SDMSResourceRequirement sDMSResourceRequirement;
            if (!hashMap.containsKey(l)) {
                return false;
            }
            SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, (Long)hashMap.get(l));
            Integer n = sDMSResource.getRequestableAmount(systemEnvironment);
            SDMSProxy sDMSProxy = (SDMSProxy)hashMap2.get(l);
            if (sDMSProxy instanceof SDMSResourceRequirement) {
                sDMSResourceRequirement = (SDMSResourceRequirement)sDMSProxy;
                sDMSEnvironment = null;
            } else {
                sDMSEnvironment = (SDMSEnvironment)sDMSProxy;
                sDMSResourceRequirement = null;
            }
            if (bl) {
                Object object2 = object = sDMSResourceRequirement == null ? sDMSEnvironment.getCondition(systemEnvironment) : sDMSResourceRequirement.getCondition(systemEnvironment);
                if (object != null) {
                    BoolExpr boolExpr = new BoolExpr((String)object);
                    try {
                        if (!boolExpr.checkCondition(systemEnvironment, sDMSResource, sDMSSubmittedEntity, sDMSSubmittedEntity, null, null, sDMSScope)) {
                            return false;
                        }
                    }
                    catch (CommonErrorException commonErrorException) {
                        if (systemEnvironment.tx.mode == 2) {
                            SDMSNamedResource sDMSNamedResource = sDMSResourceRequirement != null ? SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceRequirement.getNrId(systemEnvironment)) : SDMSNamedResourceTable.getObject(systemEnvironment, sDMSEnvironment.getNrId(systemEnvironment));
                            String string = commonErrorException.toString() + " evaluating the condition for resource " + sDMSNamedResource.pathString(systemEnvironment);
                            sDMSSubmittedEntity.setWarn(systemEnvironment, SDMSConstants.AT_JOB_IN_ERROR, string, new Date().getTime());
                        }
                        return false;
                    }
                }
            }
            object = sDMSResourceRequirement == null ? SDMSConstants.iONE : sDMSResourceRequirement.getAmount(systemEnvironment);
            if (n == null || ((Integer)object).compareTo(n) <= 0) continue;
            return false;
        }
        return true;
    }

    private static boolean verboseFits(SystemEnvironment systemEnvironment, HashMap hashMap, HashMap hashMap2, SDMSSubmittedEntity sDMSSubmittedEntity, boolean bl, SDMSScope sDMSScope) throws SDMSException {
        for (Long l : hashMap2.keySet()) {
            Object object;
            SDMSEnvironment sDMSEnvironment;
            SDMSResourceRequirement sDMSResourceRequirement;
            if (!hashMap.containsKey(l)) {
                return false;
            }
            SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, (Long)hashMap.get(l));
            Integer n = sDMSResource.getRequestableAmount(systemEnvironment);
            SDMSProxy sDMSProxy = (SDMSProxy)hashMap2.get(l);
            if (sDMSProxy instanceof SDMSResourceRequirement) {
                sDMSResourceRequirement = (SDMSResourceRequirement)sDMSProxy;
                sDMSEnvironment = null;
            } else {
                sDMSEnvironment = (SDMSEnvironment)sDMSProxy;
                sDMSResourceRequirement = null;
            }
            if (bl) {
                Object object2 = object = sDMSResourceRequirement == null ? sDMSEnvironment.getCondition(systemEnvironment) : sDMSResourceRequirement.getCondition(systemEnvironment);
                if (object != null) {
                    BoolExpr boolExpr = new BoolExpr((String)object);
                    try {
                        if (!boolExpr.checkCondition(systemEnvironment, sDMSResource, sDMSSubmittedEntity, sDMSSubmittedEntity, null, null, sDMSScope)) {
                            return false;
                        }
                    }
                    catch (CommonErrorException commonErrorException) {
                        SDMSNamedResource sDMSNamedResource = sDMSResourceRequirement != null ? SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceRequirement.getNrId(systemEnvironment)) : SDMSNamedResourceTable.getObject(systemEnvironment, sDMSEnvironment.getNrId(systemEnvironment));
                        String string = commonErrorException.toString() + " evaluating the condition for resource " + sDMSNamedResource.pathString(systemEnvironment);
                        sDMSSubmittedEntity.setWarn(systemEnvironment, SDMSConstants.AT_JOB_IN_ERROR, string, new Date().getTime());
                        return false;
                    }
                }
            }
            object = sDMSResourceRequirement == null ? SDMSConstants.iZERO : sDMSResourceRequirement.getAmount(systemEnvironment);
            if (n == null || ((Integer)object).compareTo(n) <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean checkStaticResources(SystemEnvironment systemEnvironment, HashMap hashMap, HashMap hashMap2) throws SDMSException {
        for (Long l : hashMap2.keySet()) {
            if (!hashMap.containsKey(l)) {
                return false;
            }
            SDMSResource sDMSResource = SDMSResourceTable.getObjectForUpdate(systemEnvironment, (Long)hashMap.get(l));
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResource.getNrId(systemEnvironment));
            if (sDMSNamedResource.getUsage(systemEnvironment) != 1 || sDMSResource.getIsOnline(systemEnvironment).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean reserveSyncResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity, long l, HashMap hashMap, Locklist locklist, Iterator iterator) throws SDMSException {
        Long l2 = sDMSSubmittedEntity.getId(systemEnvironment);
        SDMSResourceAllocation sDMSResourceAllocation = null;
        SDMSResourceAllocation sDMSResourceAllocation2 = null;
        boolean bl = true;
        Reservator reservator = null;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            Vector<SDMSResourceAllocation> vector = new Vector<SDMSResourceAllocation>();
            while (iterator.hasNext()) {
                SDMSResourceRequirement sDMSResourceRequirement;
                Long l3;
                SDMSNamedResource sDMSNamedResource;
                SDMSProxy sDMSProxy = (SDMSProxy)iterator.next();
                if (!(sDMSProxy instanceof SDMSResourceRequirement) || (sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l3 = (sDMSResourceRequirement = (SDMSResourceRequirement)sDMSProxy).getNrId(systemEnvironment))).getUsage(systemEnvironment) != 4) continue;
                SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, (Long)hashMap.get(l3));
                Long l4 = sDMSResource.getId(systemEnvironment);
                try {
                    sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(l2, l4, (Comparable)((Object)sDMSResourceRequirement.getStickyName(systemEnvironment))));
                }
                catch (NotFoundException notFoundException) {
                    if (SDMSResourceAllocationTable.idx_smeId_rId_stickyName.containsKey(systemEnvironment, new SDMSKey(l2, l3, (Comparable)((Object)sDMSResourceRequirement.getStickyName(systemEnvironment))))) continue;
                    SchedulingThread.doTrace(this.cEnv, ": Job " + l2 + " needs a resource " + l3 + "/" + l4 + " which is neither requested/reserved/allocated nor ignored", -1);
                    continue;
                }
                int n = sDMSResourceAllocation.getAllocationType(systemEnvironment);
                if (n == 5 || n == 2 || n == 4 || SDMSResourceAllocationTable.idx_smeId_rId_stickyName.containsKey(systemEnvironment, new SDMSKey(l2, l3, (Comparable)((Object)sDMSResourceRequirement.getStickyName(systemEnvironment))))) continue;
                if (locklist != null) {
                    reservator = locklist.get(l4);
                }
                reservator = reservator == null ? new Reservator(l4, l2) : new Reservator(l4, l2, reservator.amount, reservator.lock.getLockmode());
                boolean bl2 = sDMSResourceRequirement.getIsSticky(systemEnvironment);
                if (bl2) {
                    Long l5 = sDMSResourceAllocation.getStickyParent(systemEnvironment);
                    Long l6 = -l5.longValue();
                    String string = sDMSResourceRequirement.getStickyName(systemEnvironment);
                    try {
                        sDMSResourceAllocation2 = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(l6, l4, (Comparable)((Object)string)));
                    }
                    catch (NotFoundException notFoundException) {
                        sDMSResourceAllocation2 = this.createUpgradeMasterRequest(systemEnvironment, sDMSSubmittedEntity, sDMSResourceRequirement, sDMSResource, l);
                    }
                    MasterReservationInfo masterReservationInfo = this.checkMasterReservation(systemEnvironment, sDMSSubmittedEntity, sDMSResourceRequirement, l5, sDMSResource, reservator);
                    if (masterReservationInfo.mustAllocate && locklist != null) {
                        locklist.set(new Reservator(l4, l6, masterReservationInfo.amount, masterReservationInfo.lockmode));
                        vector.add(sDMSResourceAllocation2);
                    }
                    if (!masterReservationInfo.canAllocate) {
                        if (locklist != null) {
                            bl = false;
                            continue;
                        }
                        throw new SDMSEscape();
                    }
                    if (masterReservationInfo.mustAllocate) {
                        sDMSResourceAllocation2.setAllocationType(systemEnvironment, SDMSConstants.RA_MASTER_RESERVATION);
                    }
                }
                int n2 = reservator.amount;
                Lockmode lockmode = reservator.lock;
                int n3 = sDMSResource.checkAllocate(systemEnvironment, sDMSResourceRequirement, sDMSSubmittedEntity, sDMSResourceAllocation, n2, lockmode);
                if (locklist != null) {
                    locklist.set(new Reservator(l4, l2, (int)sDMSResourceRequirement.getAmount(systemEnvironment), sDMSResourceRequirement.getLockmode(systemEnvironment)));
                }
                if (n3 != 0) {
                    if (locklist == null) {
                        throw new SDMSEscape();
                    }
                    if ((n3 & 0x1C) != 0) {
                        locklist.removeSme(l2);
                        throw new SDMSEscape();
                    }
                    bl = false;
                    continue;
                }
                sDMSResourceAllocation.setAllocationType(systemEnvironment, SDMSConstants.RA_RESERVATION);
                if (!bl2) continue;
                int n4 = sDMSResourceAllocation2.getAmount(systemEnvironment);
                int n5 = sDMSResourceAllocation.getAmount(systemEnvironment);
                sDMSResourceAllocation2.setAmount(systemEnvironment, n4 - n5);
            }
            if (!bl) {
                throw new SDMSEscape();
            }
            if (locklist != null) {
                locklist.removeSme(l2);
                for (int i = 0; i < vector.size(); ++i) {
                    sDMSResourceAllocation2 = (SDMSResourceAllocation)vector.get(i);
                    locklist.remove(sDMSResourceAllocation2.getRId(systemEnvironment), sDMSResourceAllocation2.getSmeId(systemEnvironment));
                }
            }
        }
        catch (SDMSEscape sDMSEscape) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            return false;
        }
        systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        return true;
    }

    private boolean reserveFp(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity, Locklist locklist, HashMap hashMap, int n) throws SDMSException {
        HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
        Vector vector = new Vector();
        for (Vector vector2 : hashMap.values()) {
            SDMSResource sDMSResource = (SDMSResource)vector2.get(1);
            hashMap2.put(sDMSResource.getNrId(systemEnvironment), sDMSResource.getId(systemEnvironment));
            vector.add(vector2.get(0));
        }
        if (vector.size() == 0) {
            return true;
        }
        if (n == 2) {
            return this.reserveSysResources(systemEnvironment, sDMSSubmittedEntity, hashMap2, locklist, vector.iterator());
        }
        return this.reserveSyncResources(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, sDMSSubmittedEntity.getSeVersion(systemEnvironment), hashMap2, locklist, vector.iterator());
    }

    private SDMSResourceAllocation createUpgradeMasterRequest(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSResourceRequirement sDMSResourceRequirement, SDMSResource sDMSResource, long l) throws SDMSException {
        SDMSResourceAllocation sDMSResourceAllocation;
        Long l2 = sDMSResourceRequirement.getNrId(systemEnvironment);
        Long l3 = sDMSResource.getId(systemEnvironment);
        Long l4 = null;
        float f = 1.0f;
        f = sDMSResource.getFactor(systemEnvironment).floatValue();
        int n = 255;
        int n2 = 0;
        int n3 = 0;
        Vector vector = SDMSSubmittedEntityTable.idx_masterId.getVectorForUpdate(systemEnvironment, sDMSSubmittedEntity.getMasterId(systemEnvironment));
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceRequirement sDMSResourceRequirement2;
            SDMSSubmittedEntity sDMSSubmittedEntity2 = (SDMSSubmittedEntity)vector.get(i);
            int n4 = sDMSSubmittedEntity2.getState(systemEnvironment);
            if (n4 != 0 && n4 != 1 && n4 != 2 || sDMSSubmittedEntity2.getJobIsFinal(systemEnvironment).booleanValue()) continue;
            l4 = sDMSSubmittedEntity2.getSeId(systemEnvironment);
            try {
                sDMSResourceRequirement2 = SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(l4, l2), l);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            if (!sDMSResourceRequirement2.getIsSticky(systemEnvironment).booleanValue()) continue;
            try {
                sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(sDMSSubmittedEntity2.getId(systemEnvironment), l3, null));
                if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 5) {
                    continue;
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            ++n3;
            n &= sDMSResourceRequirement2.getLockmode(systemEnvironment).intValue();
            int n5 = sDMSResourceRequirement2.getAmount(systemEnvironment);
            if (n5 <= n2) continue;
            n2 = n5;
        }
        sDMSResourceAllocation = SDMSResourceAllocationTable.table.create(systemEnvironment, l3, -sDMSSubmittedEntity.getMasterId(systemEnvironment).longValue(), l2, n2, n2, sDMSResourceRequirement.getKeepMode(systemEnvironment), Boolean.TRUE, null, sDMSSubmittedEntity.getMasterId(systemEnvironment), SDMSConstants.RA_MASTER_REQUEST, null, n, n3);
        return sDMSResourceAllocation;
    }

    public MasterReservationInfo checkMasterReservation(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSResourceRequirement sDMSResourceRequirement, Long l, SDMSResource sDMSResource) throws SDMSException {
        return this.checkMasterReservation(systemEnvironment, sDMSSubmittedEntity, sDMSResourceRequirement, l, sDMSResource, new Reservator(sDMSResource.getId(systemEnvironment), sDMSSubmittedEntity.getId(systemEnvironment)));
    }

    public MasterReservationInfo checkMasterReservation(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSResourceRequirement sDMSResourceRequirement, Long l, SDMSResource sDMSResource, Reservator reservator) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 2) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        Long l2 = sDMSResourceRequirement.getNrId(systemEnvironment);
        Long l3 = sDMSResource.getId(systemEnvironment);
        MasterReservationInfo masterReservationInfo = new MasterReservationInfo();
        SDMSResourceAllocation sDMSResourceAllocation = null;
        float f = 1.0f;
        String string = sDMSResourceRequirement.getStickyName(systemEnvironment);
        Long l4 = -l.longValue();
        masterReservationInfo.stickyName = string;
        masterReservationInfo.stickyParent = l;
        f = sDMSResource.getFactor(systemEnvironment).floatValue();
        int n = 255;
        boolean bl = false;
        try {
            sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUnique(systemEnvironment, new SDMSKey(l4, l3, (Comparable)((Object)string)));
            masterReservationInfo.amount = sDMSResourceAllocation.getAmount(systemEnvironment);
            masterReservationInfo.lockmode = sDMSResourceAllocation.getLockmode(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            return masterReservationInfo;
        }
        if (sDMSResourceAllocation.getAllocationType(systemEnvironment) == 3) {
            masterReservationInfo.mustAllocate = false;
            masterReservationInfo.canAllocate = true;
            return masterReservationInfo;
        }
        int n2 = (int)Math.ceil((float)masterReservationInfo.amount * f);
        if (!sDMSResource.checkAmount(systemEnvironment, n2, masterReservationInfo.amount, reservator.amount)) {
            masterReservationInfo.mustAllocate = false;
            masterReservationInfo.canAllocate = false;
            return masterReservationInfo;
        }
        if (!sDMSResource.syncCheckLockmode(systemEnvironment, masterReservationInfo.lockmode, reservator.lock)) {
            masterReservationInfo.mustAllocate = false;
            masterReservationInfo.canAllocate = false;
            return masterReservationInfo;
        }
        masterReservationInfo.mustAllocate = true;
        masterReservationInfo.canAllocate = true;
        masterReservationInfo.amount = n2;
        masterReservationInfo.lockmode = n;
        return masterReservationInfo;
    }

    private boolean reserveSysResources(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, HashMap hashMap, Locklist locklist, Iterator iterator) throws SDMSException {
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Reservator reservator = null;
        boolean bl = true;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            while (iterator.hasNext()) {
                Lockmode lockmode;
                int n;
                int n2;
                SDMSResourceRequirement sDMSResourceRequirement;
                Long l2;
                SDMSNamedResource sDMSNamedResource;
                SDMSProxy sDMSProxy = (SDMSProxy)iterator.next();
                if (!(sDMSProxy instanceof SDMSResourceRequirement) || (sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2 = (sDMSResourceRequirement = (SDMSResourceRequirement)sDMSProxy).getNrId(systemEnvironment))).getUsage(systemEnvironment) != 2) continue;
                SDMSResource sDMSResource = SDMSResourceTable.getObjectForUpdate(systemEnvironment, (Long)hashMap.get(l2));
                Long l3 = sDMSResource.getId(systemEnvironment);
                SDMSResourceAllocation sDMSResourceAllocation = null;
                try {
                    sDMSResourceAllocation = SDMSResourceAllocationTable.idx_smeId_rId_stickyName_getUniqueForUpdate(systemEnvironment, new SDMSKey(l, l3, null));
                }
                catch (NotFoundException notFoundException) {
                    if (SDMSResourceAllocationTable.idx_smeId_rId_stickyName.containsKey(systemEnvironment, new SDMSKey(l, l2, null))) continue;
                    SchedulingThread.doTrace(this.cEnv, ": Job " + l + " needs a resource " + l2 + "/" + l3 + " which is neither requested/reserved/allocated nor ignored", -1);
                    continue;
                }
                int n3 = sDMSResourceAllocation.getAllocationType(systemEnvironment);
                if (n3 == 5 || n3 == 2 || n3 == 4) continue;
                if (locklist != null) {
                    reservator = locklist.get(l3);
                }
                if (reservator == null) {
                    reservator = new Reservator(l3, l);
                }
                if ((n2 = sDMSResource.checkAllocate(systemEnvironment, sDMSResourceRequirement, sDMSSubmittedEntity, sDMSResourceAllocation, n = reservator.amount, lockmode = reservator.lock)) != 0) {
                    if (locklist != null && n2 != 16) {
                        locklist.set(new Reservator(l3, l, (int)sDMSResourceRequirement.getAmount(systemEnvironment), 255));
                        bl = false;
                        continue;
                    }
                    throw new SDMSEscape();
                }
                sDMSResourceAllocation.setAllocationType(systemEnvironment, SDMSConstants.RA_RESERVATION);
            }
            if (!bl) {
                throw new SDMSEscape();
            }
            if (locklist != null) {
                locklist.removeSme(l);
            }
        }
        catch (SDMSEscape sDMSEscape) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            return false;
        }
        systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        return true;
    }

    private void merge(HashMap hashMap, HashMap hashMap2) {
        for (Long l : hashMap2.keySet()) {
            if (hashMap.containsKey(l)) continue;
            hashMap.put(l, hashMap2.get(l));
        }
    }

    public HashMap getScopeFootprint(SystemEnvironment systemEnvironment, SDMSScope sDMSScope) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 2) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        Long l = sDMSScope.getId(systemEnvironment);
        Vector vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResource sDMSResource = (SDMSResource)vector.get(i);
            hashMap.put(sDMSResource.getNrId(systemEnvironment), sDMSResource.getId(systemEnvironment));
        }
        Long l2 = sDMSScope.getParentId(systemEnvironment);
        if (l2 != null) {
            SDMSScope sDMSScope2 = SDMSScopeTable.getObject(systemEnvironment, l2);
            HashMap hashMap2 = this.getScopeFootprint(systemEnvironment, sDMSScope2);
            this.merge(hashMap, hashMap2);
        }
        return hashMap;
    }

    public static Vector getJobFootprint(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1 && systemEnvironment.tx.mode == 2) {
            LockingSystem.lock(systemEnvironment, SystemEnvironment.sched, 1);
        }
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        try {
            SDMSnpJobFootprint sDMSnpJobFootprint = SDMSnpJobFootprintTable.idx_smeId_getUniqueForUpdate(systemEnvironment, l);
            Vector<HashMap> vector = new Vector<HashMap>();
            vector.add(sDMSnpJobFootprint.getFpScope(systemEnvironment));
            vector.add(sDMSnpJobFootprint.getFpFolder(systemEnvironment));
            vector.add(sDMSnpJobFootprint.getFpLocal(systemEnvironment));
            return vector;
        }
        catch (NotFoundException notFoundException) {
            SDMSResourceRequirement sDMSResourceRequirement;
            int n;
            SDMSFolder sDMSFolder;
            SDMSEnvironment sDMSEnvironment;
            HashMap<Long, SDMSProxy> hashMap = new HashMap<Long, SDMSProxy>();
            Long l2 = sDMSSubmittedEntity.getSeId(systemEnvironment);
            long l3 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2, l3);
            Vector vector = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, (Object)sDMSSchedulingEntity.getNeId(systemEnvironment), l3);
            for (int i = 0; i < vector.size(); ++i) {
                sDMSEnvironment = (SDMSEnvironment)vector.get(i);
                hashMap.put(sDMSEnvironment.getNrId(systemEnvironment), sDMSEnvironment);
            }
            Long l4 = sDMSSchedulingEntity.getFolderId(systemEnvironment);
            do {
                Long l5;
                if ((l5 = (sDMSFolder = SDMSFolderTable.getObject(systemEnvironment, l4, l3)).getEnvId(systemEnvironment)) == null) continue;
                vector = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, (Object)l5, l3);
                for (int i = 0; i < vector.size(); ++i) {
                    sDMSEnvironment = (SDMSEnvironment)vector.get(i);
                    hashMap.put(sDMSEnvironment.getNrId(systemEnvironment), sDMSEnvironment);
                }
            } while ((l4 = sDMSFolder.getParentId(systemEnvironment)) != null);
            vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, (Object)sDMSSchedulingEntity.getFpId(systemEnvironment), l3);
            for (n = 0; n < vector.size(); ++n) {
                sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(n);
                hashMap.put(sDMSResourceRequirement.getNrId(systemEnvironment), sDMSResourceRequirement);
            }
            vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, (Object)l2, l3);
            for (n = 0; n < vector.size(); ++n) {
                sDMSResourceRequirement = (SDMSResourceRequirement)vector.get(n);
                hashMap.put(sDMSResourceRequirement.getNrId(systemEnvironment), sDMSResourceRequirement);
            }
            return SystemEnvironment.sched.splitSmeFootprint(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity, hashMap, l);
        }
    }

    private Vector splitSmeFootprint(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity, HashMap hashMap, Long l) throws SDMSException {
        HashMap<Long, Serializable> hashMap2 = new HashMap<Long, Serializable>();
        HashMap<Long, Serializable> hashMap3 = new HashMap<Long, Serializable>();
        HashMap<Long, SDMSProxy> hashMap4 = new HashMap<Long, SDMSProxy>();
        Vector<HashMap<Long, Object>> vector = new Vector<HashMap<Long, Object>>();
        SDMSKey sDMSKey = null;
        Vector<SDMSKey> vector2 = null;
        long l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        if (systemEnvironment.tx.rscCache == null) {
            systemEnvironment.tx.rscCache = new HashMap();
        }
        HashMap hashMap5 = systemEnvironment.tx.rscCache;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            SDMSResource sDMSResource;
            Serializable serializable;
            Long l3;
            boolean bl;
            SDMSResource sDMSResource2 = null;
            Long l4 = null;
            Long l5 = null;
            Long l6 = (Long)iterator.next();
            SDMSProxy sDMSProxy = (SDMSProxy)hashMap.get(l6);
            SDMSResourceRequirement sDMSResourceRequirement = sDMSProxy instanceof SDMSResourceRequirement ? (SDMSResourceRequirement)sDMSProxy : null;
            if (sDMSResourceRequirement == null) {
                sDMSProxy.fix();
                hashMap4.put(l6, sDMSProxy);
                continue;
            }
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l6);
            if (sDMSNamedResource.getUsage(systemEnvironment) == 1) {
                sDMSResourceRequirement.fix();
                hashMap4.put(l6, sDMSResourceRequirement);
                continue;
            }
            SDMSSchedulingEntity sDMSSchedulingEntity2 = sDMSSchedulingEntity;
            SDMSSubmittedEntity sDMSSubmittedEntity2 = sDMSSubmittedEntity;
            while (true) {
                bl = false;
                l3 = sDMSSchedulingEntity2.getFolderId(systemEnvironment);
                long l7 = sDMSSubmittedEntity2.getSeVersion(systemEnvironment);
                vector2 = new Vector<SDMSKey>();
                while (l3 != null) {
                    sDMSKey = new SDMSKey(l6, l3);
                    if (hashMap5.containsKey(sDMSKey)) {
                        SchedulingThread.doTrace(this.cEnv, "Cache hit for folder " + sDMSKey, 3);
                        bl = true;
                        serializable = (Vector)hashMap5.get(sDMSKey);
                        if (serializable == null) {
                            l5 = null;
                            break;
                        }
                        sDMSResource2 = (SDMSResource)((Vector)serializable).get(0);
                        l5 = (Long)((Vector)serializable).get(1);
                        break;
                    }
                    SchedulingThread.doTrace(this.cEnv, "Cache miss for folder " + sDMSKey, 3);
                    try {
                        sDMSResource2 = sDMSResource = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, sDMSKey);
                        l5 = l3;
                        serializable = new Vector();
                        sDMSResource.fix();
                        ((Vector)serializable).add(sDMSResource);
                        ((Vector)serializable).add(l3);
                        hashMap5.put(sDMSKey, serializable);
                        for (int i = 0; i < vector2.size(); ++i) {
                            hashMap5.put(vector2.get(i), serializable);
                        }
                        break;
                    }
                    catch (NotFoundException notFoundException) {
                        l3 = SDMSFolderTable.getObject(systemEnvironment, l3, l7).getParentId(systemEnvironment);
                        vector2.add(sDMSKey);
                    }
                }
                if (l5 != null) break;
                SchedulingThread.doTrace(this.cEnv, "No folder Resource found for " + sDMSKey, 3);
                if (!bl) {
                    for (int i = 0; i < vector2.size(); ++i) {
                        hashMap5.put(vector2.get(i), null);
                    }
                }
                if ((serializable = sDMSSubmittedEntity2.getParentId(systemEnvironment)) == null) break;
                sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, (Long)serializable);
                sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity2.getSeId(systemEnvironment), l7);
            }
            l3 = l;
            vector2 = new Vector();
            bl = false;
            while (l3 != null) {
                sDMSKey = new SDMSKey(l6, l3);
                if (hashMap5.containsKey(sDMSKey)) {
                    SchedulingThread.doTrace(this.cEnv, "Cache hit for sme " + sDMSKey, 3);
                    bl = true;
                    Vector vector3 = (Vector)hashMap5.get(sDMSKey);
                    if (vector3 == null) {
                        l4 = null;
                        break;
                    }
                    sDMSResource2 = (SDMSResource)vector3.get(0);
                    l4 = (Long)vector3.get(1);
                    break;
                }
                try {
                    SchedulingThread.doTrace(this.cEnv, "Cache miss for sme " + sDMSKey, 3);
                    sDMSResource2 = sDMSResource = SDMSResourceTable.idx_nrId_scopeId_getUnique(systemEnvironment, sDMSKey);
                    l4 = l3;
                    Vector<Comparable> vector4 = new Vector<Comparable>();
                    sDMSResource.fix();
                    vector4.add(sDMSResource);
                    vector4.add(l3);
                    hashMap5.put(sDMSKey, vector4);
                    for (int i = 0; i < vector2.size(); ++i) {
                        hashMap5.put(vector2.get(i), vector4);
                    }
                    break;
                }
                catch (NotFoundException notFoundException) {
                    l3 = SDMSSubmittedEntityTable.getObject(systemEnvironment, l3).getParentId(systemEnvironment);
                    vector2.add(sDMSKey);
                }
            }
            if (l4 == null && !bl) {
                SchedulingThread.doTrace(this.cEnv, "No sme Resource found for " + sDMSKey, 3);
                for (int i = 0; i < vector2.size(); ++i) {
                    hashMap5.put(vector2.get(i), null);
                }
            }
            if (l4 != null || l5 != null) {
                Integer n = sDMSResource2.getRequestableAmount(systemEnvironment);
                Integer n2 = sDMSResourceRequirement.getAmount(systemEnvironment);
                if (n != null && n.compareTo(n2) < 0 && systemEnvironment.tx.mode == 2) {
                    sDMSSubmittedEntity.setToError(systemEnvironment, "Job cannot run because of resource shortage on resource " + sDMSNamedResource.pathString(systemEnvironment));
                }
                serializable = new Vector();
                sDMSResourceRequirement.fix();
                ((Vector)serializable).add(sDMSResourceRequirement);
                sDMSResource2.fix();
                ((Vector)serializable).add(sDMSResource2);
                if (l4 != null) {
                    hashMap3.put(l6, serializable);
                    continue;
                }
                hashMap2.put(l6, serializable);
                continue;
            }
            sDMSResourceRequirement.fix();
            hashMap4.put(l6, sDMSResourceRequirement);
        }
        if (systemEnvironment.tx.mode == 2) {
            SDMSnpJobFootprintTable.table.create(systemEnvironment, l, hashMap4, hashMap2, hashMap3);
        }
        vector.add(hashMap4);
        vector.add(hashMap2);
        vector.add(hashMap3);
        return vector;
    }

    void recalc_sfp(SystemEnvironment systemEnvironment, Long l, SDMSScope sDMSScope) throws SDMSException {
        SchedulingThread.doTrace(this.cEnv, "Calculating footprint for scope " + sDMSScope.pathString(systemEnvironment), 3);
        if (sDMSScope.getType(systemEnvironment) == 2) {
            HashMap hashMap = this.getScopeFootprint(systemEnvironment, sDMSScope);
            SchedulingThread.doTrace(this.cEnv, "footprint = " + hashMap.toString(), 3);
            SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, l).setFp(systemEnvironment, hashMap);
        } else {
            Vector vector = SDMSScopeTable.idx_parentId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                sDMSScope = (SDMSScope)vector.get(i);
                this.recalc_sfp(systemEnvironment, sDMSScope.getId(systemEnvironment), sDMSScope);
            }
        }
    }

    void destroyEnvironment(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSnpSrvrSRFootprintTable.table.clearTableUnlocked(systemEnvironment);
    }

    void buildEnvironment(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        Vector vector = SDMSScopeTable.idx_type.getVector(systemEnvironment, SDMSConstants.S_SERVER);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSScope sDMSScope = (SDMSScope)vector.get(i);
            SDMSnpSrvrSRFootprintTable.table.create(systemEnvironment, sDMSScope.getId(systemEnvironment), null, this.getScopeFootprint(systemEnvironment, sDMSScope));
        }
        if (!bl) {
            SDMSSchedulingEntity sDMSSchedulingEntity;
            SDMSSubmittedEntity sDMSSubmittedEntity;
            int n;
            Vector<Long> vector2 = new Vector<Long>();
            vector = SDMSSubmittedEntityTable.idx_state.getVector(systemEnvironment, SDMSConstants.SME_DEPENDENCY_WAIT);
            for (n = 0; n < vector.size(); ++n) {
                sDMSSubmittedEntity = (SDMSSubmittedEntity)vector.get(n);
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                if (sDMSSchedulingEntity.getType(systemEnvironment) != 1 || sDMSSubmittedEntity.getOldState(systemEnvironment) == null) continue;
                vector2.add(sDMSSubmittedEntity.getId(systemEnvironment));
            }
            vector = SDMSSubmittedEntityTable.idx_state.getVector(systemEnvironment, SDMSConstants.SME_SYNCHRONIZE_WAIT);
            for (n = 0; n < vector.size(); ++n) {
                sDMSSubmittedEntity = (SDMSSubmittedEntity)vector.get(n);
                sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment));
                if (sDMSSchedulingEntity.getType(systemEnvironment) != 1 || sDMSSubmittedEntity.getOldState(systemEnvironment) == null) continue;
                vector2.add(sDMSSubmittedEntity.getId(systemEnvironment));
            }
            this.addToRequestList(vector2);
        }
        this.needSched = true;
    }

    public void requestSchedule() {
        this.needSched = true;
        this.wakeUp();
    }

    public void notifyChange(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, Long l, int n) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this, 1);
        }
        if (l != null) {
            SDMSScope sDMSScope = null;
            try {
                sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (sDMSScope != null) {
                this.recalc_sfp(systemEnvironment, l, sDMSScope);
            }
        }
        switch (n) {
            case 1: {
                this.needReSched = true;
                break;
            }
            case 2: {
                break;
            }
            case 15: {
                this.needReSched = true;
                break;
            }
            case 16: {
                this.needReSched = true;
                break;
            }
            case 3: {
                this.needReSched = true;
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03202252140", "Unknown change code $1", n));
            }
        }
        this.needSched = true;
    }

    public void notifyChange(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource, int n) throws SDMSException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03203060018", "Unknown change code $1", n));
            }
        }
        this.needSched = true;
    }

    public void notifyChange(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, int n) throws SDMSException {
        switch (n) {
            case 1: {
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, this, 1);
                }
                SDMSnpSrvrSRFootprintTable.table.create(systemEnvironment, sDMSScope.getId(systemEnvironment), null, this.getScopeFootprint(systemEnvironment, sDMSScope));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, this, 1);
                }
                SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = SDMSnpSrvrSRFootprintTable.idx_sId_getUnique(systemEnvironment, sDMSScope.getId(systemEnvironment));
                sDMSnpSrvrSRFootprint.delete(systemEnvironment);
                this.needReSched = true;
                break;
            }
            case 4: 
            case 5: 
            case 19: 
            case 20: {
                this.needReSched = true;
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.needSched = true;
                break;
            }
            case 11: 
            case 13: {
                if (SystemEnvironment.maxWriter > 1) {
                    LockingSystem.lock(systemEnvironment, this, 1);
                }
                this.destroyEnvironment(systemEnvironment);
                this.buildEnvironment(systemEnvironment, true);
                this.needSched = true;
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03202252142", "Unknown change code $1", n));
            }
        }
        this.needSched = true;
    }

    public void notifyChange(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, int n) throws SDMSException {
        switch (n) {
            case 6: {
                break;
            }
            case 10: {
                int n2 = sDMSSubmittedEntity.getState(systemEnvironment);
                switch (n2) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        Vector vector = SDMSRunnableQueueTable.idx_smeId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
                        int n3 = vector.size();
                        for (int i = 0; i < n3; ++i) {
                            SDMSRunnableQueue sDMSRunnableQueue = (SDMSRunnableQueue)vector.get(i);
                            sDMSRunnableQueue.delete(systemEnvironment);
                        }
                        break;
                    }
                }
                this.needSched = true;
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                this.needSched = true;
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03202252317", "Unknown change code $1", n));
            }
        }
    }

    public void requestReschedule() {
        this.needReSched = true;
    }
}

