/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.DoCheckTrigger;
import de.independit.scheduler.server.InternalSession;
import de.independit.scheduler.server.SDMSConstants;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerQueue;
import de.independit.scheduler.server.repository.SDMSTriggerQueueProxyGeneric;
import de.independit.scheduler.server.repository.SDMSTriggerQueueTable;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import de.independit.scheduler.server.util.LockableHashSet;
import de.independit.scheduler.server.util.SDMSFilter;
import de.independit.scheduler.server.util.SyncFifo;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class TriggerThread
extends InternalSession {
    public static final String __version = "@(#) $Id: TriggerThread.java,v 2.11.6.3 2013/09/11 11:50:39 ronald Exp $";
    public static final String name = "TriggerThread";
    private long nextTime;
    private int maxWakeupInterval;
    private LockableHashSet jobsToResume;
    private boolean firstTime;

    public TriggerThread(SystemEnvironment systemEnvironment, SyncFifo syncFifo) throws SDMSException {
        super(name);
        this.NR = 1234323;
        this.maxWakeupInterval = SystemEnvironment.ttWakeupInterval * 1000;
        this.initThread(systemEnvironment, syncFifo, this.NR, name, this.maxWakeupInterval);
        this.jobsToResume = new LockableHashSet();
        this.firstTime = true;
    }

    @Override
    protected Node getNode(int n) {
        if (n == 1) {
            return new DoCheckTrigger(1);
        }
        return new DoCheckTrigger();
    }

    public void checkTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        Long l;
        Object object2;
        long l2 = System.currentTimeMillis();
        this.nextTime = Long.MAX_VALUE;
        int n = 0;
        TriggerThread.doTrace(this.cEnv, "Start Trigger Check", 2);
        Iterator iterator = SDMSTriggerQueueTable.table.iterator(systemEnvironment, false);
        while (iterator.hasNext()) {
            object2 = (SDMSTriggerQueue)iterator.next();
            ++n;
            try {
                this.checkSingleTrigger(systemEnvironment, (SDMSTriggerQueue)object2, l2);
            }
            catch (SerializationException serializationException) {
                throw serializationException;
            }
            catch (SDMSException sDMSException) {
                Long l3 = ((SDMSTriggerQueueProxyGeneric)object2).getTrId(systemEnvironment);
                l = ((SDMSTriggerQueueProxyGeneric)object2).getSmeId(systemEnvironment);
                TriggerThread.doTrace(this.cEnv, "Error while processing Trigger " + l3 + " for Submitted Entity " + l + " : " + sDMSException.toString(), -1);
            }
        }
        TriggerThread.doTrace(this.cEnv, "End Trigger Check (" + n + " triggers checked)", 2);
        TriggerThread.doTrace(this.cEnv, "Start Resuming Jobs", 2);
        n = 0;
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this.jobsToResume, 1);
        }
        if (this.firstTime) {
            iterator = SDMSSubmittedEntityTable.table.iterator(systemEnvironment, new SDMSFilter(){

                @Override
                public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                    SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
                    if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 0) {
                        return false;
                    }
                    return sDMSSubmittedEntity.getResumeTs(systemEnvironment) != null;
                }
            });
            while (iterator.hasNext()) {
                object2 = (SDMSSubmittedEntity)iterator.next();
                if (((SDMSSubmittedEntityProxyGeneric)object2).getIsSuspended(systemEnvironment) == 0 || (object = ((SDMSSubmittedEntityProxyGeneric)object2).getResumeTs(systemEnvironment)) == null) continue;
                this.jobsToResume.add(((SDMSProxy)object2).getId(systemEnvironment));
            }
            this.firstTime = false;
        }
        object2 = new Vector();
        try {
            object = this.jobsToResume.toArray();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                SDMSSubmittedEntity sDMSSubmittedEntity;
                l = (Long)object[i];
                try {
                    sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l);
                }
                catch (NotFoundException notFoundException) {
                    this.jobsToResume.remove(l);
                    TriggerThread.doTrace(this.cEnv, "Submitted Entity " + l + "not found (" + notFoundException.toString() + ")", -1);
                    continue;
                }
                if (sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 0) continue;
                Long l4 = sDMSSubmittedEntity.getResumeTs(systemEnvironment);
                if (l4 != null) {
                    long l5 = l4;
                    if (l5 <= l2) {
                        this.jobsToResume.remove(l);
                        ((Vector)object2).add(l);
                        sDMSSubmittedEntity.resume(systemEnvironment, false);
                        ++n;
                        SDMSAuditTrailTable.table.create(systemEnvironment, this.cEnv.uid(), new Date().getTime(), SDMSConstants.AT_RESUME, SDMSConstants.AT_JOB, l, l, Boolean.FALSE, null, "Automatic resume");
                        continue;
                    }
                    if (l5 >= this.nextTime) continue;
                    this.nextTime = l5;
                    continue;
                }
                TriggerThread.doTrace(this.cEnv, "Submitted Entity " + l + " has resumeTs == null", 1);
            }
        }
        catch (SerializationException serializationException) {
            this.jobsToResume.addAll((Collection)object2);
            throw serializationException;
        }
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.release(systemEnvironment, this.jobsToResume);
        }
        TriggerThread.doTrace(this.cEnv, "End Resuming Jobs (" + n + " jobs resumed)", 2);
        l2 = System.currentTimeMillis();
        this.wakeupInterval = l2 + (long)this.maxWakeupInterval > this.nextTime ? Math.max((int)(this.nextTime - l2), 0) : this.maxWakeupInterval;
    }

    public void removeFromJobsToResume(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this.jobsToResume, 1);
        }
        this.jobsToResume.remove(l);
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.release(systemEnvironment, this.jobsToResume);
        }
    }

    public void addToJobsToResume(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.lock(systemEnvironment, this.jobsToResume, 1);
        }
        this.jobsToResume.add(l);
        if (SystemEnvironment.maxWriter > 1) {
            LockingSystem.release(systemEnvironment, this.jobsToResume);
        }
    }

    public void checkSingleTrigger(SystemEnvironment systemEnvironment, SDMSTriggerQueue sDMSTriggerQueue, long l) throws SDMSException {
        long l2 = sDMSTriggerQueue.getNextTriggerTime(systemEnvironment);
        if (l2 <= l) {
            int n;
            Long l3 = sDMSTriggerQueue.getTrId(systemEnvironment);
            SDMSTrigger sDMSTrigger = SDMSTriggerTable.getObject(systemEnvironment, l3);
            Long l4 = sDMSTriggerQueue.getSmeId(systemEnvironment);
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, l4);
            int n2 = sDMSTrigger.getType(systemEnvironment);
            if (n2 == 5 && ((n = sDMSSubmittedEntity.getState(systemEnvironment).intValue()) == 11 || (n == 8 || n == 9) && sDMSSubmittedEntity.getJobEsdId(systemEnvironment) != null || n == 14)) {
                return;
            }
            Long l5 = sDMSSubmittedEntity.getFinalEsdId(systemEnvironment);
            sDMSTrigger.trigger(systemEnvironment, l5, l4, sDMSTriggerQueue, sDMSSubmittedEntity);
        } else if (l2 < this.nextTime) {
            this.nextTime = l2;
        }
    }
}

